/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoComparator;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoUploader;
import cgdp.recog.info.cluster.ClusterInfoUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.AbstractServerConnection;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.SimpleServerConnection;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterInfoUploadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterInfoUploadExecuter.class);
    private Component parent;
    private ClusterTbl clusterTbl;
    private Collection clusterInfoTitleC;
    private Set unableUploadTitleSet = new HashSet();
    private boolean execDone = true;

    public ClusterInfoUploadExecuter(Component component, Collection collection, ClusterTbl clusterTbl) {
        this.parent = component;
        this.clusterInfoTitleC = collection;
        this.clusterTbl = clusterTbl;
    }

    public void setExecDone(boolean bl) {
        this.execDone = bl;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(this.clusterInfoTitleC.size());
        Iterator iterator = this.clusterInfoTitleC.iterator();
        while (iterator.hasNext()) {
            Object object;
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.increment();
            ClusterInfoTitle clusterInfoTitle = (ClusterInfoTitle)iterator.next();
            try {
                Map map = ClusterInfoFacade.createClusterInfoMap(this.clusterTbl.getClusterList(), clusterInfoTitle, ClusterInfoFacade.createClusterInfoCalcCondition(this.clusterTbl));
                if (MapUtil.isNull(map)) continue;
                this.setId(map, clusterInfoTitle);
                object = new ArrayList(map.values());
                Collections.sort((List)object, new InfoComparator(ClusterInfoTitle.TITLE_ID));
                ClusterInfoUploader clusterInfoUploader = new ClusterInfoUploader(clusterInfoTitle, (List)object, this.clusterTbl.getClusterId(), "");
                clusterInfoUploader.execute();
                if (clusterInfoUploader.isErrorAlreadyExist()) {
                    Object object2;
                    if (!MessageManager.showConfirmMessage(this.parent, "Overwrite [" + clusterInfoTitle.getName() + "] ?")) {
                        object2 = "Fail to upload cluster property. " + clusterInfoTitle.getName();
                        this.setError(clusterInfoTitle, (String)object2);
                        continue;
                    }
                    object2 = new ClusterInfoUploader(clusterInfoTitle, (List)object, this.clusterTbl.getClusterId(), "replace");
                    ((SimpleServerConnection)object2).execute();
                    if (!((AbstractServerConnection)object2).isError()) continue;
                    this.setError(clusterInfoTitle, ((AbstractServerConnection)object2).getMessage());
                    continue;
                }
                if (!clusterInfoUploader.isError()) continue;
                this.setError(clusterInfoTitle, clusterInfoUploader.getMessage());
            }
            catch (Exception exception) {
                object = "Fail to upload cluster property. " + clusterInfoTitle.getName();
                this.setError(clusterInfoTitle, (String)object);
            }
        }
    }

    private void setError(AbstractInfoTitle abstractInfoTitle, String string) {
        String string2 = "Fail to upload cluster property. property=" + abstractInfoTitle.getName();
        logger.warn(string2);
        this.unableUploadTitleSet.add(abstractInfoTitle);
    }

    private void setId(Map map, ClusterInfoTitle clusterInfoTitle) {
        for (Cluster cluster : map.keySet()) {
            String string = ClusterInfoUtil.getClusterInfoKey(cluster, clusterInfoTitle.getInfoType());
            ClusterInfo clusterInfo = (ClusterInfo)map.get(cluster);
            clusterInfo.putInfo(ClusterInfoTitle.TITLE_ID, string);
        }
    }

    public Set getUnableUploadTitleSet() {
        return this.unableUploadTitleSet;
    }

    @Override
    public void done() {
        String[] stringArray;
        if (!this.execDone) {
            return;
        }
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (!CollectionUtil.isNull(this.unableUploadTitleSet)) {
            stringArray = new String[]{"The following cluster property was not able to be uploaded.", InfoUtil.createInfoTitleNameString(this.unableUploadTitleSet)};
            MessageManager.showWarningMessage(this.parent, stringArray);
        }
        if ((stringArray = this.getAfterRunnable()) != null) {
            stringArray.run();
        }
    }
}

