/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeTbl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.DataManager;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoExporter;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFastImporter;
import cgdp.recog.info.gene.GeneInfoListExporter;
import cgdp.recog.info.gene.GeneInfoListImporter;
import cgdp.recog.info.gene.GeneInfoManager;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoTitleComparator;
import cgdp.recog.info.gene.GeneInfoTitleListDownloader;
import cgdp.recog.info.gene.GeneInfoTypeValidater;
import cgdp.recog.info.gene.GeneInfoUniter;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneInfoFacade {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoFacade.class);

    public static List getGlobalGeneInfoTitleList(String string) throws Exception {
        String string2 = DataManager.getGeneFilePath(string);
        GeneInfoListImporter geneInfoListImporter = GeneInfoListImporter.createRegisterGeneInfoImporter(string2, "Global");
        geneInfoListImporter.setHeaderOnly(true);
        geneInfoListImporter.execute();
        return geneInfoListImporter.getInfoTitleList();
    }

    public static List getUserDefGeneInfoTitleList(String string) throws Exception {
        List list = ModifiedOrganismManager.getInstance().getSystemOrganismCodeList(string);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (Object object : list) {
            Object object2 = DataManager.getUserDefDataGeneInfoFilepath((String)object);
            hashSet.addAll(GeneInfoFacade.importUserDefGeneInfoTitleList((String)object2, "Global"));
            Project project = ProjectAccesser.getSelectedProject();
            Object object3 = DataManager.getUserDefProjectGeneInfoFilepath((String)object);
            List list2 = GeneInfoFacade.importUserDefGeneInfoTitleList((String)object3, project.getProjectName());
            if (CollectionUtil.isNull(list2)) continue;
            hashSet2.addAll(list2);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        for (Object object2 : hashSet2) {
            for (Object object3 : hashSet) {
                if (!((GeneInfoTitle)object3).equals(object2)) continue;
                arrayList.remove(object3);
            }
            arrayList.add(object2);
        }
        Collections.sort(arrayList, new GeneInfoTitleComparator());
        return arrayList;
    }

    public static List importUserDefGeneInfoTitleList(String string, String string2) throws Exception {
        if (!new File(string).isFile()) {
            return new ArrayList();
        }
        GeneInfoListImporter geneInfoListImporter = GeneInfoListImporter.createRegisterGeneInfoImporter(string, string2);
        geneInfoListImporter.setHeaderOnly(true);
        geneInfoListImporter.execute();
        return geneInfoListImporter.getInfoTitleList();
    }

    public static Map getGlobalGeneInfoMap(String string) throws Exception {
        return GeneInfoFacade.getGlobalGeneInfoMap(string, null);
    }

    public static Map getGlobalGeneInfoMap(String string, Set set) throws Exception {
        String string2 = DataManager.getGeneFilePath(string);
        GeneInfoListImporter geneInfoListImporter = GeneInfoListImporter.createRegisterGeneInfoImporter(string2, "Global");
        if (!CollectionUtil.isNull(set)) {
            geneInfoListImporter.setTargetLocusTagSet(set);
        }
        geneInfoListImporter.execute();
        Map map = geneInfoListImporter.getGeneInfoMap();
        List list = (List)map.get(string);
        return GeneInfoUtil.createLocusTagGeneInfoMap(list);
    }

    public static Map getSingleGlobalGeneInfoMap(String string, String string2) throws Exception {
        String string3 = DataManager.getGeneFilePath(string);
        GeneInfoListImporter geneInfoListImporter = GeneInfoListImporter.createGeneInfoImporter(string3, "Global", string2);
        geneInfoListImporter.execute();
        Map map = geneInfoListImporter.getGeneInfoMap();
        List list = (List)map.get(string);
        return GeneInfoUtil.createLocusTagGeneInfoMap(list);
    }

    public static Map getUserDefGeneInfoMap(String string) throws Exception {
        Project project = ProjectAccesser.getSelectedProject();
        return GeneInfoFacade.getUserDefGeneInfoMap(project, string);
    }

    public static Map getUserDefGeneInfoMap(Project project, String string) throws Exception {
        List list = ModifiedOrganismManager.getInstance().getSystemOrganismCodeList(string);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (String string2 : list) {
            Project project2;
            String string3 = DataManager.getUserDefDataGeneInfoFilepath(string2);
            hashSet.addAll(GeneInfoFacade.getUserDefGeneInfoList(string3, string2, "Global"));
            String string4 = DataManager.getUserDefProjectGeneInfoFilepath(project, string2);
            List list2 = GeneInfoFacade.getUserDefGeneInfoList(string4, string2, (project2 = ProjectAccesser.getSelectedProject()).getProjectName());
            if (CollectionUtil.isNull(list2)) continue;
            hashSet2.addAll(list2);
        }
        if (hashSet == null && hashSet2 == null) {
            return new HashMap();
        }
        if (hashSet != null && hashSet2 == null) {
            return GeneInfoUtil.createLocusTagGeneInfoMap(hashSet);
        }
        if (hashSet == null && hashSet2 != null) {
            return GeneInfoUtil.createLocusTagGeneInfoMap(hashSet2);
        }
        List list3 = GeneInfoUniter.joinGeneInfo(hashSet2, hashSet);
        return GeneInfoUtil.createLocusTagGeneInfoMap(list3);
    }

    public static Map getUserDefGeneInfoMap(String string, Set set) throws Exception {
        List list = ModifiedOrganismManager.getInstance().getSystemOrganismCodeList(string);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (String string2 : list) {
            Project project;
            String string3 = DataManager.getUserDefDataGeneInfoFilepath(string2);
            hashSet.addAll(GeneInfoFacade.getUserDefGeneInfoList(string3, string2, set, "Global"));
            String string4 = DataManager.getUserDefProjectGeneInfoFilepath(string2);
            List list2 = GeneInfoFacade.getUserDefGeneInfoList(string4, string2, set, (project = ProjectAccesser.getSelectedProject()).getProjectName());
            if (CollectionUtil.isNull(list2)) continue;
            hashSet2.addAll(list2);
        }
        if (hashSet == null && hashSet2 == null) {
            return new HashMap();
        }
        if (hashSet != null && hashSet2 == null) {
            return GeneInfoUtil.createLocusTagGeneInfoMap(hashSet);
        }
        if (hashSet == null && hashSet2 != null) {
            return GeneInfoUtil.createLocusTagGeneInfoMap(hashSet2);
        }
        List list3 = GeneInfoUniter.joinGeneInfo(hashSet2, hashSet);
        return GeneInfoUtil.createLocusTagGeneInfoMap(list3);
    }

    public static Map getSingleUserDefGeneInfoMap(String string, String string2) throws Exception {
        List list = ModifiedOrganismManager.getInstance().getSystemOrganismCodeList(string);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (String string3 : list) {
            Project project;
            String string4 = DataManager.getUserDefDataGeneInfoFilepath(string3);
            hashSet.addAll(GeneInfoFacade.getSingleUserDefGeneInfoList(string4, string3, "Global", string2));
            String string5 = DataManager.getUserDefProjectGeneInfoFilepath(string3);
            List list2 = GeneInfoFacade.getSingleUserDefGeneInfoList(string5, string3, (project = ProjectAccesser.getSelectedProject()).getProjectName(), string2);
            if (CollectionUtil.isNull(list2)) continue;
            hashSet2.addAll(list2);
        }
        if (hashSet == null && hashSet2 == null) {
            return new HashMap();
        }
        if (hashSet != null && hashSet2 == null) {
            return GeneInfoUtil.createLocusTagGeneInfoMap(hashSet);
        }
        if (hashSet == null && hashSet2 != null) {
            return GeneInfoUtil.createLocusTagGeneInfoMap(hashSet2);
        }
        List list3 = GeneInfoUniter.joinGeneInfo(hashSet2, hashSet);
        return GeneInfoUtil.createLocusTagGeneInfoMap(list3);
    }

    private static List getUserDefGeneInfoList(String string, String string2, String string3) throws Exception {
        if (!new File(string).isFile()) {
            return new ArrayList();
        }
        GeneInfoListImporter geneInfoListImporter = GeneInfoListImporter.createRegisterGeneInfoImporter(string, string3);
        geneInfoListImporter.execute();
        Map map = geneInfoListImporter.getGeneInfoMap();
        List list = (List)map.get(string2);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    private static List getUserDefGeneInfoList(String string, String string2, Set set, String string3) throws Exception {
        if (!new File(string).isFile()) {
            return new ArrayList();
        }
        GeneInfoListImporter geneInfoListImporter = GeneInfoListImporter.createRegisterGeneInfoImporter(string, string3);
        geneInfoListImporter.setTargetLocusTagSet(set);
        geneInfoListImporter.execute();
        Map map = geneInfoListImporter.getGeneInfoMap();
        List list = (List)map.get(string2);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    private static List getSingleUserDefGeneInfoList(String string, String string2, String string3, String string4) throws Exception {
        if (!new File(string).isFile()) {
            return new ArrayList();
        }
        GeneInfoListImporter geneInfoListImporter = GeneInfoListImporter.createRegisterGeneInfoImporter(string, string3);
        geneInfoListImporter.setTargetLocusTag(string4);
        geneInfoListImporter.execute();
        Map map = geneInfoListImporter.getGeneInfoMap();
        List list = (List)map.get(string2);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public static Map createGeneInfoMap(List list, String string, AbstractInfoTitle abstractInfoTitle) throws Exception {
        HashSet<AbstractInfoTitle> hashSet = new HashSet<AbstractInfoTitle>();
        hashSet.add(abstractInfoTitle);
        return GeneInfoFacade.createGeneInfoMap(list, string, hashSet);
    }

    public static Map createGeneInfoMap(List list, String string, Collection collection) throws Exception {
        return GeneInfoFacade.createGeneInfoMap(list, string, collection, false);
    }

    public static Map createGeneInfoMap(List list, String string, Collection collection, boolean bl) throws Exception {
        ChromosomeTbl chromosomeTbl = null;
        if (GeneInfoFacade.isNeedChromosomeTbl(collection)) {
            chromosomeTbl = new ChromosomeTbl(string);
            chromosomeTbl.read();
        }
        Map map = new HashMap();
        Set set = GeneInfoFacade.getGeneInfoTitleForImportSet(collection);
        if (GeneInfoFacade.containsGlobalGeneInfoTitle(string, set)) {
            map = GeneInfoFacade.getGlobalGeneInfoMap(string);
        }
        Map map2 = new HashMap();
        if (GeneInfoFacade.containsUserDefGeneInfoTitle(string, set)) {
            map2 = GeneInfoFacade.getUserDefGeneInfoMap(string);
        }
        Map map3 = GeneInfoFacade.joinGeneInfoMap(list, string, set, collection, map, map2, chromosomeTbl, bl);
        Set set2 = InfoUtil.filterByCategory(set, 5);
        if (!CollectionUtil.isNull(set2)) {
            for (Cluster cluster : list) {
                List list2 = bl ? cluster.getLocusTagList(string) : cluster.getLocusTagWithoutDomainList(string);
                if (CollectionUtil.isNull(list2)) continue;
                for (String string2 : list2) {
                    GeneInfo geneInfo = (GeneInfo)map3.get(string2);
                    if (geneInfo == null) {
                        geneInfo = new GeneInfo();
                        map3.put(string2, geneInfo);
                    }
                    GeneInfoFacade.getCachedGeneInfo(string, GeneUtil.removeDomainNo(string2), geneInfo, set2);
                }
            }
        }
        return map3;
    }

    public static GeneInfo createGeneInfo(String string, String string2, GeneInfoTitle geneInfoTitle) throws Exception {
        HashSet<GeneInfoTitle> hashSet = new HashSet<GeneInfoTitle>();
        hashSet.add(geneInfoTitle);
        return GeneInfoFacade.createGeneInfo(string, string2, hashSet);
    }

    public static GeneInfo createGeneInfo(String string, String string2, Collection collection) throws Exception {
        Object object;
        ChromosomeTbl chromosomeTbl = null;
        if (GeneInfoFacade.isNeedChromosomeTbl(collection)) {
            chromosomeTbl = new ChromosomeTbl(string);
            chromosomeTbl.read();
        }
        Map map = new HashMap();
        Set set = GeneInfoFacade.getGeneInfoTitleForImportSet(collection);
        if (GeneInfoFacade.containsGlobalGeneInfoTitle(string, set)) {
            map = GeneInfoFacade.getSingleGlobalGeneInfoMap(string, string2);
        }
        Map map2 = new HashMap();
        if (GeneInfoFacade.containsUserDefGeneInfoTitle(string, set)) {
            map2 = GeneInfoFacade.getSingleUserDefGeneInfoMap(string, string2);
        }
        GeneInfo geneInfo = new GeneInfo();
        GeneInfo geneInfo2 = (GeneInfo)map.get(string2);
        GeneInfo geneInfo3 = (GeneInfo)map2.get(string2);
        if (geneInfo2 != null && geneInfo3 == null) {
            geneInfo = geneInfo2;
        } else if (geneInfo2 == null && geneInfo3 != null) {
            geneInfo = geneInfo3;
        } else if (geneInfo2 != null && geneInfo3 != null) {
            geneInfo2.putAllInfo(geneInfo3);
            geneInfo = geneInfo2;
        }
        if (collection.contains(GeneInfoTitle.TITLE_ORGANISM_CODE)) {
            geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string);
        }
        if (collection.contains(GeneInfoTitle.TITLE_CHROMOSOME)) {
            try {
                object = GeneInfoFacade.getChromosomeName(geneInfo, chromosomeTbl);
                geneInfo.putInfo(GeneInfoTitle.TITLE_CHROMOSOME, object);
            }
            catch (Exception exception) {
                logger.warn("Fail to get chromosome name. OrganismCode:" + string + " LocusTag:" + string2, exception);
            }
        }
        if (collection.contains(GeneInfoTitle.TITLE_STRAND)) {
            object = GeneInfoFacade.getStrandName(geneInfo);
            geneInfo.putInfo(GeneInfoTitle.TITLE_STRAND, object);
        }
        if (!CollectionUtil.isNull((Collection)(object = InfoUtil.filterByCategory(collection, 5)))) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                GeneInfoTitle geneInfoTitle = (GeneInfoTitle)iterator.next();
                Object object2 = GeneInfoFacade.getValue(string, string2, geneInfoTitle);
                if (object2 == null) continue;
                geneInfo.putInfo(geneInfoTitle, object2);
            }
        }
        geneInfo.retailAllInfo(collection);
        return geneInfo;
    }

    private static void getCachedGeneInfo(String string, String string2, GeneInfo geneInfo, Collection collection) {
        if (CollectionUtil.isNull(collection)) {
            return;
        }
        for (GeneInfoTitle geneInfoTitle : collection) {
            Object object = GeneInfoFacade.getValue(string, string2, geneInfoTitle);
            if (object == null) continue;
            geneInfo.putInfo(geneInfoTitle, object);
        }
    }

    public static List getGeneInfoList(Collection collection, Collection collection2) throws Exception {
        boolean bl = collection2.contains(GeneInfoTitle.TITLE_CHROMOSOME);
        boolean bl2 = collection2.contains(GeneInfoTitle.TITLE_STRAND);
        Set set = InfoUtil.filterByCategory(collection2, 5);
        Map map = GeneInfoUtil.createOrganismCodeLocusTagListMap(collection);
        Set set2 = GeneInfoFacade.getGeneInfoTitleForImportSet(collection2);
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        for (String string : map.keySet()) {
            List list = (List)map.get(string);
            ChromosomeTbl chromosomeTbl = null;
            if (bl) {
                chromosomeTbl = new ChromosomeTbl(string);
                chromosomeTbl.read();
            }
            Map map2 = new HashMap();
            if (GeneInfoFacade.containsGlobalGeneInfoTitle(string, set2)) {
                map2 = GeneInfoFacade.getGlobalGeneInfoMap(string, new HashSet(list));
            }
            Map map3 = new HashMap();
            if (GeneInfoFacade.containsUserDefGeneInfoTitle(string, set2)) {
                map3 = GeneInfoFacade.getUserDefGeneInfoMap(string, new HashSet(list));
            }
            for (String string2 : list) {
                String string3;
                GeneInfo geneInfo = new GeneInfo();
                GeneInfo geneInfo2 = (GeneInfo)map2.get(string2);
                GeneInfo geneInfo3 = (GeneInfo)map3.get(string2);
                if (geneInfo2 != null && geneInfo3 == null) {
                    geneInfo = geneInfo2;
                } else if (geneInfo2 == null && geneInfo3 != null) {
                    geneInfo = geneInfo3;
                } else if (geneInfo2 != null && geneInfo3 != null) {
                    geneInfo2.putAllInfo(geneInfo3);
                    geneInfo = geneInfo2;
                }
                if (collection2.contains(GeneInfoTitle.TITLE_ORGANISM_CODE)) {
                    geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string);
                }
                if (bl) {
                    string3 = GeneInfoFacade.getChromosomeName(geneInfo, chromosomeTbl);
                    geneInfo.putInfo(GeneInfoTitle.TITLE_CHROMOSOME, string3);
                }
                if (bl2) {
                    string3 = GeneInfoFacade.getStrandName(geneInfo);
                    geneInfo.putInfo(GeneInfoTitle.TITLE_STRAND, string3);
                }
                GeneInfoFacade.getCachedGeneInfo(string, string2, geneInfo, set);
                geneInfo.retailAllInfo(collection2);
                if (!geneInfo.isExistValue()) continue;
                arrayList.add(geneInfo);
            }
        }
        return arrayList;
    }

    public static GeneInfo getGeneInfo(String string, String string2) throws Exception {
        List list = GeneInfoFacade.createSelectableGeneInfoTitleList(string);
        return GeneInfoFacade.createGeneInfo(string, string2, list);
    }

    public static List getLocusTagList(String string) throws IOException {
        String string2 = DataManager.getGeneFilePath(string);
        GeneInfoFastImporter geneInfoFastImporter = GeneInfoFastImporter.createGeneInfoFastImporter(string2, GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
        geneInfoFastImporter.execute();
        List list = geneInfoFastImporter.getGeneInfoList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GeneInfo geneInfo : list) {
            String string3 = geneInfo.getLocusTag();
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static List createValueList(List list, String string, GeneInfoTitle geneInfoTitle) throws Exception {
        if (geneInfoTitle.isMulti()) {
            return GeneInfoFacade.createMultiValueList(list, string, geneInfoTitle);
        }
        return GeneInfoFacade.createSingleValueList(list, string, geneInfoTitle);
    }

    private static List createSingleValueList(List list, String string, GeneInfoTitle geneInfoTitle) throws Exception {
        Map map = GeneInfoFacade.createGeneInfoMap(list, string, geneInfoTitle);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (GeneInfo geneInfo : map.values()) {
            Object object = geneInfo.getInfo(geneInfoTitle);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    private static List createMultiValueList(List list, String string, GeneInfoTitle geneInfoTitle) throws Exception {
        Map map = GeneInfoFacade.createGeneInfoMap(list, string, geneInfoTitle);
        HashSet hashSet = new HashSet();
        for (GeneInfo geneInfo : map.values()) {
            List list2 = geneInfo.getMultiInfo(geneInfoTitle);
            if (CollectionUtil.isNull(list2)) continue;
            hashSet.addAll(list2);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private static boolean isNeedChromosomeTbl(Collection collection) {
        boolean bl = false;
        for (AbstractInfoTitle abstractInfoTitle : collection) {
            if (!abstractInfoTitle.equalsKey("chromosome")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static Set getGeneInfoTitleForImportSet(Collection collection) {
        HashSet<AbstractInfoTitle> hashSet = new HashSet<AbstractInfoTitle>();
        for (AbstractInfoTitle abstractInfoTitle : collection) {
            if (abstractInfoTitle.equalsKey("chromosome")) {
                hashSet.add(GeneInfoTitle.TITLE_CHRID);
                continue;
            }
            hashSet.add(abstractInfoTitle);
        }
        return hashSet;
    }

    private static boolean containsGlobalGeneInfoTitle(String string, Collection collection) throws Exception {
        List list = GeneInfoFacade.getGlobalGeneInfoTitleList(string);
        for (GeneInfoTitle geneInfoTitle : list) {
            if (!collection.contains(geneInfoTitle)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsUserDefGeneInfoTitle(String string, Collection collection) throws Exception {
        List list = GeneInfoFacade.getUserDefGeneInfoTitleList(string);
        for (GeneInfoTitle geneInfoTitle : list) {
            if (!collection.contains(geneInfoTitle)) continue;
            return true;
        }
        return false;
    }

    private static Map joinGeneInfoMap(List list, String string, Set set, Collection collection, Map map, Map map2, ChromosomeTbl chromosomeTbl, boolean bl) {
        boolean bl2 = collection.contains(GeneInfoTitle.TITLE_CHROMOSOME);
        boolean bl3 = collection.contains(GeneInfoTitle.TITLE_STRAND);
        HashMap<String, GeneInfo> hashMap = new HashMap<String, GeneInfo>();
        for (Cluster cluster : list) {
            List list2 = cluster.getLocusTagList(string);
            if (list2 == null) continue;
            for (String string2 : list2) {
                String string3;
                String string4 = GeneUtil.removeDomainNo(string2);
                GeneInfo geneInfo = (GeneInfo)map.get(string4);
                GeneInfo geneInfo2 = (GeneInfo)map2.get(string4);
                GeneInfo geneInfo3 = new GeneInfo();
                if (geneInfo != null) {
                    geneInfo3.putAllInfo(geneInfo);
                }
                if (geneInfo2 != null) {
                    geneInfo3.putAllInfo(geneInfo2);
                }
                geneInfo3.retailAllInfo(set);
                if (bl2) {
                    string3 = GeneInfoFacade.getChromosomeName(geneInfo3, chromosomeTbl);
                    geneInfo3.putInfo(GeneInfoTitle.TITLE_CHROMOSOME, string3);
                }
                if (bl3) {
                    string3 = GeneInfoFacade.getStrandName(geneInfo3);
                    geneInfo3.putInfo(GeneInfoTitle.TITLE_STRAND, string3);
                }
                if (!geneInfo3.isExistValue()) continue;
                if (bl) {
                    hashMap.put(string2, geneInfo3);
                    continue;
                }
                hashMap.put(string4, geneInfo3);
            }
        }
        return hashMap;
    }

    public static String getChromosomeName(GeneInfo geneInfo, ChromosomeTbl chromosomeTbl) {
        String string = String.valueOf(geneInfo.getInfo(GeneInfoTitle.TITLE_CHRID));
        Chromosome chromosome = (Chromosome)chromosomeTbl.get(string);
        if (chromosome == null) {
            return "";
        }
        return chromosome.getDisplayName();
    }

    public static String getStrandName(GeneInfo geneInfo) {
        try {
            int n = Integer.parseInt(String.valueOf(geneInfo.getInfo(GeneInfoTitle.TITLE_STRAND)));
            return GeneUtil.getDisplayDirection(n);
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
    }

    private static List createGlobalGeneInfoTitleList() {
        List list = GeneInfoFacade.getGeneInfoTitleList();
        list.remove(GeneInfoTitle.TITLE_ORGANISM_CODE);
        list.remove(GeneInfoTitle.TITLE_TYPE);
        HashSet<GeneInfoTitle> hashSet = new HashSet<GeneInfoTitle>();
        for (GeneInfoTitle geneInfoTitle : list) {
            if (LocationType.isNameGlobal(geneInfoTitle.getLocationName())) continue;
            hashSet.add(geneInfoTitle);
        }
        list.removeAll(hashSet);
        return list;
    }

    public static List createSelectableGeneInfoTitleList(String string) {
        List list = GeneInfoFacade.createGlobalGeneInfoTitleList();
        try {
            List list2 = GeneInfoFacade.getUserDefGeneInfoTitleList(string);
            if (!CollectionUtil.isNull(list2)) {
                for (int i = list2.size() - 1; i >= 0; --i) {
                    GeneInfoTitle geneInfoTitle = (GeneInfoTitle)list2.get(i);
                    if (geneInfoTitle.isSp() || geneInfoTitle.isLocusTag()) {
                        list2.remove(i);
                        continue;
                    }
                    if (!list.contains(geneInfoTitle)) continue;
                    list2.remove(i);
                }
                list.addAll(list2);
            }
        }
        catch (Exception exception) {
            logger.warn("Fail to load user's defined gene information file.", exception);
        }
        return list;
    }

    public static Map createSelectableGeneInfoTitleMap() {
        List list = GeneInfoFacade.getGeneInfoTitleList();
        HashMap<String, GeneInfoTitle> hashMap = new HashMap<String, GeneInfoTitle>();
        for (GeneInfoTitle geneInfoTitle : list) {
            hashMap.put(geneInfoTitle.getKey(), geneInfoTitle);
        }
        return hashMap;
    }

    public static List getServerSearchGeneInfoTitleList() {
        List list = GeneInfoFacade.getGeneInfoTitleList();
        System.out.println("AAA:" + list);
        ArrayList<GeneInfoTitle> arrayList = new ArrayList<GeneInfoTitle>();
        for (GeneInfoTitle geneInfoTitle : list) {
            if (!geneInfoTitle.isServerSearchEnable()) continue;
            arrayList.add(geneInfoTitle);
        }
        return arrayList;
    }

    public static List getGeneInfoTitleList() {
        return GeneInfoManager.getInstance().getInfoTitleList();
    }

    public static List getGeneInfoTitleList(String string) {
        try {
            List list = ModifiedOrganismManager.getInstance().getSystemOrganismCodeList(string);
            List list2 = GeneInfoFacade.getGeneInfoTitleList();
            ArrayList<GeneInfoTitle> arrayList = new ArrayList<GeneInfoTitle>();
            for (GeneInfoTitle geneInfoTitle : list2) {
                if (LocationType.isNameGlobal(geneInfoTitle.getLocationName()) || LocationType.isNameSystem(geneInfoTitle.getLocationName())) {
                    arrayList.add(geneInfoTitle);
                    continue;
                }
                if (!geneInfoTitle.containsOrganismCode(list)) continue;
                arrayList.add(geneInfoTitle);
            }
            return arrayList;
        }
        catch (Exception exception) {
            logger.warn("Fail to load gene_info.", exception);
            return new ArrayList();
        }
    }

    public static List getGeneInfoTitleList(Collection collection) {
        ArrayList<GeneInfoTitle> arrayList = new ArrayList<GeneInfoTitle>();
        for (String string : collection) {
            List list = GeneInfoFacade.createSelectableGeneInfoTitleList(string);
            for (GeneInfoTitle geneInfoTitle : list) {
                if (arrayList.contains(geneInfoTitle)) continue;
                arrayList.add(geneInfoTitle);
            }
        }
        return arrayList;
    }

    public static GeneInfoTitle getGeneInfoTitle(Set set, String string) {
        GeneInfoTitle geneInfoTitle = null;
        block0: for (String string2 : set) {
            List list = GeneInfoFacade.createSelectableGeneInfoTitleList(string2);
            for (GeneInfoTitle geneInfoTitle2 : list) {
                if (!geneInfoTitle2.equalsKey(string)) continue;
                geneInfoTitle = geneInfoTitle2;
                continue block0;
            }
        }
        return geneInfoTitle;
    }

    public static List getCommonGeneInfoTitleList(Set set) {
        ArrayList arrayList = new ArrayList();
        for (String string : set) {
            List list = GeneInfoFacade.createSelectableGeneInfoTitleList(string);
            if (CollectionUtil.isNull(arrayList)) {
                arrayList.addAll(list);
                continue;
            }
            arrayList.retainAll(list);
        }
        return arrayList;
    }

    public static void exportGeneInfoList(String string, List list, List list2) throws Exception {
        InfoExporter infoExporter = GeneInfoListExporter.createExternalExporter(string, list2, list);
        infoExporter.execute();
    }

    public static void exportGeneInfoList(String string, List list, List list2, Map map) throws Exception {
        InfoExporter infoExporter = GeneInfoListExporter.createExternalExporter(string, list2, list);
        infoExporter.setParameterMap(map);
        infoExporter.execute();
    }

    public static void exportTitleList(List list) throws IOException {
        GeneInfoManager.getInstance().exportTitleList(list);
    }

    public static void exportTitle(AbstractInfoTitle abstractInfoTitle) throws IOException {
        List list = GeneInfoFacade.getGeneInfoTitleList();
        int n = list.indexOf(abstractInfoTitle);
        if (n != -1) {
            list.remove(n);
            list.add(abstractInfoTitle);
        }
        GeneInfoManager.getInstance().exportTitleList(list);
    }

    public static Object getValue(String string, String string2, GeneInfoTitle geneInfoTitle) {
        Object object = null;
        if (GeneInfoManager.getInstance().isCachedInfoTitle(geneInfoTitle)) {
            object = GeneInfoManager.getInstance().getValue(string, string2, geneInfoTitle);
            if (geneInfoTitle.equalsKey("num_domain") && object == null) {
                object = new Float(1.0f);
            }
        }
        return object;
    }

    public static void clear() {
        GeneInfoManager.getInstance().clear();
    }

    public static void registerNumDomain(List list) {
        GeneInfoManager.getInstance().registerNumDomain(list);
    }

    public static void registerScore(TaxMapModel taxMapModel) {
        GeneInfoManager.getInstance().registerScore(taxMapModel);
    }

    public static GeneInfoTitle getGeneInfoTitle(String string) {
        GeneInfoManager geneInfoManager = GeneInfoManager.getInstance();
        return (GeneInfoTitle)geneInfoManager.getInfoTitle(string);
    }

    public static Object validateInfoValue(AbstractInfoTitle abstractInfoTitle, AbstractInfoTitle abstractInfoTitle2) {
        Set set = ((GeneInfoTitle)abstractInfoTitle).getOrganismCodeSet();
        for (String string : set) {
            try {
                Map map = GeneInfoFacade.getUserDefGeneInfoMap(string);
                for (GeneInfo geneInfo : map.values()) {
                    Object object = geneInfo.getInfo(abstractInfoTitle);
                    if (GeneInfoTypeValidater.validateValue(abstractInfoTitle2, object)) continue;
                    return object;
                }
            }
            catch (Exception exception) {
                String string2 = "Fail to load gene propery file. " + string;
                logger.warn(string2, exception);
            }
        }
        return null;
    }

    public static boolean validateInfoTitle(Component component, List list) {
        List list2 = GeneInfoFacade.getGeneInfoTitleList();
        return GeneInfoFacade.validateInfoTitle(component, list, list2);
    }

    public static boolean validateInfoTitle(Component component, List list, List list2) {
        HashSet hashSet = new HashSet();
        HashSet<String[]> hashSet2 = new HashSet<String[]>();
        HashSet hashSet3 = new HashSet(GeneInfoTitle.getSystemGeneInfoTitleKeyList());
        hashSet3.remove("sp");
        hashSet3.remove("name");
        for (String[] stringArray : list) {
            String[] stringArray2;
            if (hashSet3.contains(stringArray.getKey())) {
                stringArray2 = new String[]{"This gene property is reserved.", "[" + stringArray.getName() + "]"};
                MessageManager.showErrorMessage(component, stringArray2);
                return false;
            }
            if ((LocationType.isNameGlobal(stringArray.getLocationName()) || LocationType.isNameSystem(stringArray.getLocationName())) && !stringArray.isEditable() || CollectionUtil.isNull((Collection)(stringArray2 = InfoUtil.getInfoTitle(stringArray.getKey(), list2)))) continue;
            for (GeneInfoTitle geneInfoTitle : stringArray2) {
                if (!stringArray.getLocationName().equals(geneInfoTitle.getLocationName()) || !stringArray.containsOrganismCode(geneInfoTitle.getOrganismCodeSet())) continue;
                hashSet2.add(stringArray);
            }
        }
        if (!CollectionUtil.isNull(hashSet)) {
            String[] stringArray;
            String string = StringTool.conbineStrList(InfoUtil.getInfoTitleNameSet(hashSet), ",");
            stringArray = new String[]{"This gene property is reserved.", "[" + (String)string + "]"};
            MessageManager.showErrorMessage(component, stringArray);
            return false;
        }
        return true;
    }

    public static List downloadGeneInfoTitleList(Collection collection, Project project) throws Exception {
        List list = GeneInfoFacade.downloadGeneInfoTitleList(project);
        if (CollectionUtil.isNull(collection)) {
            return list;
        }
        ArrayList<GeneInfoTitle> arrayList = new ArrayList<GeneInfoTitle>();
        for (GeneInfoTitle geneInfoTitle : list) {
            if (!geneInfoTitle.containsOrganismCode(collection)) continue;
            arrayList.add(geneInfoTitle);
        }
        return list;
    }

    private static List downloadGeneInfoTitleList(Project project) throws Exception {
        GeneInfoTitleListDownloader geneInfoTitleListDownloader = new GeneInfoTitleListDownloader(project);
        geneInfoTitleListDownloader.execute();
        return geneInfoTitleListDownloader.getGeneInfoTitleList();
    }
}

