/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.mapping.MapConf;
import cgdp.recog.mapping.MapEditItem;
import cgdp.recog.mapping.MapFacade;
import cgdp.recog.mapping.MapNewItem;
import cgdp.recog.mapping.MapSelectItem;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;

public class MapMenu
extends JMenu {
    private MediatorImpl mediator;
    private ActionListener actionListener;
    private String organismCode;

    public MapMenu(ActionListener actionListener, MediatorImpl mediatorImpl, String string) {
        super("Genome Mapping");
        this.mediator = mediatorImpl;
        this.actionListener = actionListener;
        this.organismCode = string;
        this.createComponents();
    }

    private void createComponents() {
        List list = MapFacade.getMapConfList(this.organismCode);
        if (!StringTool.isNull(this.organismCode) && !CollectionUtil.isNull(list)) {
            JMenu jMenu = new JMenu("Select");
            for (MapConf mapConf : list) {
                MapSelectItem mapSelectItem = new MapSelectItem(this.actionListener, this.mediator, mapConf);
                jMenu.add(mapSelectItem);
            }
            this.add(jMenu);
            this.addSeparator();
        }
        this.add(new MapNewItem(this.actionListener, this.mediator, this.organismCode));
        if (!CollectionUtil.isNull(list)) {
            this.add(new MapEditItem(this.actionListener, this.mediator, this.organismCode));
        }
    }
}

