/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mgmap;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.funccat.FunctionColorUtil;
import java.awt.Color;

class Domain {
    private Cluster cluser;
    private GeneInformation geneInformation;
    private int from;
    private int to;

    Domain(Cluster cluster, GeneInformation geneInformation) {
        this.setCluser(cluster);
        this.setGeneInformation(geneInformation);
        this.setFrom(geneInformation.getFrom());
        this.setTo(geneInformation.getTo());
    }

    void setFrom(int n) {
        this.from = n;
    }

    void setTo(int n) {
        this.to = n;
    }

    int getNo() {
        if (this.geneInformation.isDomain()) {
            return this.geneInformation.getDomainNo();
        }
        return 1;
    }

    public int getClusterId() {
        return this.cluser.getClusterId();
    }

    public Color getFuncCatColor(ClusterTbl clusterTbl, String string) {
        return FunctionColorUtil.getFuncCatColor(this.getFunctionCategoryNoForGeneClass(clusterTbl, this.getCluser(), string));
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public Cluster getCluser() {
        return this.cluser;
    }

    public void setCluser(Cluster cluster) {
        this.cluser = cluster;
    }

    public void setGeneInformation(GeneInformation geneInformation) {
        this.geneInformation = geneInformation;
    }

    public GeneInformation getGeneInformation() {
        return this.geneInformation;
    }

    public String getLocusTag() {
        return this.getGeneInformation().getLocusTag();
    }

    public String getFunctionCategoryNoForGeneClass(ClusterTbl clusterTbl, Cluster cluster, String string) {
        if (clusterTbl.isOutgroup()) {
            if (clusterTbl.isIngroup(string)) {
                return cluster.getSubFunctionCategory();
            }
            return cluster.getFunctionCategory();
        }
        return cluster.getFunctionCategory();
    }
}

