/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.neighbor;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.neighbor.NeighboringClustCondition;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.SliderTextPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NeighborClustDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Neighboring Clusters";
    private SliderTextPanel searchClusterCountPanel;
    private RestrictTextField maxDistSameGroupTextField;
    private JCheckBox recalcCheckBox;
    private JCheckBox hilightCheckBox;
    private ClusterTbl clusterTbl;

    public NeighborClustDialog(Frame frame, ClusterTbl clusterTbl) {
        super(frame);
        this.clusterTbl = clusterTbl;
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.setApplyButtonName("Run");
        this.setCloseButtonName("Cancel");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createConditionPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 5, 0), 0, 0));
        this.initValue();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createConditionPanel() {
        JLabel jLabel = new JLabel("Search range of clusters");
        this.searchClusterCountPanel = new SliderTextPanel();
        this.searchClusterCountPanel.setMinimum(1);
        this.searchClusterCountPanel.setMaximum(20);
        this.searchClusterCountPanel.setTextColumns(3);
        this.searchClusterCountPanel.setPaintTicks(true);
        this.searchClusterCountPanel.setPaintLabels(true);
        this.searchClusterCountPanel.setLabelTable(2);
        JLabel jLabel2 = new JLabel("Range consider to be neighborhood gene");
        this.maxDistSameGroupTextField = new RestrictTextField();
        JPanel jPanel = this.createRecalcPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        jPanel2.add((Component)this.searchClusterCountPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        jPanel2.add((Component)this.maxDistSameGroupTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.createHilighPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        return jPanel2;
    }

    private JPanel createRecalcPanel() {
        this.recalcCheckBox = new JCheckBox("Recalculate when the table is re-sorted");
        this.recalcCheckBox.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.recalcCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createHilighPanel() {
        this.hilightCheckBox = new JCheckBox("Hilight Neighboring Gene");
        this.hilightCheckBox.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.hilightCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void initValue() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        NeighboringClustCondition neighboringClustCondition = optionTbl.getOptionValues().getNeighboringClustCondition();
        this.maxDistSameGroupTextField.setText(String.valueOf(neighboringClustCondition.getMaxDistSameGroup()));
        this.searchClusterCountPanel.setValue(neighboringClustCondition.getSearchClusterCount());
    }

    @Override
    protected boolean check() {
        if (this.getMaxDistSameGroup() <= 0) {
            MessageManager.showErrorMessage((Component)this.getParent(), "Input positive number on \"Range consider to be neighborhood gene\"");
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        NeighboringClustCondition neighboringClustCondition = optionTbl.getOptionValues().getNeighboringClustCondition();
        neighboringClustCondition.setMaxDistSameGroup(this.getMaxDistSameGroup());
        neighboringClustCondition.setSearchClusterCount(this.getSearchClusterCount());
        this.clusterTbl.setHilightNeighboringGene(this.hilightCheckBox.isSelected());
        return true;
    }

    private int getSearchClusterCount() {
        return (int)this.searchClusterCountPanel.getValue();
    }

    private int getMaxDistSameGroup() {
        int n = -1;
        try {
            n = Integer.parseInt(this.maxDistSameGroupTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private boolean isRecalc() {
        return this.recalcCheckBox.isSelected();
    }

    public NeighboringClustCondition createNeighboringClustCondition() {
        NeighboringClustCondition neighboringClustCondition = new NeighboringClustCondition();
        neighboringClustCondition.setSearchClusterCount(this.getSearchClusterCount());
        neighboringClustCondition.setMaxDistSameGroup(this.getMaxDistSameGroup());
        neighboringClustCondition.setRecalc(this.isRecalc());
        return neighboringClustCondition;
    }
}

