/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.auth.Auth;
import cgdp.recog.auth.AuthFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

class AuthOptionPanel
extends TabPanel {
    private static final ApplicationLogger logger = new ApplicationLogger(AuthOptionPanel.class);
    private FocusTextField userNameField;
    private JPasswordField passwordField;

    AuthOptionPanel(Component component) {
        super(component);
        this.init();
    }

    private void init() {
        JPanel jPanel = this.createAuthPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Authentication"));
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 10, 20, 10), 0, 0));
        this.initValue();
    }

    private JPanel createAuthPanel() {
        JLabel jLabel = new JLabel("User Name");
        this.userNameField = new FocusTextField(20);
        JLabel jLabel2 = new JLabel("Password");
        this.passwordField = new JPasswordField(20);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 10), 0, 0));
        jPanel.add((Component)this.userNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)this.passwordField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void initValue() {
        Auth auth = AuthFacade.getAuth();
        if (auth != null) {
            this.userNameField.setText(auth.getUserName());
            this.passwordField.setText(auth.getPassword());
        }
    }

    private String getUserName() {
        return this.userNameField.getText();
    }

    private String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    @Override
    protected void changeDefault() {
    }

    @Override
    public boolean check() {
        return true;
    }

    @Override
    protected void updateParameters() {
        String string = this.getUserName();
        String string2 = this.getPassword();
        Auth auth = new Auth(string, string2);
        try {
            AuthFacade.saveAuth(auth);
            AuthFacade.setAuthenticator();
        }
        catch (IOException iOException) {
            String string3 = "Fail to save authentication information.";
            logger.warn(string3, iOException);
        }
    }
}

