/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.data.GenomeTbl;
import cgdp.recog.data.TaxonomyTbl;
import cgdp.recog.organism.DisplayOrganism;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismComparator;
import cgdp.recog.organism.OrganismSet;
import cgdp.recog.organism.SplitOrganism;
import cgdp.recog.organism.SplitOrganismCodeComparator;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrganismUtil {
    private OrganismUtil() {
    }

    public static List getOrganismCodeList(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Organism organism : collection) {
            arrayList.add(organism.getOrganismCode());
        }
        return arrayList;
    }

    public static Map createOrganismMap(Collection collection) {
        HashMap<String, Organism> hashMap = new HashMap<String, Organism>();
        for (Organism organism : collection) {
            hashMap.put(organism.getOrganismCode(), organism);
        }
        return hashMap;
    }

    public static Map createOrganismNameMap(Collection collection) {
        HashMap<String, Organism> hashMap = new HashMap<String, Organism>();
        for (Organism organism : collection) {
            hashMap.put(organism.getNameForTaxonomy(), organism);
        }
        return hashMap;
    }

    public static List getOrganismList(List list, Collection collection) {
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        Map map = OrganismUtil.createOrganismMap(list);
        for (String string : collection) {
            Organism organism = (Organism)map.get(string);
            if (organism == null) continue;
            arrayList.add(organism);
        }
        return arrayList;
    }

    public static int indexOfOrganism(List list, String string) {
        int n = -1;
        int n2 = 0;
        for (Organism organism : list) {
            if (organism.equalsOrganismCode(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public static List getOrganismList(Collection collection) {
        return OrganismUtil.getOrganismList(collection, true);
    }

    public static List getOrganismList(Collection collection, boolean bl) {
        GenomeTbl genomeTbl = new GenomeTbl();
        List list = genomeTbl.createOrganismList(collection);
        if (bl) {
            OrganismUtil.sortOrganismListByTaxonomy(list);
        }
        return list;
    }

    public static List getOrganismList(Collection collection, int n, boolean bl) {
        List list = OrganismUtil.getOrganismList(collection, bl);
        OrganismUtil.setGroupType(list, n);
        return list;
    }

    private static void setGroupType(List list, int n) {
        for (Organism organism : list) {
            organism.setGroupType(n);
        }
    }

    public static Organism convertDisplayOrganism(Organism organism) {
        if (organism instanceof DisplayOrganism) {
            return organism;
        }
        return new DisplayOrganism(organism);
    }

    public static List convertDisplayOrganismList(List list) {
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        for (Organism organism : list) {
            if (organism instanceof DisplayOrganism) {
                arrayList.add(organism);
                continue;
            }
            arrayList.add(new DisplayOrganism(organism));
        }
        return arrayList;
    }

    public static void sortOrganismListByTaxonomy(List list) {
        TaxonomyTbl taxonomyTbl = new TaxonomyTbl();
        taxonomyTbl.read();
        Collections.sort(list, new OrganismComparator(taxonomyTbl.getGenomeOrganismCodeIndexMap()));
    }

    public static Organism getOrganism(String string) {
        GenomeTbl genomeTbl = new GenomeTbl();
        return genomeTbl.createOrganism(string);
    }

    public static Organism getOrganism(List list, String string) {
        Organism organism = null;
        for (Organism organism2 : list) {
            if (!organism2.equalsOrganismCode(string)) continue;
            organism = organism2;
            break;
        }
        return organism;
    }

    public static Map createOrganismNameMap(Set set) {
        List list = OrganismUtil.getOrganismList(new ArrayList(set));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Organism organism : list) {
            hashMap.put(organism.getOrganismCode(), organism.getNameForTaxonomy());
        }
        return hashMap;
    }

    public static String getOrganismSetNameString(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OrganismSet organismSet : collection) {
            arrayList.add(organismSet.getName());
        }
        return StringTool.conbineStrList(arrayList, ",");
    }

    public static List getEnableMergeOrganismList(Collection collection) {
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        for (Organism organism : collection) {
            if (organism.isTypeSplitOrganism()) continue;
            arrayList.add(organism);
        }
        return arrayList;
    }

    public static List getEnableSplitOrganismList(Collection collection) {
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        for (Organism organism : collection) {
            if (organism.isTypeMergeOrganism()) continue;
            arrayList.add(organism);
        }
        return arrayList;
    }

    public static List extractMergeOrganismList(Collection collection) {
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        for (Organism organism : collection) {
            if (!organism.isTypeMergeOrganism()) continue;
            arrayList.add(organism);
        }
        return arrayList;
    }

    public static List extractSplitOrganismList(Collection collection) {
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        for (Organism organism : collection) {
            if (!organism.isTypeSplitOrganism()) continue;
            arrayList.add(((DisplayOrganism)organism).getOrganism());
        }
        return arrayList;
    }

    public static Map createSplitOrganismListMap(Collection collection) {
        HashMap<Organism, ArrayList<Object>> hashMap = new HashMap<Organism, ArrayList<Object>>();
        for (Object object : collection) {
            Organism organism = ((SplitOrganism)object).getParentOrganism();
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(organism);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(organism, arrayList);
            }
            arrayList.add(object);
        }
        for (Object object : hashMap.values()) {
            Collections.sort(object, new SplitOrganismCodeComparator());
        }
        return hashMap;
    }
}

