/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ppm;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.util.ChartColor;
import cgdp.recog.util.CollectionUtil;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PPMContext {
    public static final int GENE_NAME_CELL_WIDTH = 45;
    private static final double CLUSTER_LABEL_WIDTH = 40.0;
    private static final double CLUSER_LABEL_MARGIN = 5.0;
    public static final Color HIGHLIGHT_COLOR = Color.red;
    public static final Color HIGHLIGHT_SUB_COLOR = Color.orange;
    protected MediatorImpl mediator;
    protected ClusterTbl clusterTbl;
    protected int rows = 0;
    protected int startRow = 0;
    protected int columns = 0;
    protected int column = 0;
    private double imageWidth;
    private double imageHeight;
    private List selectedOrganismAreaList = new ArrayList();
    private List labelColorList;
    private double clusterLabelWidth = 40.0;
    private double clusterLabelMargin = 5.0;
    private double multiClusterMarkSize = 5.0;
    private boolean showHomClustLabel = true;
    private double clusterW = 30.0;
    private double clusterH = 5.0;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double viewportX = 0.0;
    private double viewportY = 0.0;

    public PPMContext() {
        this.init();
    }

    private void init() {
        this.labelColorList = this.createLabelColorList();
    }

    public MediatorImpl getMediator() {
        return this.mediator;
    }

    public void setMediator(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    public ClusterTbl getClusterTbl() {
        return this.clusterTbl;
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int n) {
        this.startRow = n;
    }

    public int getEndRow() {
        return this.getStartRow() + this.getRows();
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public double getMultiClusterMarkSize() {
        return this.multiClusterMarkSize;
    }

    public void clearSelectedOrganismSet() {
        if (this.clusterTbl == null) {
            return;
        }
        this.clusterTbl.getPpmSelectionManager().clearSelectedOrganismSet();
    }

    public void setSelectedOrganismSet(Set set) {
        this.clusterTbl.getPpmSelectionManager().setSelectedOrganismSet(set);
    }

    public Set getSelectedOrganismSet() {
        return this.clusterTbl.getPpmSelectionManager().getSelectedOrganismSet();
    }

    public boolean isExistSelectedOrganism() {
        return this.clusterTbl.getPpmSelectionManager().isExistSelectedOrganism();
    }

    public boolean containsSelectedOrganism(String string) {
        return this.clusterTbl.getPpmSelectionManager().containsSelectedOrganism(string);
    }

    public void clearSelectedOrganismAreaList() {
        this.selectedOrganismAreaList.clear();
    }

    public List getSelectedOrganismAreaList() {
        return this.selectedOrganismAreaList;
    }

    public void setSelectedOrganismAreaList(List list) {
        if (!this.isExistSelectedOrganism()) {
            this.clearSelectedOrganismAreaList();
        } else {
            this.selectedOrganismAreaList.addAll(list);
        }
    }

    public boolean isExistSelectedOrganismArea() {
        return !CollectionUtil.isNull(this.selectedOrganismAreaList);
    }

    public double getClusterLabelWidth() {
        return this.clusterLabelWidth;
    }

    public double getClusterLabelMargin() {
        return this.clusterLabelMargin;
    }

    private List createLabelColorList() {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(Color.gray);
        arrayList.add(ChartColor.DARK_RED);
        arrayList.add(ChartColor.DARK_BLUE);
        arrayList.add(ChartColor.DARK_GREEN);
        arrayList.add(ChartColor.DARK_YELLOW);
        arrayList.add(ChartColor.DARK_MAGENTA);
        arrayList.add(ChartColor.DARK_CYAN);
        arrayList.add(Color.darkGray);
        arrayList.add(ChartColor.LIGHT_RED);
        arrayList.add(ChartColor.LIGHT_BLUE);
        arrayList.add(ChartColor.LIGHT_GREEN);
        arrayList.add(ChartColor.LIGHT_YELLOW);
        arrayList.add(ChartColor.LIGHT_MAGENTA);
        arrayList.add(ChartColor.LIGHT_CYAN);
        arrayList.add(Color.lightGray);
        arrayList.add(ChartColor.VERY_DARK_RED);
        arrayList.add(ChartColor.VERY_DARK_BLUE);
        arrayList.add(ChartColor.VERY_DARK_GREEN);
        arrayList.add(ChartColor.VERY_DARK_YELLOW);
        arrayList.add(ChartColor.VERY_DARK_MAGENTA);
        arrayList.add(ChartColor.VERY_DARK_CYAN);
        arrayList.add(ChartColor.VERY_LIGHT_RED);
        arrayList.add(ChartColor.VERY_LIGHT_BLUE);
        arrayList.add(ChartColor.VERY_LIGHT_GREEN);
        arrayList.add(ChartColor.VERY_LIGHT_YELLOW);
        arrayList.add(ChartColor.VERY_LIGHT_MAGENTA);
        arrayList.add(ChartColor.VERY_LIGHT_CYAN);
        return arrayList;
    }

    public Color getHomClusterLabelColor(int n) {
        int n2 = n % this.labelColorList.size();
        return (Color)this.labelColorList.get(n2);
    }

    public boolean isShowHomClustLabel() {
        return this.showHomClustLabel;
    }

    public void setShowHomClustLabel(boolean bl) {
        this.showHomClustLabel = bl;
    }

    public void setImageWidth(double d) {
        this.imageWidth = d;
    }

    public double getImageWidth() {
        return this.imageWidth;
    }

    public double getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(double d) {
        this.imageHeight = d;
    }

    public boolean isLeftGeneNameArea(int n) {
        return n <= 45;
    }

    public boolean isRightGeneNameArea(int n) {
        if (this.clusterTbl.isExistHomCluster() && this.isShowHomClustLabel()) {
            return (double)n >= this.getImageWidth() - 90.0 && (double)n < this.getImageWidth() - 45.0;
        }
        return (double)n >= this.getImageWidth() - 45.0;
    }

    public boolean isHomClusterArea(int n) {
        if (!this.clusterTbl.isExistHomCluster() || !this.isShowHomClustLabel()) {
            return false;
        }
        return (double)n >= this.getImageWidth() - 45.0;
    }

    public double getCellWidth() {
        List list = this.clusterTbl.getViewOrganismList();
        double d = this.getImageWidth();
        double d2 = this.getXScale(list.size(), this.getColumns(), d);
        double d3 = d2 < 1.0 ? 1.0 : d2;
        return d3;
    }

    public double getCellHeight() {
        double d = this.getImageHeight();
        double d2 = this.getYScale(this.getRows(), d);
        double d3 = d2 < 1.0 ? 1.0 : d2;
        return d3;
    }

    private double getXScale(int n, int n2, double d) {
        double d2 = d;
        OptionTbl optionTbl = OptionTbl.getInstance();
        if (!optionTbl.getOptionValues().isIntensive()) {
            d2 -= this.getClusterLabelWidth() + this.getClusterLabelMargin();
            if (this.clusterTbl.isOutgroup()) {
                d2 -= this.getClusterLabelWidth() + this.getClusterLabelMargin();
            }
            if (this.clusterTbl.isExistHomCluster() && this.isShowHomClustLabel()) {
                d2 -= this.getClusterLabelWidth() + this.getClusterLabelMargin();
            }
        }
        double d3 = n == 0 ? d2 : (n < n2 ? d2 / (double)n : d2 / (double)n2);
        return d3;
    }

    private double getYScale(int n, double d) {
        int n2 = this.clusterTbl.getRowCount();
        double d2 = n2 == 0 ? d : (n2 < n ? d / (double)n2 : d / (double)n);
        return d2;
    }

    public int getRowIndex(int n) {
        int n2 = this.getStartRow();
        int n3 = 0;
        boolean bl = false;
        while ((double)n3 <= this.getImageHeight()) {
            if (n3 <= n && (double)n3 + this.getCellHeight() > (double)n) {
                bl = true;
                break;
            }
            n3 = (int)((double)n3 + this.getCellHeight());
            ++n2;
        }
        if (!bl) {
            n2 = -1;
        }
        return n2;
    }

    public boolean containsVisibledRow(int n) {
        return n >= this.getStartRow() && n <= this.getStartRow() + this.getRows();
    }

    public Shape createModifiedClusterMark(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, f);
        generalPath.lineTo((float)this.getMultiClusterMarkSize(), f);
        generalPath.lineTo(0.0f, f + (float)this.getMultiClusterMarkSize());
        generalPath.closePath();
        return generalPath;
    }

    public Color getModifiedClusterMarkColor(Cluster cluster) {
        if (cluster.isTypeSplitCluster()) {
            return Color.blue;
        }
        return Color.red;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double d) {
        this.centerX = d;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double d) {
        this.centerY = d;
    }

    public double getViewportX() {
        return this.viewportX;
    }

    public void setViewportX(double d) {
        this.viewportX = d;
    }

    public double getViewportY() {
        return this.viewportY;
    }

    public void setViewportY(double d) {
        this.viewportY = d;
    }

    public double getClusterW() {
        return this.clusterW;
    }

    public double getClusterH() {
        return this.clusterH;
    }

    public double getViewportX0() {
        double d = this.getClusterW() / (double)OptionTbl.getInstance().getOptionValues().getMinClusterW();
        return d * (this.getViewportX() - this.getCenterX()) + this.getCenterX();
    }

    public double getViewportY0() {
        double d = this.getClusterH() / (double)OptionTbl.getInstance().getOptionValues().getMinClusterH();
        return d * (this.getViewportY() - this.getCenterY()) + this.getCenterY();
    }

    public void updateCenterColumn(int n) {
        this.setCenterX(n);
    }

    public void updateCenterRow(int n) {
        this.setCenterY(n);
    }

    public void updateCenterColumn() {
        this.setCenterX((double)this.columns / 2.0 + (double)this.column);
    }

    public void updateCenterRow() {
        this.setCenterY((double)this.rows / 2.0 + (double)this.startRow);
    }

    public void updateViewport() {
        this.setViewportX(this.column);
        this.setViewportY(this.startRow);
    }

    public void updateScale() {
        this.clusterW = OptionTbl.getInstance().getOptionValues().getPrevMinClusterW();
        this.clusterH = OptionTbl.getInstance().getOptionValues().getPrevMinClusterH();
        OptionTbl.getInstance().getOptionValues().resetPrevMinClusterW();
        OptionTbl.getInstance().getOptionValues().resetPrevMinClusterH();
    }
}

