/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeAnalysis;
import cgdp.recog.coregenome.CoreGenomeDeleteRequestExecuter;
import cgdp.recog.domclust.DomClustAnalysis;
import cgdp.recog.domclust.DomClustDeleteRequestExecuter;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAnalysisType;
import cgdp.recog.project.ServerAnalysis;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ServerAnalysisListDialog
extends AbstractApplyDialog
implements ItemListener {
    private static final String TITLE = "Analysis List";
    private static final Dimension TABLE_SIZE = new Dimension(500, 200);
    private MediatorImpl mediator;
    private Project project;
    private JComboBox typeComboBox;
    private JTable analysisTable;
    private JButton deleteButton;
    private Map typeServerAnalysisMap = new HashMap();
    private Map typeNameMap = new HashMap();

    public ServerAnalysisListDialog(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.typeComboBox = this.createTypeComboBox();
        this.analysisTable = this.createAnalysisTable();
        JScrollPane jScrollPane = new JScrollPane(this.analysisTable, 20, 30);
        this.analysisTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ServerAnalysisListDialog.this.setEnableButton();
            }
        });
        jScrollPane.getViewport().setPreferredSize(TABLE_SIZE);
        this.setApplyButtonName("Download");
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.typeComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.setEnableButton();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JComboBox createTypeComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItemListener(this);
        jComboBox.addItem("DomClust");
        jComboBox.addItem("Core Genome Alignment");
        this.typeNameMap.put("DomClust", "domclust");
        this.typeNameMap.put("Core Genome Alignment", "core");
        return jComboBox;
    }

    private JTable createAnalysisTable() {
        ServerAnalysisTableModel serverAnalysisTableModel = new ServerAnalysisTableModel();
        JTable jTable = new JTable(serverAnalysisTableModel);
        jTable.setRowHeight(20);
        jTable.setSelectionMode(0);
        return jTable;
    }

    private ServerAnalysisTableModel getServerAnalysisTableModel() {
        return (ServerAnalysisTableModel)this.analysisTable.getModel();
    }

    public void updateValue(Project project, List list) {
        this.project = project;
        this.typeServerAnalysisMap = this.createTypeAnalysisListMap(list);
        this.updateTable();
    }

    private Map createTypeAnalysisListMap(List list) {
        HashMap<String, ArrayList<ServerAnalysis>> hashMap = new HashMap<String, ArrayList<ServerAnalysis>>();
        for (ServerAnalysis serverAnalysis : list) {
            String string = serverAnalysis.getAnalysisType();
            ArrayList<ServerAnalysis> arrayList = (ArrayList<ServerAnalysis>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ServerAnalysis>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(serverAnalysis);
        }
        return hashMap;
    }

    private void setEnableButton() {
        int n = this.analysisTable.getSelectedRow();
        this.deleteButton.setEnabled(n != -1);
        this.applyButton.setEnabled(n != -1);
    }

    private void updateTable() {
        String string = this.getAnalysisType();
        ArrayList arrayList = (ArrayList)this.typeServerAnalysisMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.getServerAnalysisTableModel().setServerAnalysisList(arrayList);
    }

    private void removeServerAnalysis(ServerAnalysis serverAnalysis) {
        this.getServerAnalysisTableModel().remove(serverAnalysis);
        List list = (List)this.typeServerAnalysisMap.get(serverAnalysis.getAnalysisType());
        list.remove(serverAnalysis);
    }

    private String getAnalysisType() {
        String string = (String)this.typeComboBox.getSelectedItem();
        return (String)this.typeNameMap.get(string);
    }

    public ServerAnalysis getSelectedServerAnalysis() {
        int n = this.analysisTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.getServerAnalysisTableModel().getServerAnalysis(n);
    }

    private void delete() {
        final ServerAnalysis serverAnalysis = this.getSelectedServerAnalysis();
        if (serverAnalysis == null) {
            return;
        }
        Object[] objectArray = new String[]{"Delete analysis result?", serverAnalysis.getName()};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return;
        }
        if (ProjectAnalysisType.isDomClust(serverAnalysis.getAnalysisType())) {
            DomClustDeleteRequestExecuter domClustDeleteRequestExecuter = new DomClustDeleteRequestExecuter((Component)this, (DomClustAnalysis)serverAnalysis);
            domClustDeleteRequestExecuter.setAfterRunnable(new Runnable(){

                @Override
                public void run() {
                    ServerAnalysisListDialog.this.removeServerAnalysis(serverAnalysis);
                    ServerAnalysisListDialog.this.setEnableButton();
                }
            });
            domClustDeleteRequestExecuter.execute(new DummyProgressComponent());
            domClustDeleteRequestExecuter.done();
        } else if (ProjectAnalysisType.isCore(serverAnalysis.getAnalysisType())) {
            CoreGenomeDeleteRequestExecuter coreGenomeDeleteRequestExecuter = new CoreGenomeDeleteRequestExecuter((Component)this, (CoreGenomeAnalysis)serverAnalysis);
            coreGenomeDeleteRequestExecuter.setAfterRunnable(new Runnable(){

                @Override
                public void run() {
                    ServerAnalysisListDialog.this.removeServerAnalysis(serverAnalysis);
                    ServerAnalysisListDialog.this.setEnableButton();
                }
            });
            coreGenomeDeleteRequestExecuter.execute(new DummyProgressComponent());
            coreGenomeDeleteRequestExecuter.done();
        }
    }

    @Override
    protected boolean check() {
        ServerAnalysis serverAnalysis = this.getSelectedServerAnalysis();
        if (serverAnalysis == null) {
            MessageManager.showErrorMessage((Component)this, "Select analysis.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.typeComboBox) {
            this.updateTable();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }

    private class ServerAnalysisTableModel
    extends AbstractTableModel {
        private String[] COLUMN_NAMES = new String[]{"Name", "Description", "Created On"};
        private List serverAnalysisList = new ArrayList();

        private ServerAnalysisTableModel() {
        }

        public void setServerAnalysisList(List list) {
            this.serverAnalysisList = list;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return this.serverAnalysisList.size();
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ServerAnalysis serverAnalysis = (ServerAnalysis)this.serverAnalysisList.get(n);
            if (n2 == 0) {
                return serverAnalysis.getName();
            }
            if (n2 == 1) {
                return StringTool.getOneLine(serverAnalysis.getDescription());
            }
            if (n2 == 2) {
                return serverAnalysis.getCreateOn();
            }
            return null;
        }

        public ServerAnalysis getServerAnalysis(int n) {
            return (ServerAnalysis)this.serverAnalysisList.get(n);
        }

        public void remove(ServerAnalysis serverAnalysis) {
            this.serverAnalysisList.remove(serverAnalysis);
            this.fireTableDataChanged();
        }
    }
}

