/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.search.ClusterLocalSearchExecuter;
import cgdp.recog.search.ClusterSearchCondition;
import cgdp.recog.search.ClusterSearchResultDialog;
import cgdp.recog.search.GeneSearchResultDialog;
import cgdp.recog.search.KeywordSearch;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import javax.swing.SwingUtilities;

public class ClusterSearchExecuter
extends KeywordSearch {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSearchExecuter.class);
    private ClusterSearchCondition condition;

    ClusterSearchExecuter(ClusterSearchCondition clusterSearchCondition) {
        this.condition = clusterSearchCondition;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            ClusterLocalSearchExecuter clusterLocalSearchExecuter = new ClusterLocalSearchExecuter(this.condition, OptionTbl.getInstance().getOptionValues().isIntensive());
            clusterLocalSearchExecuter.setMediator(this.getMediator());
            clusterLocalSearchExecuter.setClusterTbl(this.getClusterTbl());
            clusterLocalSearchExecuter.setParent(this.getParent());
            clusterLocalSearchExecuter.execute(progressImpl);
            this.setSearchResultList(clusterLocalSearchExecuter.getSearchResultList());
            this.setCancel(clusterLocalSearchExecuter.isCancel());
            this.setError(clusterLocalSearchExecuter.isError());
            this.setErrorCode(clusterLocalSearchExecuter.getErrorCode());
            this.setErrorMessages(clusterLocalSearchExecuter.getErrorMessages());
            this.setErrorNo(clusterLocalSearchExecuter.getErrorCode());
        }
        catch (Exception exception) {
            logger.warn("Fail to execute keyword search.", exception);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageManager.showErrorMessage(ClusterSearchExecuter.this.getParent(), "Fail to execute keyword search.");
                }
            });
        }
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.getParent(), this.getErrorMessages());
            return;
        }
        if (!this.isExistSearchResult()) {
            MessageManager.showMessage(this.getParent(), "Cluster data is not found.");
            return;
        }
        this.getMediator().setSearchResult(this.condition, this.getSearchResultList());
        this.getMediator().showHighlightFilterSearchResult();
        GeneSearchResultDialog.getInstance().setVisible(false);
        ClusterSearchResultDialog clusterSearchResultDialog = ClusterSearchResultDialog.getInstance();
        clusterSearchResultDialog.updateValue(this.getClusterTbl().isOutgroup(), this.getClusterTbl().getSearchResultGroup());
        clusterSearchResultDialog.setVisible(true);
        this.getMediator().updateMemory();
    }
}

