/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetConditionGroup;
import cgdp.recog.set.SetFilterColorTabPanel;
import cgdp.recog.set.SetType;
import cgdp.recog.set.venn.VennTabPanel;
import cgdp.recog.util.TabDialog;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.List;
import javax.swing.event.ChangeEvent;

public class SetCombinationDialog
extends TabDialog {
    private static final Dimension DIALOG_SIZE = new Dimension(600, 600);
    private static final String NAME_VENN = "Venn Diagram";
    private static final String NAME_LIST = "List";
    private MediatorImpl mediator;
    private VennTabPanel vennTabPanel;
    private SetFilterColorTabPanel setFilterColorTabPanel;

    private SetCombinationDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static SetCombinationDialog getInstance(Frame frame, MediatorImpl mediatorImpl) {
        return new SetCombinationDialog(frame, mediatorImpl);
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        this.setSize(DIALOG_SIZE);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    protected void addTabPanel() {
        this.vennTabPanel = new VennTabPanel(this, this.mediator);
        this.setFilterColorTabPanel = new SetFilterColorTabPanel(this, this.mediator);
        this.tabbedPane.add(NAME_VENN, this.vennTabPanel);
        this.tabbedPane.add(NAME_LIST, this.setFilterColorTabPanel);
    }

    public void updateValue(List list, SetConditionGroup setConditionGroup, ClusterTbl clusterTbl) {
        for (AbstractElementSet abstractElementSet : list) {
            abstractElementSet.updateElementList();
        }
        this.vennTabPanel.updateValue(list, setConditionGroup, clusterTbl);
        List list2 = AbstractElementSetFacade.getElementSetList(AbstractElementSetFacade.getSetType(list), clusterTbl.getClusterId());
        this.setFilterColorTabPanel.updateValue(list, list2, setConditionGroup, clusterTbl);
        this.updateTitle(AbstractElementSetFacade.getSetType(list));
        if (list.size() >= 4) {
            this.tabbedPane.setSelectedIndex(1);
        }
    }

    public void updateValue(SetCondition setCondition, SetConditionGroup setConditionGroup, ClusterTbl clusterTbl) {
        this.vennTabPanel.updateValue(setCondition, setConditionGroup, clusterTbl);
        List list = AbstractElementSetFacade.getElementSetList(setCondition.getSetType(), clusterTbl.getClusterId());
        this.setFilterColorTabPanel.updateValue(setCondition, list, setConditionGroup, clusterTbl);
        this.updateTitle(setCondition.getSetType());
        if (setCondition.getElementSetList().size() >= 4) {
            this.tabbedPane.setSelectedIndex(1);
        }
    }

    private void updateTitle(int n) {
        String string = SetType.isGeneSet(n) ? "Gene set combination" : "Cluster set combination";
        this.setTitle(string);
    }

    public SetCondition createSetCondition() {
        if (this.isVisibledVenn()) {
            return this.vennTabPanel.createSetCondition();
        }
        return this.setFilterColorTabPanel.createSetCondition();
    }

    public boolean isAddFilter() {
        if (this.isVisibledVenn()) {
            return this.vennTabPanel.isAddFilter();
        }
        return this.setFilterColorTabPanel.isAddFilter();
    }

    public boolean isAddColor() {
        if (this.isVisibledVenn()) {
            return this.vennTabPanel.isAddColor();
        }
        return this.setFilterColorTabPanel.isAddColor();
    }

    private boolean isVisibledVenn() {
        return this.tabbedPane.getSelectedIndex() == 0;
    }

    @Override
    protected boolean check() {
        TabPanel tabPanel = (TabPanel)this.tabbedPane.getSelectedComponent();
        return tabPanel.check();
    }

    @Override
    protected boolean apply() {
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component == this.vennTabPanel) {
            SetCondition setCondition = this.setFilterColorTabPanel.createSetConditionForVenn();
            List list = setCondition.getElementSetList();
            if (list.size() <= 0) {
                this.vennTabPanel.removeAllColor();
            } else if (list.size() >= 4) {
                this.vennTabPanel.setEnableShow(false);
            } else {
                this.vennTabPanel.updateValue(setCondition, this.setFilterColorTabPanel.isAddFilter(), this.setFilterColorTabPanel.isAddColor());
            }
        } else if (component == this.setFilterColorTabPanel) {
            if (!this.vennTabPanel.isEnableShow()) {
                return;
            }
            SetCondition setCondition = this.vennTabPanel.createSetCondition();
            SetCondition setCondition2 = this.setFilterColorTabPanel.createSetConditionForVenn();
            if (AbstractElementSetFacade.equalsElementSetGroupList(setCondition.getElementSetGroupList(), setCondition2.getElementSetGroupList())) {
                setCondition.setElementSetGroupList(this.setFilterColorTabPanel.createSetCondition().getElementSetGroupList());
            }
            this.setFilterColorTabPanel.updateValue(setCondition, this.setFilterColorTabPanel.isAddFilter(), this.setFilterColorTabPanel.isAddColor());
        }
    }
}

