/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.InfoClass;
import cgdp.recog.set.cluster.ClusterSetTabPanel;
import cgdp.recog.set.gene.GeneSetTabPanel;
import cgdp.recog.util.TabDialog;
import java.awt.Dimension;
import java.awt.Frame;

public class SetListDialog
extends TabDialog {
    private static final Dimension DIALOG_SIZE = new Dimension(600, 300);
    private static final String TITLE = "Gene set/Cluster set";
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private GeneSetTabPanel geneSetTabPanel;
    private ClusterSetTabPanel clusterSetTabPanel;

    public SetListDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        this.setTitle(TITLE);
        this.setSize(DIALOG_SIZE);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    protected void addTabPanel() {
        this.geneSetTabPanel = new GeneSetTabPanel(this, this.mediator);
        this.clusterSetTabPanel = new ClusterSetTabPanel(this, this.mediator);
        this.tabbedPane.add("Gene set", this.geneSetTabPanel);
        this.tabbedPane.add("Cluster set", this.clusterSetTabPanel);
    }

    public void updateValue(int n, ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        if (InfoClass.isGene(n)) {
            this.tabbedPane.setSelectedIndex(0);
        } else {
            this.tabbedPane.setSelectedIndex(1);
        }
        this.geneSetTabPanel.updateValue();
        this.clusterSetTabPanel.updateValue(clusterTbl);
    }

    @Override
    protected boolean processApply() {
        return true;
    }
}

