/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.sort;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoCalcCondition;
import cgdp.recog.sort.BasicSortCondition;
import cgdp.recog.sort.GeneInfoSortCondition;
import cgdp.recog.sort.InfoSortCondition;
import cgdp.recog.sort.SortCondition;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;

public class GeneInfoSortConditionGroup
extends BasicSortCondition
implements InfoSortCondition {
    private String organismCode;
    private List geneInfoSortConditionList = new ArrayList();
    private ClusterInfoCalcCondition clusterInfoCalcCondition = new ClusterInfoCalcCondition();

    public GeneInfoSortConditionGroup() {
        this.setSortType(6);
    }

    @Override
    public String getOrganismCode() {
        return this.organismCode;
    }

    public void setOrganismCode(String string) {
        this.organismCode = string;
    }

    public void addCondition(GeneInfoSortCondition geneInfoSortCondition) {
        this.geneInfoSortConditionList.add(geneInfoSortCondition);
    }

    @Override
    public List getGeneInfoSortConditionList() {
        return this.geneInfoSortConditionList;
    }

    public int getConditionSize() {
        return this.getGeneInfoSortConditionList().size();
    }

    public boolean isExistCondition() {
        return !this.geneInfoSortConditionList.isEmpty();
    }

    @Override
    public List getSortKeyList() {
        ArrayList<AbstractInfoTitle> arrayList = new ArrayList<AbstractInfoTitle>();
        for (GeneInfoSortCondition geneInfoSortCondition : this.geneInfoSortConditionList) {
            arrayList.add(geneInfoSortCondition.getInfoTitle());
        }
        return arrayList;
    }

    private List getOrganismCodeList() {
        return this.getClusterInfoCalcCondition().getOrganismCodeList();
    }

    @Override
    public boolean isNeededLoadGeneInfo() {
        if (StringTool.isNull(this.getOrganismCode())) {
            return false;
        }
        for (GeneInfoSortCondition geneInfoSortCondition : this.getGeneInfoSortConditionList()) {
            if (!geneInfoSortCondition.getInfoTitle().isGene()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNeededLoadCellInfo() {
        for (GeneInfoSortCondition geneInfoSortCondition : this.getGeneInfoSortConditionList()) {
            if (!geneInfoSortCondition.getInfoTitle().isCell()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNeededLoadClusterInfo() {
        for (GeneInfoSortCondition geneInfoSortCondition : this.getGeneInfoSortConditionList()) {
            if (!(geneInfoSortCondition.getInfoTitle().equalsKey("SCPattern") ? !CollectionUtil.isNull(this.getOrganismCodeList()) : geneInfoSortCondition.getInfoTitle().isCluster())) continue;
            return true;
        }
        return false;
    }

    private boolean equalsOrganismCode(GeneInfoSortConditionGroup geneInfoSortConditionGroup) {
        if (this.getOrganismCode() == null && geneInfoSortConditionGroup.getOrganismCode() == null) {
            return true;
        }
        return !StringTool.isNull(this.getOrganismCode()) && !StringTool.isNull(geneInfoSortConditionGroup.getOrganismCode()) && this.getOrganismCode().equals(geneInfoSortConditionGroup.getOrganismCode());
    }

    private boolean containsCondition(GeneInfoSortCondition geneInfoSortCondition) {
        for (GeneInfoSortCondition geneInfoSortCondition2 : this.getGeneInfoSortConditionList()) {
            if (!geneInfoSortCondition2.equalsCondition(geneInfoSortCondition)) continue;
            return true;
        }
        return false;
    }

    private boolean equalsConditionList(GeneInfoSortConditionGroup geneInfoSortConditionGroup) {
        if (geneInfoSortConditionGroup.getConditionSize() != this.getConditionSize()) {
            return false;
        }
        for (GeneInfoSortCondition geneInfoSortCondition : geneInfoSortConditionGroup.getGeneInfoSortConditionList()) {
            if (this.containsCondition(geneInfoSortCondition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsSortCondition(SortCondition sortCondition) {
        if (sortCondition == null) {
            return false;
        }
        if (!(sortCondition instanceof GeneInfoSortConditionGroup)) {
            return false;
        }
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = (GeneInfoSortConditionGroup)sortCondition;
        if (!super.equalsSortCondition(sortCondition)) {
            return false;
        }
        if (!this.equalsOrganismCode(geneInfoSortConditionGroup)) {
            return false;
        }
        if (!((Object)this.getOrganismCodeList()).equals(geneInfoSortConditionGroup.getOrganismCodeList())) {
            return false;
        }
        return this.equalsConditionList(geneInfoSortConditionGroup);
    }

    @Override
    public int getHashCode() {
        int n = 1;
        if (this.getOrganismCode() != null) {
            n = n * 31 + this.getOrganismCode().hashCode();
        }
        n = n * 31 + ((Object)this.getOrganismCodeList()).hashCode();
        for (GeneInfoSortCondition geneInfoSortCondition : this.getGeneInfoSortConditionList()) {
            n = n * 31 + geneInfoSortCondition.getHashCode();
        }
        n = n * 31 + super.getHashCode();
        return n;
    }

    @Override
    public ClusterInfoCalcCondition getClusterInfoCalcCondition() {
        return this.clusterInfoCalcCondition;
    }

    public void setClusterInfoCalcCondition(ClusterInfoCalcCondition clusterInfoCalcCondition) {
        this.clusterInfoCalcCondition = clusterInfoCalcCondition;
    }

    @Override
    public boolean containsInfo(AbstractInfoTitle abstractInfoTitle) {
        for (GeneInfoSortCondition geneInfoSortCondition : this.geneInfoSortConditionList) {
            if (!geneInfoSortCondition.equalsInfoTitle(abstractInfoTitle)) continue;
            return true;
        }
        return false;
    }
}

