/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ColorUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

class TaxonomyIconCreater {
    private static final String LABEL_INGROUP = "IN";
    private static final String LABEL_OUTGROUP = "OUT";
    private static final String LABEL_REF_GENOME = "(REF)";
    private ImageIcon outgroupIcon;
    private ImageIcon ingroupIcon;
    private ImageIcon inRefGenomeIcon;
    private ImageIcon outRefGenomeIcon;

    TaxonomyIconCreater() {
    }

    void createIcon(int n, int n2, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        Font font = TaxonomyIconCreater.createIconFont(n, n2, defaultTreeCellRenderer);
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        int n3 = TaxonomyIconCreater.getRefWidth(font, defaultTreeCellRenderer);
        Color color = ColorUtil.str2Color(optionValues.getIngroupFontColor());
        this.ingroupIcon = TaxonomyIconCreater.createIconImage(n, n2, color, font, LABEL_INGROUP);
        Color color2 = ColorUtil.str2Color(optionValues.getOutgroupFontColor());
        this.outgroupIcon = TaxonomyIconCreater.createIconImage(n, n2, color2, font, LABEL_OUTGROUP);
        this.inRefGenomeIcon = TaxonomyIconCreater.createRefIconImage(n, n3, n2, color, font, LABEL_INGROUP);
        this.outRefGenomeIcon = TaxonomyIconCreater.createRefIconImage(n, n3, n2, color2, font, LABEL_OUTGROUP);
    }

    private static Font createIconFont(int n, int n2, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        FontMetrics fontMetrics;
        Font font = null;
        int n3 = 12;
        while ((fontMetrics = defaultTreeCellRenderer.getFontMetrics(font = new Font("Monospaced", 0, n3--))).getAscent() >= n2 || fontMetrics.stringWidth(LABEL_OUTGROUP) >= n) {
        }
        return font;
    }

    private static int getRefWidth(Font font, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        FontMetrics fontMetrics = defaultTreeCellRenderer.getFontMetrics(font);
        return fontMetrics.stringWidth(LABEL_REF_GENOME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageIcon createIconImage(int n, int n2, Color color, Font font, String string) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(UIManager.getColor("Tree.background"));
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setColor(color);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2, fontMetrics.getAscent());
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            return imageIcon;
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageIcon createRefIconImage(int n, int n2, int n3, Color color, Font font, String string) {
        BufferedImage bufferedImage = new BufferedImage(n + n2, n3, 1);
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.setColor(UIManager.getColor("Tree.background"));
            graphics2D.fillRect(0, 0, n + n2, n3);
            graphics2D.setFont(font);
            graphics2D.setColor(color);
            graphics2D.drawString(string, 1, fontMetrics.getAscent());
            Color color2 = Color.green.darker();
            graphics2D.setColor(color2);
            graphics2D.drawString(LABEL_REF_GENOME, 1 + n, fontMetrics.getAscent());
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            return imageIcon;
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    ImageIcon getIngroupIcon() {
        return this.ingroupIcon;
    }

    ImageIcon getOutgroupIcon() {
        return this.outgroupIcon;
    }

    ImageIcon getInRefGenomeIcon() {
        return this.inRefGenomeIcon;
    }

    ImageIcon getOutRefGenomeIcon() {
        return this.outRefGenomeIcon;
    }
}

