/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.taxonomy.map.FuncCatGraphCreater;
import cgdp.recog.taxonomy.map.NumericGraphCreater;
import cgdp.recog.taxonomy.map.TaxMapGraphCreater;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TextGraphCreater;
import java.awt.Color;
import java.awt.Font;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.GradientBarPainter;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.StandardGradientPaintTransformer;

abstract class AbstractTaxMapGraphCreater
implements TaxMapGraphCreater {
    protected TaxMapModel taxMapModel;
    protected ClusterTbl clusterTbl;
    protected AbstractInfoTitle infoTitle;

    AbstractTaxMapGraphCreater(TaxMapModel taxMapModel, ClusterTbl clusterTbl, AbstractInfoTitle abstractInfoTitle) {
        this.taxMapModel = taxMapModel;
        this.clusterTbl = clusterTbl;
        this.infoTitle = abstractInfoTitle;
    }

    static TaxMapGraphCreater createTaxMapGraphCreater(AbstractInfoTitle abstractInfoTitle, TaxMapModel taxMapModel, ClusterTbl clusterTbl) {
        if (abstractInfoTitle.isNumeric()) {
            return new NumericGraphCreater(taxMapModel, clusterTbl, abstractInfoTitle);
        }
        if (abstractInfoTitle.equalsKey("CFuncCat")) {
            return new FuncCatGraphCreater(taxMapModel, clusterTbl, abstractInfoTitle);
        }
        return new TextGraphCreater(taxMapModel, clusterTbl, abstractInfoTitle);
    }

    JFreeChart createBoxChart(Dataset dataset) {
        JFreeChart jFreeChart = ChartFactory.createBoxAndWhiskerChart(null, null, null, (BoxAndWhiskerCategoryDataset)dataset, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.white);
        categoryPlot.setOrientation(this.taxMapModel.getPropertyGraphOrientation());
        if (this.taxMapModel.isPropertyGraphVertical()) {
            categoryPlot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        }
        categoryPlot.getDomainAxis().setTickLabelFont(new Font("Times New Roman", 2, 12));
        categoryPlot.getRangeAxis().setTickLabelFont(new Font("Times New Roman", 0, 12));
        categoryPlot.getRangeAxis().setUpperMargin(0.3);
        BoxAndWhiskerRenderer boxAndWhiskerRenderer = (BoxAndWhiskerRenderer)categoryPlot.getRenderer();
        boxAndWhiskerRenderer.setMaximumBarWidth(0.05);
        return jFreeChart;
    }

    JFreeChart createStackBarChart(Dataset dataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)dataset, this.taxMapModel.getPropertyGraphOrientation(), false, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.white);
        if (this.taxMapModel.isPropertyGraphVertical()) {
            categoryPlot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        }
        categoryPlot.getDomainAxis().setTickLabelFont(new Font("Times New Roman", 2, 12));
        categoryPlot.getRangeAxis().setTickLabelFont(new Font("Times New Roman", 0, 12));
        StackedBarRenderer stackedBarRenderer = (StackedBarRenderer)categoryPlot.getRenderer();
        stackedBarRenderer.setShadowVisible(false);
        stackedBarRenderer.setBarPainter(new GradientBarPainter(0.0, 0.0, 1.0));
        stackedBarRenderer.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_HORIZONTAL));
        stackedBarRenderer.setMaximumBarWidth(0.1);
        return jFreeChart;
    }
}

