/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.process.CommandImpl;
import cgdp.recog.taxonomy.DisplayTaxonomyTreeNode;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapScoreFilterDialog;
import cgdp.recog.taxonomy.map.TaxTreeStructureChangeEvent;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

class TaxMapFilterScoreItem
extends JMenuItem
implements CommandImpl {
    private Component parent;
    private TaxMapModel taxMapModel;

    TaxMapFilterScoreItem(ActionListener actionListener, Component component, TaxMapModel taxMapModel) {
        super("Filter nodes by count...");
        this.parent = component;
        this.taxMapModel = taxMapModel;
        this.addActionListener(actionListener);
    }

    @Override
    public void execute() {
        TaxMapScoreFilterDialog taxMapScoreFilterDialog = TaxMapScoreFilterDialog.getInstance(this.parent);
        taxMapScoreFilterDialog.updateValue(this.taxMapModel.isEnableScoreFilter(), this.taxMapModel.getScoreFilterThreshold(), this.taxMapModel.getMaxTotalScore());
        taxMapScoreFilterDialog.setVisible(true);
        if (taxMapScoreFilterDialog.isCanceled()) {
            return;
        }
        this.taxMapModel.setEnableScoreFilter(taxMapScoreFilterDialog.isEnableScoreFilter());
        this.taxMapModel.setScoreFilterThreshold(taxMapScoreFilterDialog.getThreshold());
        TaxMapFacade.hideMappingNodeByScoreFilter((DisplayTaxonomyTreeNode)this.taxMapModel.getRootNode(), this.taxMapModel);
        TaxTreeStructureChangeEvent taxTreeStructureChangeEvent = new TaxTreeStructureChangeEvent(this);
        this.taxMapModel.nodifyObservers(taxTreeStructureChangeEvent);
    }
}

