/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.system.OS;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapInfoTableModel;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.url.GeneUrlFacade;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class TaxMapInfoTable
extends JScrollPane
implements ActionListener,
MouseListener {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private TaxMapModel taxMapModel;
    private JTable taxMapInfoTable;

    TaxMapInfoTable(MediatorImpl mediatorImpl, TaxMapModel taxMapModel) {
        this.mediator = mediatorImpl;
        this.taxMapModel = taxMapModel;
        this.init();
    }

    private void init() {
        this.taxMapInfoTable = new JTable(new TaxMapInfoTableModel(this.taxMapModel));
        this.taxMapInfoTable.addMouseListener(this);
        this.taxMapInfoTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int[] nArray = TaxMapInfoTable.this.taxMapInfoTable.getSelectedRows();
                List list = TaxMapInfoTable.this.getTaxMapInfoTableModel().getTaxMapInfoList(nArray);
                TaxMapFacade.selectClusterOnPPM(list, TaxMapInfoTable.this.mediator);
            }
        });
        this.setViewportView(this.taxMapInfoTable);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(30);
    }

    void updateValue(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    private TaxMapInfoTableModel getTaxMapInfoTableModel() {
        return (TaxMapInfoTableModel)this.taxMapInfoTable.getModel();
    }

    List getTaxMapInfoList() {
        return this.getTaxMapInfoTableModel().getTaxMapInfoList();
    }

    void setTaxMapInfoList(List list) {
        this.getTaxMapInfoTableModel().setTaxMapInfoList(list);
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        String string;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        int n = this.taxMapInfoTable.rowAtPoint(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        TaxMapInfo taxMapInfo = this.getTaxMapInfoTableModel().getTaxMapInfo(n);
        String string2 = taxMapInfo.getOrganismCode();
        List list = GeneUrlFacade.createUrlMenuList(this, this.mediator, this.clusterTbl, string2, string = GeneUtil.removeDomainNo(taxMapInfo.getLocusTag()));
        if (!CollectionUtil.isNull(list)) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jPopupMenu.add((JMenuItem)iterator.next());
            }
        }
        jPopupMenu.show(this.taxMapInfoTable, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            int n = this.taxMapInfoTable.getSelectedRow();
            TaxMapInfo taxMapInfo = this.getTaxMapInfoTableModel().getTaxMapInfo(n);
            String string = GeneUrlFacade.getDefaultUrl(this.clusterTbl, taxMapInfo.getOrganismCode(), GeneUtil.removeDomainNo(taxMapInfo.getLocusTag()));
            this.mediator.viewUrl(string);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows()) {
            this.showPopupMenu(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows()) {
            this.showPopupMenu(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof CommandImpl) {
            ((CommandImpl)actionEvent.getSource()).execute();
        }
    }
}

