/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.url;

import cgdp.recog.url.GeneUrl;
import cgdp.recog.url.GeneUrlComparator;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class GeneUrlTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Name", "URL", "Keys", "Default"};
    private List geneUrlList = new ArrayList();

    GeneUrlTableModel() {
    }

    public void setGeneUrlList(List list) {
        this.geneUrlList = list;
        this.fireTableDataChanged();
    }

    public List getGeneUrlList() {
        return this.geneUrlList;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    public Class getColumnClass(int n) {
        if (n == 3) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.geneUrlList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        GeneUrl geneUrl = (GeneUrl)this.geneUrlList.get(n);
        if (n2 == 0) {
            return geneUrl.getName();
        }
        if (n2 == 1) {
            return geneUrl.getUrlTemplate();
        }
        if (n2 == 2) {
            return geneUrl.getKeyNameString();
        }
        if (n2 == 3) {
            return new Boolean(geneUrl.isDef());
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 3;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        GeneUrl geneUrl = (GeneUrl)this.geneUrlList.get(n);
        if (n2 == 3) {
            int n3 = this.indexOfDef();
            boolean bl = (Boolean)object;
            if (bl) {
                this.createDef();
            }
            geneUrl.setDef(bl);
            this.fireTableRowsUpdated(n3, n3);
            this.fireTableRowsUpdated(n, n);
        }
    }

    private int indexOfDef() {
        GeneUrl geneUrl;
        int n = 0;
        Iterator iterator = this.geneUrlList.iterator();
        while (iterator.hasNext() && !(geneUrl = (GeneUrl)iterator.next()).isDef()) {
            ++n;
        }
        return n;
    }

    private void createDef() {
        for (GeneUrl geneUrl : this.geneUrlList) {
            geneUrl.setDef(false);
        }
    }

    public GeneUrl getGeneUrl(int n) {
        GeneUrl geneUrl = (GeneUrl)this.geneUrlList.get(n);
        return geneUrl;
    }

    public void addGeneUrl(GeneUrl geneUrl) {
        this.geneUrlList.add(geneUrl);
        Collections.sort(this.geneUrlList, new GeneUrlComparator());
        this.fireTableDataChanged();
    }

    public void replaceGeneUrl(GeneUrl geneUrl) {
        int n = this.indexOf(geneUrl);
        if (n != -1) {
            this.geneUrlList.set(n, geneUrl);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void deleteGeneUrl(GeneUrl geneUrl) {
        int n = this.indexOf(geneUrl);
        if (n == -1) {
            return;
        }
        this.geneUrlList.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    private int indexOf(GeneUrl geneUrl) {
        int n = 0;
        int n2 = -1;
        for (GeneUrl geneUrl2 : this.geneUrlList) {
            if (geneUrl2.equalsGeneUrl(geneUrl)) {
                n2 = n;
                break;
            }
            ++n;
        }
        return n2;
    }
}

