/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.markup.MarkupParser;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FontFactory {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES = "Times";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    private static Properties trueTypeFonts = new Properties();
    private static Hashtable fontFamilies;
    public static String defaultEncoding;
    public static boolean defaultEmbedding;

    private FontFactory() {
    }

    public static Font getFont(String string, String string2, boolean bl, float f, int n, Color color) {
        Object object;
        if (string == null) {
            return new Font(-1, f, n, color);
        }
        HashSet hashSet = (HashSet)fontFamilies.get(string);
        if (hashSet != null) {
            object = string.toLowerCase();
            int n2 = n == -1 ? 0 : n;
            int n3 = 0;
            boolean bl2 = false;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = string3.toLowerCase();
                n3 = 0;
                if (string4.toLowerCase().indexOf("bold") != -1) {
                    n3 |= 1;
                }
                if (string4.toLowerCase().indexOf("italic") != -1 || string4.toLowerCase().indexOf("oblique") != -1) {
                    n3 |= 2;
                }
                if ((n2 & 3) != n3) continue;
                string = string3;
                bl2 = true;
                break;
            }
            if (n != -1 && bl2) {
                n &= ~n3;
            }
        }
        object = null;
        try {
            try {
                object = BaseFont.createFont(string, string2, bl);
            }
            catch (DocumentException documentException) {
                string = trueTypeFonts.getProperty(string);
                if (string == null) {
                    return new Font(-1, f, n, color);
                }
                object = BaseFont.createFont(string, string2, bl);
            }
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
        catch (IOException iOException) {
            return new Font(-1, f, n, color);
        }
        catch (NullPointerException nullPointerException) {
            return new Font(-1, f, n, color);
        }
        return new Font((BaseFont)object, f, n, color);
    }

    public static Font getFont(Properties properties) {
        Object object;
        Object object2;
        Object object3;
        String string = null;
        String string2 = defaultEncoding;
        boolean bl = defaultEmbedding;
        float f = -1.0f;
        int n = 0;
        Color color = null;
        String string3 = (String)properties.remove("style");
        if (string3 != null && string3.length() > 0) {
            object3 = MarkupParser.parseAttributes(string3);
            if (((Properties)object3).size() == 0) {
                properties.put("style", string3);
            } else {
                string = (String)((Properties)object3).remove("font-family");
                if (string != null) {
                    while (string.indexOf(",") != -1) {
                        object2 = string.substring(0, string.indexOf(","));
                        if (FontFactory.isRegistered((String)object2)) {
                            string = object2;
                            continue;
                        }
                        string = string.substring(string.indexOf(",") + 1);
                    }
                }
                if ((string3 = (String)((Properties)object3).remove("font-size")) != null) {
                    f = MarkupParser.parseLength(string3);
                }
                if ((string3 = (String)((Properties)object3).remove("font-weight")) != null) {
                    n |= Font.getStyleValue(string3);
                }
                if ((string3 = (String)((Properties)object3).remove("font-style")) != null) {
                    n |= Font.getStyleValue(string3);
                }
                if ((string3 = (String)((Properties)object3).remove("color")) != null) {
                    color = MarkupParser.decodeColor(string3);
                }
                properties.putAll((Map<?, ?>)object3);
                object2 = ((Properties)object3).keys();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    properties.put(object, ((Properties)object3).get(object));
                }
            }
        }
        if ((string3 = (String)properties.remove("encoding")) != null) {
            string2 = string3;
        }
        if ("true".equals((String)properties.remove("embedded"))) {
            bl = true;
        }
        if ((string3 = (String)properties.remove("font")) != null) {
            string = string3;
        }
        if ((string3 = (String)properties.remove("size")) != null) {
            f = Float.valueOf(string3 + "f").floatValue();
        }
        if ((string3 = (String)properties.remove("style")) != null) {
            n |= Font.getStyleValue(string3);
        }
        if ((string3 = (String)properties.remove("fontstyle")) != null) {
            n |= Font.getStyleValue(string3);
        }
        object3 = (String)properties.remove("red");
        object2 = (String)properties.remove("green");
        object = (String)properties.remove("blue");
        if (object3 != null || object2 != null || object != null) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (object3 != null) {
                n2 = Integer.parseInt((String)object3);
            }
            if (object2 != null) {
                n3 = Integer.parseInt((String)object2);
            }
            if (object != null) {
                n4 = Integer.parseInt(object);
            }
            color = new Color(n2, n3, n4);
        } else {
            string3 = (String)properties.remove("color");
            if (string3 != null) {
                color = MarkupParser.decodeColor(string3);
            }
        }
        if (string == null) {
            return FontFactory.getFont(null, string2, bl, f, n, color);
        }
        return FontFactory.getFont(string, string2, bl, f, n, color);
    }

    public static Font getFont(String string, String string2, boolean bl, float f, int n) {
        return FontFactory.getFont(string, string2, bl, f, n, null);
    }

    public static Font getFont(String string, String string2, boolean bl, float f) {
        return FontFactory.getFont(string, string2, bl, f, -1, null);
    }

    public static Font getFont(String string, String string2, boolean bl) {
        return FontFactory.getFont(string, string2, bl, -1.0f, -1, null);
    }

    public static Font getFont(String string, String string2, float f, int n, Color color) {
        return FontFactory.getFont(string, string2, defaultEmbedding, f, n, color);
    }

    public static Font getFont(String string, String string2, float f, int n) {
        return FontFactory.getFont(string, string2, defaultEmbedding, f, n, null);
    }

    public static Font getFont(String string, String string2, float f) {
        return FontFactory.getFont(string, string2, defaultEmbedding, f, -1, null);
    }

    public static Font getFont(String string, String string2) {
        return FontFactory.getFont(string, string2, defaultEmbedding, -1.0f, -1, null);
    }

    public static Font getFont(String string, float f, int n, Color color) {
        return FontFactory.getFont(string, defaultEncoding, defaultEmbedding, f, n, color);
    }

    public static Font getFont(String string, float f, int n) {
        return FontFactory.getFont(string, defaultEncoding, defaultEmbedding, f, n, null);
    }

    public static Font getFont(String string, float f) {
        return FontFactory.getFont(string, defaultEncoding, defaultEmbedding, f, -1, null);
    }

    public static Font getFont(String string) {
        return FontFactory.getFont(string, defaultEncoding, defaultEmbedding, -1.0f, -1, null);
    }

    public static void register(String string) {
        FontFactory.register(string, null);
    }

    public static void register(String string, String string2) {
        block14: {
            try {
                if (string.toLowerCase().endsWith(".ttf") || string.toLowerCase().endsWith(".otf") || string.toLowerCase().indexOf(".ttc,") > 0) {
                    int n;
                    Object[] objectArray = BaseFont.getAllFontNames(string, "Cp1252", null);
                    trueTypeFonts.setProperty((String)objectArray[0], string);
                    if (string2 != null) {
                        trueTypeFonts.setProperty(string2, string);
                    }
                    String string3 = null;
                    String string4 = null;
                    String[][] stringArray = (String[][])objectArray[2];
                    for (n = 0; n < stringArray.length; ++n) {
                        if (!"0".equals(stringArray[n][2])) continue;
                        string3 = stringArray[n][3];
                        break;
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        trueTypeFonts.setProperty(stringArray[n][3], string);
                    }
                    if (string3 == null) break block14;
                    stringArray = (String[][])objectArray[1];
                    for (n = 0; n < stringArray.length; ++n) {
                        if (!"0".equals(stringArray[n][2])) continue;
                        string4 = stringArray[n][3];
                        HashSet<String> hashSet = (HashSet<String>)fontFamilies.get(string4);
                        if (hashSet == null) {
                            hashSet = new HashSet<String>();
                        }
                        hashSet.add(string3);
                        fontFamilies.put(string4, hashSet);
                        break block14;
                    }
                    break block14;
                }
                if (string.toLowerCase().endsWith(".ttc")) {
                    if (string2 != null) {
                        System.err.println("class FontFactory: You can't define an alias for a true type collection.");
                    }
                    String[] stringArray = BaseFont.enumerateTTCNames(string);
                    for (int i = 0; i < stringArray.length; ++i) {
                        FontFactory.register(string + "," + i);
                    }
                } else if (string.toLowerCase().endsWith(".afm")) {
                    BaseFont baseFont = BaseFont.createFont(string, "Cp1252", false);
                    trueTypeFonts.setProperty(baseFont.getPostscriptFontName(), string);
                    trueTypeFonts.setProperty(baseFont.getFullFontName()[0][3], string);
                }
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
    }

    public static int registerDirectory(String string) {
        int n = 0;
        try {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) {
                return 0;
            }
            String[] stringArray = file.list();
            if (stringArray == null) {
                return 0;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    file = new File(string, stringArray[i]);
                    String string2 = file.getPath().toLowerCase();
                    if (!string2.endsWith(".ttf") && !string2.endsWith(".otf") && !string2.endsWith(".afm") && !string2.endsWith(".ttc")) continue;
                    FontFactory.register(file.getPath(), null);
                    ++n;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static int registerDirectories() {
        int n = 0;
        n += FontFactory.registerDirectory("c:/windows/fonts");
        n += FontFactory.registerDirectory("c:/winnt/fonts");
        n += FontFactory.registerDirectory("d:/windows/fonts");
        n += FontFactory.registerDirectory("d:/winnt/fonts");
        n += FontFactory.registerDirectory("/usr/X/lib/X11/fonts/TrueType");
        n += FontFactory.registerDirectory("/usr/openwin/lib/X11/fonts/TrueType");
        n += FontFactory.registerDirectory("/usr/share/fonts/default/TrueType");
        return n += FontFactory.registerDirectory("/usr/X11R6/lib/X11/fonts/ttf");
    }

    public static Set getRegisteredFonts() {
        return Chunk.getKeySet(trueTypeFonts);
    }

    public static Set getRegisteredFamilies() {
        return Chunk.getKeySet(fontFamilies);
    }

    public static boolean contains(String string) {
        return trueTypeFonts.containsKey(string);
    }

    public static boolean isRegistered(String string) {
        Enumeration<?> enumeration = trueTypeFonts.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    static {
        trueTypeFonts.setProperty(COURIER, COURIER);
        trueTypeFonts.setProperty(COURIER_BOLD, COURIER_BOLD);
        trueTypeFonts.setProperty(COURIER_OBLIQUE, COURIER_OBLIQUE);
        trueTypeFonts.setProperty(COURIER_BOLDOBLIQUE, COURIER_BOLDOBLIQUE);
        trueTypeFonts.setProperty(HELVETICA, HELVETICA);
        trueTypeFonts.setProperty(HELVETICA_BOLD, HELVETICA_BOLD);
        trueTypeFonts.setProperty(HELVETICA_OBLIQUE, HELVETICA_OBLIQUE);
        trueTypeFonts.setProperty(HELVETICA_BOLDOBLIQUE, HELVETICA_BOLDOBLIQUE);
        trueTypeFonts.setProperty(SYMBOL, SYMBOL);
        trueTypeFonts.setProperty(TIMES_ROMAN, TIMES_ROMAN);
        trueTypeFonts.setProperty(TIMES_BOLD, TIMES_BOLD);
        trueTypeFonts.setProperty(TIMES_ITALIC, TIMES_ITALIC);
        trueTypeFonts.setProperty(TIMES_BOLDITALIC, TIMES_BOLDITALIC);
        trueTypeFonts.setProperty(ZAPFDINGBATS, ZAPFDINGBATS);
        fontFamilies = new Hashtable();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(COURIER);
        hashSet.add(COURIER_BOLD);
        hashSet.add(COURIER_OBLIQUE);
        hashSet.add(COURIER_BOLDOBLIQUE);
        fontFamilies.put(COURIER, hashSet);
        hashSet = new HashSet();
        hashSet.add(HELVETICA);
        hashSet.add(HELVETICA_BOLD);
        hashSet.add(HELVETICA_OBLIQUE);
        hashSet.add(HELVETICA_BOLDOBLIQUE);
        fontFamilies.put(HELVETICA, hashSet);
        hashSet = new HashSet();
        hashSet.add(SYMBOL);
        fontFamilies.put(SYMBOL, hashSet);
        hashSet = new HashSet();
        hashSet.add(TIMES_ROMAN);
        hashSet.add(TIMES_BOLD);
        hashSet.add(TIMES_ITALIC);
        hashSet.add(TIMES_BOLDITALIC);
        fontFamilies.put(TIMES, hashSet);
        fontFamilies.put(TIMES_ROMAN, hashSet);
        hashSet = new HashSet();
        hashSet.add(ZAPFDINGBATS);
        fontFamilies.put(ZAPFDINGBATS, hashSet);
        defaultEncoding = "Cp1252";
        defaultEmbedding = false;
    }
}

