/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.access;

import cgdp.recog.access.AbstractFileAccessExecuter;
import cgdp.recog.access.FileAccessType;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetImportDialog;
import cgdp.recog.set.cluster.ClusterSetRegister;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class ClusterSetImportExecuter
extends AbstractFileAccessExecuter {
    private ClusterTbl clusterTbl;
    private int importType;
    private List clusterList;
    private ClusterSet clusterSet;

    ClusterSetImportExecuter(Component component, MediatorImpl mediatorImpl, String string, int n, ClusterTbl clusterTbl) {
        this(component, mediatorImpl, string, new ArrayList(), null, n, clusterTbl);
    }

    ClusterSetImportExecuter(Component component, MediatorImpl mediatorImpl, String string, List list, int n, ClusterTbl clusterTbl) {
        this(component, mediatorImpl, string, list, null, n, clusterTbl);
    }

    ClusterSetImportExecuter(Component component, MediatorImpl mediatorImpl, String string, List list, ClusterSet clusterSet, int n, ClusterTbl clusterTbl) {
        super(component, mediatorImpl, string);
        this.importType = n;
        this.clusterTbl = clusterTbl;
        this.clusterList = list;
        this.clusterSet = clusterSet;
    }

    @Override
    int getAccessType() {
        return this.importType;
    }

    @Override
    public void execute() throws Exception {
        if (FileAccessType.isRegisterByClusterList(this.getAccessType())) {
            this.executeForNewSetFromCluster();
        } else if (FileAccessType.isAddElement(this.getAccessType())) {
            this.executeForAddCluster();
        } else {
            this.executeForNewSetFromFile();
        }
    }

    private void executeForNewSetFromFile() {
        ClusterSetImportDialog clusterSetImportDialog = ClusterSetImportDialog.getInstanse(this.parent);
        clusterSetImportDialog.updateValue(this.location, this.clusterTbl, true);
        clusterSetImportDialog.setVisible(true);
        if (clusterSetImportDialog.isCanceled()) {
            return;
        }
        ClusterSet clusterSet = clusterSetImportDialog.createClusterSet();
        String string = clusterSetImportDialog.getFilepath();
        ClusterSetRegister clusterSetRegister = new ClusterSetRegister(this.parent, clusterSet, string, this.clusterTbl){

            @Override
            public void done() {
                ClusterSetImportExecuter.this.mediator.updateClusterSetTree();
            }
        };
        ProgressDialog.executeProgress(this.parent, this.mediator, 100, "Register cluster set...", false, (ProcessImpl)clusterSetRegister);
    }

    private void executeForNewSetFromCluster() {
        int n = this.clusterList.size();
        ClusterSetImportDialog clusterSetImportDialog = ClusterSetImportDialog.getInstanse(this.parent, n);
        clusterSetImportDialog.updateValue(this.location, this.clusterTbl, false);
        clusterSetImportDialog.setVisible(true);
        if (clusterSetImportDialog.isCanceled()) {
            return;
        }
        ClusterSet clusterSet = clusterSetImportDialog.createClusterSet();
        ClusterSetRegister clusterSetRegister = new ClusterSetRegister(this.parent, clusterSet, this.clusterList, this.clusterTbl){

            @Override
            public void done() {
                ClusterSetImportExecuter.this.mediator.updateClusterSetTree();
            }
        };
        ProgressDialog.executeProgress(this.parent, this.mediator, 100, "Register cluster set...", false, (ProcessImpl)clusterSetRegister);
    }

    private void executeForAddCluster() {
        this.clusterSet.addAddList();
        ClusterSetRegister clusterSetRegister = new ClusterSetRegister(this.parent, this.clusterSet, this.clusterList, this.clusterTbl){

            @Override
            public void done() {
                ClusterSetImportExecuter.this.mediator.updateClusterSetTree();
            }
        };
        ProgressDialog.executeProgress(this.parent, this.mediator, 100, "Register cluster set...", false, (ProcessImpl)clusterSetRegister);
    }
}

