/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.access;

import cgdp.recog.access.FileAccessType;
import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.filefilter.SingleFileFilter;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.CustomFileChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

class FileChooserFactory {
    private FileChooserFactory() {
    }

    static JFileChooser createFileChooser(int n, String string) {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        CustomFileChooser customFileChooser = new CustomFileChooser(new File(optionValues.getUserImportDir())){

            @Override
            protected void updateSelectedFile() {
            }
        };
        customFileChooser.setDialogTitle(FileChooserFactory.getDialogTitle(n, string));
        customFileChooser.setAcceptAllFileFilterUsed(false);
        List list = FileChooserFactory.getFileFilterList(n);
        for (FileFilter fileFilter : list) {
            customFileChooser.addChoosableFileFilter(fileFilter);
        }
        return customFileChooser;
    }

    private static List getFileFilterList(int n) {
        ArrayList<SingleFileFilter> arrayList = new ArrayList<SingleFileFilter>();
        if (FileAccessType.isDomClustFile(n)) {
            arrayList.add(FileFilterFactory.createDomClustFileWithDirFilter());
        } else if (FileAccessType.isDomClustTabFile(n)) {
            arrayList.add(FileFilterFactory.createDomClustTabFileWithDirFilter());
        } else if (FileAccessType.isGenePropertyGlobal(n)) {
            arrayList.add(FileFilterFactory.createGeneInfoFileWithDirFilter());
        } else if (FileAccessType.isGenePropertyProject(n)) {
            arrayList.add(FileFilterFactory.createGeneInfoFileWithDirFilter());
        } else if (FileAccessType.isClusterPropertyCluster(n)) {
            arrayList.add(FileFilterFactory.createClusterInfoFileWithDirFilter());
        } else if (FileAccessType.isExportClustTab(n)) {
            arrayList.add(FileFilterFactory.createDomClustTabFileWithDirFilter());
        } else if (FileAccessType.isExportGeneSet(n)) {
            arrayList.add(FileFilterFactory.createGeneSetDetailFileFilter());
            arrayList.add(FileFilterFactory.createGeneSetFileFilter());
        } else if (FileAccessType.isExportClusterSet(n)) {
            arrayList.add(FileFilterFactory.createClusterSetFileFilter());
        } else if (FileAccessType.isExportPdf(n)) {
            arrayList.add(FileFilterFactory.createPPMPdfFileWithDirFilter());
        }
        return arrayList;
    }

    private static String getDialogTitle(int n, String string) {
        String string2 = "";
        if (FileAccessType.isDomClustFile(n)) {
            string2 = "Import domclust file(.dclst)";
        } else if (FileAccessType.isDomClustTabFile(n)) {
            string2 = "Import domclust tab file(.clusttab)";
        } else if (FileAccessType.isGenePropertyGlobal(n)) {
            string2 = "Import gene propety file(" + string + ")";
        } else if (FileAccessType.isGenePropertyProject(n)) {
            string2 = "Import gene propety file(" + string + ")";
        } else if (FileAccessType.isExportClustTab(n)) {
            string2 = "Export cluster tab file";
        } else if (FileAccessType.isExportPdf(n)) {
            string2 = "Export PDF file";
        } else if (FileAccessType.isExportGeneSet(n)) {
            string2 = "Export gene list";
        } else if (FileAccessType.isExportClusterSet(n)) {
            string2 = "Export cluster list";
        } else if (FileAccessType.isClusterPropertyCluster(n)) {
            string2 = "Import cluster propety file(Cluster)";
        } else if (FileAccessType.isClusterPropertySubCluster(n)) {
            string2 = "Import cluster propety file(SubCluster)";
        } else if (FileAccessType.isOrganismDisplaySetting(n)) {
            string2 = "Import organism display setting file";
        }
        return string2;
    }
}

