/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.CoreGeneCreater;
import cgdp.recog.align.CoreGeneTargetCondition;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetRegister;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CoreGeneSetCreater
extends AbstractThreadProcess {
    private Component parent;
    private MediatorImpl mediator;
    private GeneSet geneSet;
    private List organismList;
    private CoreGeneCreater coreGeneCreater;

    public CoreGeneSetCreater(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, GeneSet geneSet, CoreGeneTargetCondition coreGeneTargetCondition, List list, GenomeAlign genomeAlign) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.organismList = list;
        this.geneSet = geneSet;
        this.coreGeneCreater = new CoreGeneCreater(GeneInfoTitle.TITLE_CORE_GENE_FLAG, coreGeneTargetCondition, list, genomeAlign, clusterTbl);
    }

    public CoreGeneSetCreater(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, GeneSet geneSet, CoreGeneTargetCondition coreGeneTargetCondition, List list, List list2) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.organismList = list;
        this.geneSet = geneSet;
        this.coreGeneCreater = new CoreGeneCreater(GeneInfoTitle.TITLE_CORE_GENE_FLAG, coreGeneTargetCondition, list, list2, clusterTbl);
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        this.coreGeneCreater.execute(progressImpl);
        if (this.coreGeneCreater.isCancel()) {
            return;
        }
        if (this.coreGeneCreater.isError()) {
            this.setError(true);
            this.setErrorMessages(this.coreGeneCreater.getErrorMessages());
            return;
        }
        Map map = this.coreGeneCreater.getOrganismCodeGeneInfoListMap();
        List list = this.createGeneInfoList(map);
        progressImpl.increment();
        progressImpl.nextProc();
        progressImpl.setCount(-1);
        progressImpl.increment();
        GeneSetRegister geneSetRegister = new GeneSetRegister(this.parent, this.geneSet, list);
        geneSetRegister.execute(progressImpl);
    }

    private List createGeneInfoList(Map map) {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        for (String string : map.keySet()) {
            List list = (List)map.get(string);
            for (GeneInfo geneInfo : list) {
                int n = ((Number)geneInfo.getInfo(GeneInfoTitle.TITLE_CORE_GENE_FLAG)).intValue();
                if (CoreGeneTargetCondition.isOff(n)) continue;
                geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string);
                arrayList.add(geneInfo);
            }
        }
        return arrayList;
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        this.mediator.updateGeneSetTree();
    }
}

