/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignElement;
import cgdp.recog.align.GlobalAlignGroup;
import cgdp.recog.align.GlobalAlignRenderer;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.process.DefaultThreadCancelListener;
import cgdp.recog.process.ThreadCancelListener;
import cgdp.recog.process.ThreadManager;
import cgdp.recog.system.OS;
import cgdp.recog.url.GeneUrlFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

class GlobalAlignPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final ApplicationLogger logger = new ApplicationLogger(GlobalAlignPanel.class);
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private GlobalAlignViewModel globalAlignViewModel;
    private GlobalAlignRenderer globalAlignRenderer;
    private BufferedImage image;
    private Set taskSet = new HashSet();

    GlobalAlignPanel(MediatorImpl mediatorImpl, ClusterTbl clusterTbl, GlobalAlignViewModel globalAlignViewModel) {
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.globalAlignViewModel = globalAlignViewModel;
        this.globalAlignRenderer = new GlobalAlignRenderer(globalAlignViewModel);
        this.globalAlignViewModel.setGlobalAlignRenderer(this.globalAlignRenderer);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image == null) {
            return;
        }
        BufferedImage bufferedImage = this.image;
        synchronized (bufferedImage) {
            graphics2D.drawImage((Image)this.image, (int)this.globalAlignRenderer.getAlignStartX(), 0, null);
            this.globalAlignRenderer.drawFrame(graphics2D);
            if (this.globalAlignViewModel.isExistSelectedGlobalAlignGroup()) {
                this.globalAlignRenderer.drawSelectedOrthologLines(graphics2D);
            }
        }
    }

    private void initRenderer() {
        int n = 1;
        int n2 = 1;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.globalAlignRenderer.beforeDraw(graphics2D);
        graphics2D.dispose();
    }

    private synchronized void createGlobalAlignImage() {
        for (GlobalAlignImageUpdateTask globalAlignImageUpdateTask : this.taskSet) {
            globalAlignImageUpdateTask.cancel();
        }
        this.taskSet.clear();
        long l = System.currentTimeMillis();
        this.initRenderer();
        long l2 = System.currentTimeMillis();
        logger.info("Time(initRenderer):" + (l2 - l));
        GlobalAlignImageUpdateTask globalAlignImageUpdateTask = new GlobalAlignImageUpdateTask();
        ThreadManager threadManager = ThreadManager.getInstance();
        threadManager.execute(globalAlignImageUpdateTask);
        this.taskSet.add(globalAlignImageUpdateTask);
    }

    private void changeCentralPosition(GlobalAlignGroup globalAlignGroup, GlobalAlignElement globalAlignElement) {
        this.globalAlignRenderer.changeCentralPosition(globalAlignGroup, globalAlignElement);
        this.updateGlobalAlign();
    }

    void changeCentralPosition(String string) {
        Set set = this.globalAlignViewModel.getGlobalAlign().getGlobalAlignGroupSet(string);
        if (set.isEmpty()) {
            return;
        }
        GlobalAlignGroup globalAlignGroup = null;
        GlobalAlignElement globalAlignElement = null;
        for (GlobalAlignGroup globalAlignGroup2 : set) {
            List list = globalAlignGroup2.getAlignElementList(this.globalAlignViewModel.getReferenceOrganismCode());
            if (CollectionUtil.isNull(list)) continue;
            globalAlignGroup = globalAlignGroup2;
            globalAlignElement = (GlobalAlignElement)list.get(0);
            break;
        }
        this.changeCentralPosition(globalAlignGroup, globalAlignElement);
    }

    void zoom(double d) {
        this.globalAlignRenderer.zoom(d);
        this.updateGlobalAlign();
    }

    void moveLeft() {
        this.globalAlignRenderer.moveLeft();
        this.updateGlobalAlign();
    }

    void moveRight() {
        this.globalAlignRenderer.moveRight();
        this.updateGlobalAlign();
    }

    void moveCenter(Set set) {
        this.globalAlignRenderer.moveCenter(set);
        this.updateGlobalAlign();
    }

    void recoverCentralPosition() {
        this.globalAlignViewModel.recoverCentralPosition();
        this.updateGlobalAlign();
    }

    void selectOrthologGroup(String string) {
        Set set = this.globalAlignViewModel.getGlobalAlign().getGlobalAlignGroupSet(string);
        this.selectOrthologGroupAfter(set);
    }

    void selectOrthologGroup(List list) {
        Set set = ClusterUtil.getClusterIdSet(list);
        Set set2 = this.globalAlignViewModel.getGlobalAlignGroupSetByCluster(set);
        this.selectOrthologGroupAfter(set2);
    }

    private void selectOrthologGroupAfter(Set set) {
        if (CollectionUtil.isNull(set)) {
            return;
        }
        HashSet<GlobalAlignGroup> hashSet = new HashSet<GlobalAlignGroup>();
        for (GlobalAlignGroup globalAlignGroup : set) {
            hashSet.add(globalAlignGroup);
        }
        if (CollectionUtil.isNull(hashSet)) {
            return;
        }
        this.globalAlignViewModel.setSelectGlobalAlignGroupSet(hashSet);
        this.moveCenter(hashSet);
        this.repaint();
    }

    void updateDrawWidth() {
        this.globalAlignRenderer.setDrawWidth(this.getVisibleRect().width);
    }

    void updateGlobalAlign() {
        this.createGlobalAlignImage();
        this.repaint();
    }

    boolean isNeedUpdateByResize() {
        return this.image == null || this.getVisibleWidth() != this.globalAlignRenderer.getDrawWidth();
    }

    private double getVisibleWidth() {
        return this.getVisibleRect().width;
    }

    private void updatePreferredSize() {
        this.setPreferredSize(new Dimension(this.getWidth(), (int)this.globalAlignRenderer.calcHeight()));
        this.revalidate();
    }

    private String searchOrganism(int n) {
        int n2 = this.globalAlignRenderer.indexOfOrganism(n);
        return this.globalAlignViewModel.getOrganismViewModel().getViewOrganismCode(n2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        String string = this.searchOrganism(mouseEvent.getPoint().y);
        if (string == null) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        GlobalAlignElement globalAlignElement = this.getGlobalAlignElement(mouseEvent.getPoint(), string);
        if (globalAlignElement != null) {
            GlobalAlignGroup globalAlignGroup = globalAlignElement.getGlobalAlignGroup();
            this.globalAlignViewModel.setSelectGlobalAlignGroupSet(globalAlignGroup.getGlobalAlignGroupSet());
            if (globalAlignGroup.isCore()) {
                this.mediator.selectOrthologGroupOnCoreGenome(globalAlignGroup.getOrthologGroupId());
            }
            this.mediator.selectClusterOnPPM(globalAlignElement.getOrganism().getOrganismCode(), globalAlignElement.getLocusTag());
            this.mediator.setSelectClusterOnGenomeMap(globalAlignGroup.getCluster());
            if (mouseEvent.getClickCount() == 2) {
                if (this.globalAlignViewModel.isShowGeneInfoOnBrowser()) {
                    String string2 = GeneUrlFacade.getDefaultUrl(this.clusterTbl, globalAlignElement.getOrganism().getOrganismCode(), globalAlignElement.getLocusTagWithoutDomain());
                    this.mediator.viewUrl(string2);
                } else {
                    this.changeCentralPosition(globalAlignGroup, globalAlignElement);
                    if (globalAlignGroup.isCore()) {
                        this.mediator.changeCentralPositionOnCoreGenome(globalAlignGroup.getOrthologGroupId());
                    }
                }
            } else {
                this.repaint();
            }
        } else if (this.isOrganismTitleX(mouseEvent.getPoint(), string) && mouseEvent.getClickCount() == 2) {
            this.globalAlignViewModel.setReferenceOrganismCode(string);
            this.globalAlignViewModel.processAfterUpdateOrganism();
            this.globalAlignViewModel.updateAlignGroupStatus();
            this.mediator.updateGlobalAlignMap(true);
        } else {
            this.globalAlignViewModel.clearSelectGlobalAlignGroup();
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
        }
    }

    private void showPopup(Point point) {
        String string;
        GlobalAlignElement globalAlignElement = this.getGlobalAlignElement(point);
        String string2 = globalAlignElement.getOrganism().getOrganismCode();
        List list = GeneUrlFacade.createUrlMenuList(this, this.mediator, this.clusterTbl, string2, string = globalAlignElement.getLocusTagWithoutDomain());
        if (!CollectionUtil.isNull(list)) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jPopupMenu.add((JMenuItem)iterator.next());
            }
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        GlobalAlignElement globalAlignElement = this.getGlobalAlignElement(mouseEvent.getPoint());
        if (globalAlignElement != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            try {
                Gene gene = GeneTbl.readOneGene(globalAlignElement.getOrganismCode(), globalAlignElement.getLocusTag());
                String string = globalAlignElement.getLocusTag();
                if (gene != null) {
                    string = "<HTML>" + globalAlignElement.getLocusTag() + "<BR>" + gene.getDescription() + "</HTML>";
                }
                this.setToolTipText(string);
            }
            catch (Exception exception) {
                logger.warn("Fail to load gene information. " + globalAlignElement.getOrganismCode(), exception);
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            this.setToolTipText(null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    private GlobalAlignGroup getGlobalAlignGroup(Point point) {
        GlobalAlignElement globalAlignElement = this.getGlobalAlignElement(point);
        if (globalAlignElement == null) {
            return null;
        }
        return globalAlignElement.getGlobalAlignGroup();
    }

    private GlobalAlignElement getGlobalAlignElement(Point point) {
        String string = this.searchOrganism(point.y);
        return this.getGlobalAlignElement(point, string);
    }

    private GlobalAlignElement getGlobalAlignElement(Point point, String string) {
        GlobalAlignElement globalAlignElement = this.globalAlignRenderer.getGlobalAlignElement(string, point.x, point.y);
        if (globalAlignElement == null) {
            return null;
        }
        return globalAlignElement;
    }

    private boolean isOrganismTitleX(Point point, String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return this.globalAlignRenderer.isOrganismTitleX(point);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    private class GlobalAlignImageUpdateTask
    implements Runnable,
    ThreadCancelListener {
        private ThreadCancelListener threadCancelListener = new DefaultThreadCancelListener();

        private GlobalAlignImageUpdateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            double d = GlobalAlignPanel.this.getVisibleWidth();
            double d2 = GlobalAlignPanel.this.globalAlignRenderer.getDrawHeight();
            BufferedImage bufferedImage = new BufferedImage((int)d, (int)d2, 5);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, (int)d, (int)d2);
            long l = System.currentTimeMillis();
            GlobalAlignPanel.this.globalAlignRenderer.draw(graphics2D, this.threadCancelListener);
            long l2 = System.currentTimeMillis();
            logger.info("Global Alignment Drawing Time:" + (l2 - l));
            graphics2D.dispose();
            if (this.threadCancelListener.isCancel()) {
                return;
            }
            if (GlobalAlignPanel.this.image != null) {
                object = GlobalAlignPanel.this.image;
                synchronized (object) {
                    GlobalAlignPanel.this.image.flush();
                    GlobalAlignPanel.this.image = bufferedImage;
                }
            } else {
                GlobalAlignPanel.this.image = bufferedImage;
            }
            GlobalAlignPanel.this.globalAlignRenderer.updateSelectableAreaMap();
            object = new Runnable(){

                @Override
                public void run() {
                    GlobalAlignPanel.this.updatePreferredSize();
                    GlobalAlignPanel.this.repaint();
                }
            };
            SwingUtilities.invokeLater((Runnable)object);
        }

        @Override
        public void cancel() {
            this.threadCancelListener.cancel();
        }

        @Override
        public boolean isCancel() {
            return this.threadCancelListener.isCancel();
        }
    }
}

