/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.calc;

import cgdp.recog.calc.AbstractCalcCondition;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoUtil;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.pattern.Pattern;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import java.util.ArrayList;
import java.util.List;

public class CoefCondition
extends AbstractCalcCondition {
    private String locationName;
    private String domClustId;
    private List organismCodeList = new ArrayList();
    private Pattern pattern;
    private Cluster baseCluster;
    private String name;
    private int inoutType = ClusterMode.getClusterMode();
    private boolean outgroup = false;
    private boolean showPPMLabel = true;
    private boolean save;
    private boolean sort;

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String string) {
        this.locationName = string;
    }

    public List getOrganismCodeList() {
        return this.organismCodeList;
    }

    public void setOrganismCodeList(List list) {
        this.organismCodeList = list;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setBaseCluster(Cluster cluster) {
        this.baseCluster = cluster;
    }

    public Cluster getBaseCluster() {
        return this.baseCluster;
    }

    public boolean isNeedCalcPatternForProperty() {
        return this.isGeneProperty() && this.getBaseCluster() != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getInoutType() {
        return this.inoutType;
    }

    public void setInoutType(int n) {
        this.inoutType = n;
    }

    public boolean isOutgroup() {
        return this.outgroup;
    }

    public void setOutgroup(boolean bl) {
        this.outgroup = bl;
    }

    public boolean isSave() {
        return this.save;
    }

    public void setSave(boolean bl) {
        this.save = bl;
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean bl) {
        this.sort = bl;
    }

    public boolean isShowPPMLabel() {
        return this.showPPMLabel;
    }

    public void setShowPPMLabel(boolean bl) {
        this.showPPMLabel = bl;
    }

    int getClusterInfoType() {
        int n = 4;
        if (ClusterMode.isBaseCluster(this.getInoutType())) {
            n = 3;
        }
        return n;
    }

    public ClusterInfoTitle createClusterInfoTitle() {
        ClusterInfoTitle clusterInfoTitle;
        if (this.isSave()) {
            Project project = ProjectAccesser.getSelectedProject();
            this.setLocationName(project.getProjectName());
            clusterInfoTitle = ClusterInfoTitle.createUserInfoTitle(this.getName(), this.getName(), 1, this.getLocationName(), this.getClusterInfoType());
            clusterInfoTitle.addDomClustId(this.getDomClustId());
        } else {
            int n = this.getInoutType();
            clusterInfoTitle = (ClusterInfoTitle)ClusterInfoUtil.getPatternCoefTitle(n);
        }
        int n = 2;
        if (this.isGeneProperty()) {
            n = 3;
        }
        clusterInfoTitle.setCategory(n);
        return clusterInfoTitle;
    }

    public static CoefCondition createCoefCondition(String string, int n, AbstractInfoTitle abstractInfoTitle, int n2, boolean bl, boolean bl2, boolean bl3) {
        CoefCondition coefCondition = new CoefCondition();
        coefCondition.setName(string);
        coefCondition.setProfile(n);
        if (coefCondition.isGeneProperty()) {
            coefCondition.setInfoTitle(abstractInfoTitle);
        }
        coefCondition.setDistType(n2);
        coefCondition.updateCalcOption(abstractInfoTitle);
        coefCondition.setSave(bl2);
        coefCondition.setSort(bl3);
        return coefCondition;
    }

    public void addInfo(ClusterTbl clusterTbl, Pattern pattern, Cluster cluster) {
        Project project = ProjectAccesser.getSelectedProject();
        this.setDomClustId(clusterTbl.getClusterId());
        this.setLocationName(project.getProjectName());
        this.setPattern(pattern);
        this.setBaseCluster(cluster);
        this.setOrganismCodeList(clusterTbl.getViewOrganismCodeList());
        this.setOutgroup(clusterTbl.isOutgroup());
    }
}

