/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.AbstractColorDrawable;
import cgdp.recog.data.Cluster;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.organism.Organism;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;

class DefaultColorDrawable
extends AbstractColorDrawable {
    DefaultColorDrawable(MediatorImpl mediatorImpl) {
        super(mediatorImpl, 930);
    }

    @Override
    public boolean isColorActive() {
        if (this.clusterTbl == null) {
            return false;
        }
        return this.clusterTbl.getBaseColorCondition().isActiveDefaultColor();
    }

    @Override
    public void setColorActive(boolean bl) {
        this.clusterTbl.getBaseColorCondition().setActiveDefaultColor(bl);
    }

    @Override
    public String getNodeLabel() {
        return "Base Color";
    }

    @Override
    public boolean isEnableDraw(Cluster cluster, Organism organism) {
        return this.clusterTbl != null;
    }

    @Override
    public Color drawPPMCell(Graphics2D graphics2D, double d, double d2, double d3, double d4, Cluster cluster, Organism organism, Map map) {
        Color color;
        Color color2 = new Color(0, 180, 255);
        double[] dArray = cluster.getOutgroupGeneClassRatio(organism.getOrganismCode());
        if (dArray[0] == 1.0) {
            color = this.getBackgroundCellColor(organism);
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
        } else {
            double d5 = d4 * dArray[0];
            double d6 = d4 * (dArray[0] + dArray[1]);
            double d7 = d4 - d5 - d6;
            color = this.getBackgroundCellColor(organism);
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d5));
            graphics2D.setColor(this.getOutergroupColor());
            graphics2D.fill(new Rectangle2D.Double(d, d2 + d5, d3, d6));
            graphics2D.setColor(this.getOutgroupAsIngroupColor());
            graphics2D.fill(new Rectangle2D.Double(d, d2 + d5 + d6, d3, d7));
        }
        return color;
    }

    private boolean isOutgroupAsIngroup(String string) {
        return this.isShowOutgroupAsIngroup() && this.clusterTbl.isOutgroup(string);
    }

    @Override
    public Color getColor(Cluster cluster, String string, String string2) {
        Color color = null;
        color = this.isOutgroupAsIngroup(string) ? (cluster.getOutgroupAsIngroupLocusTagList(string).contains(string2) ? this.getOutgroupAsIngroupColor() : this.getBackgroundCellColor(string)) : this.getBackgroundCellColor(string);
        return color;
    }

    @Override
    public void drawPPMLabel(Graphics2D graphics2D, Cluster cluster, Organism organism, double d, double d2, double d3, double d4, double d5, double d6, int n, Color color) {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        String string = organism.getOrganismCode();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = cluster.getLocusTagList(string);
        if (this.clusterTbl.isOutgroup(string) && optionValues.isOutgroupAsIngroupFlag()) {
            double[] dArray = cluster.getOutgroupGeneClassRatio(string);
            if (dArray[0] == 1.0 || dArray[1] == 1.0 || dArray[2] == 1.0) {
                this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
            } else {
                double d7 = d3 * dArray[0];
                double d8 = d3 * dArray[1];
                double d9 = d3 * dArray[2];
                List[] listArray = cluster.getOutgroupClassLocusTagLists(string);
                List list2 = listArray[0];
                List list3 = listArray[1];
                List list4 = listArray[2];
                int n2 = (int)(d6 + d7 / 2.0 - (double)((list2.size() - 1) * fontMetrics.getAscent()) / 2.0 + (double)fontMetrics.getDescent());
                int n3 = (int)(d6 + d8 / 2.0 - (double)((list3.size() - 1) * fontMetrics.getAscent()) / 2.0 + (double)fontMetrics.getDescent() + d7);
                int n4 = (int)(d6 + d9 / 2.0 - (double)((list4.size() - 1) * fontMetrics.getAscent()) / 2.0 + (double)fontMetrics.getDescent() + d7 + d8);
                this.drawLocusTag(graphics2D, d4, n2, d, list2, color);
                this.drawLocusTag(graphics2D, d4, n3, d, list3, color);
                this.drawLocusTag(graphics2D, d4, n4, d, list4, color);
            }
        } else {
            this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
        }
    }

    @Override
    public boolean isSyncEnable() {
        return false;
    }
}

