/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.AbstractColorDrawable;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.data.Cluster;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.organism.Organism;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;

class GeneInfoColorDrawable
extends AbstractColorDrawable {
    private static final String TITLE = "Gene property";

    GeneInfoColorDrawable(MediatorImpl mediatorImpl) {
        super(mediatorImpl, 32);
    }

    @Override
    public String getNodeLabel() {
        String string = this.clusterTbl.getGeneColorConditionGroup().getLabel();
        return "Gene property [" + string + "]";
    }

    public boolean isFilterActive() {
        return this.clusterTbl.isShowGeneColor();
    }

    public void setFilterActive(boolean bl) {
        this.clusterTbl.setShowGeneColor(bl);
    }

    @Override
    public boolean isEnableDraw(Cluster cluster, Organism organism) {
        if (this.clusterTbl == null) {
            return false;
        }
        if (cluster == null) {
            return false;
        }
        String string = organism.getOrganismCode();
        AbstractInfoTitle abstractInfoTitle = this.clusterTbl.getGeneColorInfoTitle(string);
        if (abstractInfoTitle == null) {
            return false;
        }
        if (abstractInfoTitle.isGene()) {
            Map map = this.clusterTbl.getColorLocusTagMap(string, cluster.getLocusTagList(string));
            return !map.isEmpty() && this.clusterTbl.isEnableGeneColor();
        }
        if (abstractInfoTitle.isCell()) {
            Color color = this.clusterTbl.getColorByCell(string, cluster);
            return color != null && this.clusterTbl.isEnableGeneColor();
        }
        if (abstractInfoTitle.isCluster()) {
            Map map = this.clusterTbl.getClusterColorMap(string, cluster);
            return !map.isEmpty() && this.clusterTbl.isEnableGeneColor();
        }
        return false;
    }

    @Override
    public Color drawPPMCell(Graphics2D graphics2D, double d, double d2, double d3, double d4, Cluster cluster, Organism organism, Map map) {
        String string = organism.getOrganismCode();
        AbstractInfoTitle abstractInfoTitle = this.clusterTbl.getGeneColorInfoTitle(string);
        if (abstractInfoTitle == null) {
            return this.drawCellByDefaultColor(graphics2D, string, d, d2, d3, d4);
        }
        if (abstractInfoTitle.isGene()) {
            return this.drawCellByGenePropertyColor(graphics2D, cluster, string, d, d2, d3, d4);
        }
        if (abstractInfoTitle.isCell()) {
            return this.drawCellByCellPropertyColor(graphics2D, cluster, string, d, d2, d3, d4);
        }
        if (abstractInfoTitle.isCluster()) {
            return this.drawCellByClusterPropertyColor(graphics2D, cluster, string, d, d2, d3, d4);
        }
        return this.drawCellByDefaultColor(graphics2D, string, d, d2, d3, d4);
    }

    private Color drawCellByGenePropertyColor(Graphics2D graphics2D, Cluster cluster, String string, double d, double d2, double d3, double d4) {
        Color color = null;
        Map map = this.clusterTbl.getColorLocusTagMap(string, cluster.getLocusTagList(string));
        if (map.isEmpty()) {
            color = this.drawCellByDefaultColor(graphics2D, string, d, d2, d3, d4);
        } else if (map.size() == 1 && ((List)map.values().iterator().next()).size() == cluster.getGeneInformationList(string).size()) {
            color = (Color)map.keySet().iterator().next();
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
        } else {
            int n = 0;
            for (List list : map.values()) {
                n += list.size();
            }
            double d5 = d4 / (double)n;
            double d6 = d2;
            boolean bl = true;
            for (Color color2 : map.keySet()) {
                if (bl) {
                    color = color2;
                    bl = false;
                }
                List list = (List)map.get(color2);
                double d7 = d5 * (double)list.size();
                graphics2D.setColor(color2);
                graphics2D.fill(new Rectangle2D.Double(d, d6, d3, d7));
                d6 += d7;
            }
        }
        return color;
    }

    private Color drawCellByClusterPropertyColor(Graphics2D graphics2D, Cluster cluster, String string, double d, double d2, double d3, double d4) {
        Color color = null;
        Map map = this.clusterTbl.getClusterColorMap(string, cluster);
        if (map.isEmpty()) {
            color = this.drawCellByDefaultColor(graphics2D, string, d, d2, d3, d4);
        } else if (map.size() == 1) {
            color = (Color)map.values().iterator().next();
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
        } else {
            double d5 = d4 / (double)map.size();
            double d6 = d2;
            boolean bl = true;
            for (Cluster cluster2 : map.keySet()) {
                Color color2 = (Color)map.get(cluster2);
                if (bl) {
                    color = color2;
                    bl = false;
                }
                graphics2D.setColor(color2);
                graphics2D.fill(new Rectangle2D.Double(d, d6, d3, d5));
                d6 += d5;
            }
        }
        return color;
    }

    private Color drawCellByCellPropertyColor(Graphics2D graphics2D, Cluster cluster, String string, double d, double d2, double d3, double d4) {
        Color color = this.clusterTbl.getColorByCell(string, cluster);
        if (color == null) {
            color = ColorFacade.getInstance().getBlankColor(string);
        }
        graphics2D.setColor(color);
        graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
        return color;
    }

    private Color drawCellByDefaultColor(Graphics2D graphics2D, String string, double d, double d2, double d3, double d4) {
        Color color = this.getBackgroundCellColor(string);
        graphics2D.setColor(color);
        graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
        return color;
    }

    @Override
    public Color getColor(Cluster cluster, String string, String string2) {
        return this.clusterTbl.getGeneColor(cluster, string, string2);
    }

    @Override
    public void drawPPMLabel(Graphics2D graphics2D, Cluster cluster, Organism organism, double d, double d2, double d3, double d4, double d5, double d6, int n, Color color) {
        String string = organism.getOrganismCode();
        AbstractInfoTitle abstractInfoTitle = this.clusterTbl.getGeneColorInfoTitle(string);
        if (abstractInfoTitle == null) {
            return;
        }
        if (abstractInfoTitle.isGene()) {
            this.drawPPMLabelByGeneProperty(graphics2D, cluster, organism, d, d2, d3, d4, d5, d6, n, color);
        } else if (abstractInfoTitle.isCluster() || abstractInfoTitle.isCell()) {
            this.drawPPMLabelByClusterProperty(graphics2D, cluster, organism, d, d2, d3, d4, d5, d6, n, color);
        }
    }

    private void drawPPMLabelByGeneProperty(Graphics2D graphics2D, Cluster cluster, Organism organism, double d, double d2, double d3, double d4, double d5, double d6, int n, Color color) {
        String string = organism.getOrganismCode();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = cluster.getLocusTagList(string);
        Map map = this.clusterTbl.getColorLocusTagMap(string, cluster.getLocusTagList(string));
        if (map.isEmpty()) {
            this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
        } else if (map.size() == 1 && ((List)map.values().iterator().next()).size() == cluster.getGeneInformationList(string).size()) {
            this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
        } else {
            List list2 = cluster.getGeneInformationList(string);
            double d7 = this.clusterTbl.isOutgroup(string) ? d3 : d2;
            double d8 = d7 / (double)list2.size();
            double d9 = this.clusterTbl.isOutgroup(string) ? d6 : d5;
            for (Color color2 : map.keySet()) {
                List list3 = (List)map.get(color2);
                double d10 = d8 * (double)list3.size();
                int n2 = (int)(d9 + d10 / 2.0 - (double)((list3.size() - 1) * fontMetrics.getAscent()) / 2.0 + (double)fontMetrics.getDescent());
                this.drawLocusTag(graphics2D, d4, n2, d, list3, color);
                d9 += d10;
            }
        }
    }

    private void drawPPMLabelByClusterProperty(Graphics2D graphics2D, Cluster cluster, Organism organism, double d, double d2, double d3, double d4, double d5, double d6, int n, Color color) {
        String string = organism.getOrganismCode();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = cluster.getLocusTagList(string);
        this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
    }

    @Override
    public boolean isSyncEnable() {
        return false;
    }
}

