/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color.geneinfo;

import cgdp.recog.color.geneinfo.ColorValue;
import cgdp.recog.color.geneinfo.GeneColorCondition;
import cgdp.recog.color.geneinfo.GeneColorConditionGroup;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.util.List;
import java.util.Set;

class GeneColorExporter
extends FileExporter {
    private static final String TITLE_PROPERTY_COLOR_GROUP = "PropertyColorGroup";
    private static final String TITLE_PROPERTY_COLOR = "PropertyColor";
    private static final String KEY_CALC_METHOD_TYPE = "#CalcMethodType";
    private static final String KEY_ORGANISM = "#Organism";
    private static final String KEY_PROPERTY_TYPE = "#PropertyType";
    private static final String KEY_PROPERTY_KEY = "#PropertyKey";
    private static final String KEY_ORDER_TYPE = "#OrderType";
    private static final String KEY_MULTI_INFO_TYPE = "#MultiInfoType";
    private static final String KEY_THRESHOLD = "#Threshold";
    private static final String DELIMITER = "\t";
    private static final String DELIMITER_COMMA = ",";
    private static final String DELIMITER_COLOR_VALUE = ":";
    private static final String SEP_GROUP = "////";
    private static final String SEP_CONDITION = "//";
    private String filepath;
    private GeneColorConditionGroup geneColorConditionGroup;

    GeneColorExporter(String string, GeneColorConditionGroup geneColorConditionGroup) {
        this.filepath = string;
        this.geneColorConditionGroup = geneColorConditionGroup;
    }

    @Override
    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TITLE_PROPERTY_COLOR_GROUP);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_CALC_METHOD_TYPE);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(this.geneColorConditionGroup.getCalcMethodType());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        Set set = this.geneColorConditionGroup.getGeneColorConditionSet();
        int n = 0;
        for (GeneColorCondition geneColorCondition : set) {
            stringBuffer.append(this.getConditionStr(n, geneColorCondition));
            stringBuffer.append(SEP_CONDITION);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getConditionStr(int n, GeneColorCondition geneColorCondition) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PropertyColor\t" + (n + 1));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_ORGANISM);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(StringTool.conbineStrList(geneColorCondition.getOrganismCodeSet(), DELIMITER_COMMA));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_PROPERTY_TYPE);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(geneColorCondition.getInfoTitle().getCls());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_PROPERTY_KEY);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(geneColorCondition.getInfoTitle().getKey());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_ORDER_TYPE);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(geneColorCondition.getOrderType());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_MULTI_INFO_TYPE);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(geneColorCondition.getMultiInfoType());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_THRESHOLD);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(this.getThreshold(geneColorCondition.getColorValueList()));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        return stringBuffer.toString();
    }

    private String getThreshold(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (ColorValue colorValue : list) {
            stringBuffer.append(ColorUtil.color2Str(colorValue.getColor()));
            stringBuffer.append(DELIMITER_COLOR_VALUE);
            stringBuffer.append(colorValue.getValue());
            if (n != list.size() - 1) {
                stringBuffer.append(DELIMITER_COMMA);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }
}

