/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeParameterUtil;
import cgdp.recog.coregenome.CoreGenomeServerAccessHelper;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.SimpleServerConnection;
import java.util.ArrayList;
import java.util.List;

public class CoreGenomeDownloader
extends SimpleServerConnection {
    private String domClustId;
    private String domClustViewId;
    private String coreTabId;
    private List organismCodeList = new ArrayList();
    private StringBuffer sb = new StringBuffer();

    public CoreGenomeDownloader(String string, String string2, String string3) {
        this.domClustId = string;
        this.domClustViewId = string2;
        this.coreTabId = string3;
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getCoreGenomeUrl());
        this.setOptions();
    }

    @Override
    public void parseOutputString(int n, String string) {
        if (CoreGenomeParameterUtil.isSpecies(string)) {
            this.organismCodeList = CoreGenomeParameterUtil.getSpeciesList(string);
        }
        this.sb.append(string);
        this.sb.append(FileUtil.LINE_SEPARETOR);
    }

    @Override
    protected void after() {
        String string;
        CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = new CoreGenomeAlignmentCondition();
        coreGenomeAlignmentCondition.setDomClustId(this.domClustId);
        coreGenomeAlignmentCondition.setClusterViewId(this.domClustViewId);
        coreGenomeAlignmentCondition.setWindowSize(20);
        if (!CollectionUtil.isNull(this.organismCodeList)) {
            string = (String)this.organismCodeList.get(0);
            coreGenomeAlignmentCondition.setOrganismList(OrganismUtil.getOrganismList(this.organismCodeList));
            coreGenomeAlignmentCondition.setReferenceOrganismCode(string);
            coreGenomeAlignmentCondition.setViewOrganismCodeList(this.organismCodeList);
        }
        string = CoreGenomeServerAccessHelper.createConditionString(coreGenomeAlignmentCondition);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(this.sb);
        this.sb = stringBuffer;
    }

    private void setOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CORE_TAB_ID=");
        stringBuffer.append(this.coreTabId);
        this.setOptions(stringBuffer.toString());
    }

    public String getContents() {
        return this.sb.toString();
    }
}

