/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeAnalysis;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.system.Codec;
import cgdp.recog.system.URLList;
import cgdp.recog.util.ApplicationLogger;
import java.io.UnsupportedEncodingException;

class CoreGenomeUploader
extends AbstractServerResourceAccesser {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeUploader.class);
    private CoreGenomeAnalysis analysis;
    private boolean overwrite = false;

    CoreGenomeUploader(CoreGenomeAnalysis coreGenomeAnalysis, boolean bl) throws UnsupportedEncodingException {
        this.analysis = coreGenomeAnalysis;
        this.overwrite = bl;
        this.setProject(coreGenomeAnalysis.getProject());
        this.setContextPath(URLList.getInstance().getPutProjectCluster());
        this.setOptions();
    }

    @Override
    protected void parseOutputStringData(int n, String string) {
    }

    private void setOptions() throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("proj_id=");
        stringBuffer.append(Codec.encode(this.analysis.getProjectId4Server()));
        stringBuffer.append("&mode=");
        if (this.overwrite) {
            stringBuffer.append("replace");
        }
        stringBuffer.append("&type=core");
        stringBuffer.append("&clusttabid=");
        stringBuffer.append(Codec.encode(this.analysis.getDomClustId()));
        stringBuffer.append("&name=");
        stringBuffer.append(Codec.encode(this.analysis.getName()));
        stringBuffer.append("&coreid=");
        stringBuffer.append(Codec.encode(this.analysis.getCoreGenomeId()));
        stringBuffer.append("&descr=");
        stringBuffer.append(Codec.encode(this.analysis.getDescription()));
        this.setOptions(stringBuffer.toString());
    }
}

