/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Chromosome;
import cgdp.recog.data.DataManager;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ChromosomeImporter
extends FileImporter {
    public static final String DELIMITER = "\t";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_UDATE = "udate";
    private static final String COLUMN_GENOME = "genome";
    private static final String COLUMN_SPID = "spid";
    private static final String COLUMN_SP = "sp";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_SEQNO = "seqno";
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_SHAPE = "shape";
    private static final String COLUMN_STATUS = "status";
    private static final String COLUMN_ACCESSION = "accession";
    private static final String COLUMN_GI = "gi";
    private static final String COLUMN_SEQ = "seq";
    private static final String COLUMN_SEQ_LENGTH = "seq_length";
    private static final String COLUMN_COUNT_GENES = "count_genes";
    private static final String COLUMN_LENGTH = "length";
    private String organismCode;
    private String filepath;
    private List columnNameList = new ArrayList();
    private List chromosomeList = new ArrayList();

    public ChromosomeImporter(String string) {
        this.organismCode = string;
        this.filepath = DataManager.getChromosomeFilePath(this.organismCode);
    }

    public void setFilepath(String string) {
        this.filepath = string;
    }

    @Override
    protected void parseHeaderLine(String string) {
        this.columnNameList.addAll(StringTool.splitString(string, DELIMITER));
    }

    @Override
    protected void parseDataLine(int n, String string) {
        Chromosome chromosome = new Chromosome();
        Vector vector = StringTool.splitString(string, DELIMITER);
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)this.columnNameList.get(i);
            String string3 = String.valueOf(vector.get(i));
            this.setParameter(string2, string3, chromosome);
        }
        this.chromosomeList.add(chromosome);
    }

    private void setParameter(String string, String string2, Chromosome chromosome) {
        if (string.equals(COLUMN_ID)) {
            chromosome.setId(Integer.parseInt(string2));
        } else if (string.equals(COLUMN_SPID)) {
            chromosome.setSpid(string2);
        } else if (string.equals(COLUMN_SP)) {
            chromosome.setOrganismCode(string2);
        } else if (string.equals(COLUMN_GENOME)) {
            chromosome.setGenome(string2);
        } else if (string.equals(COLUMN_SHAPE)) {
            chromosome.setShape(string2);
        } else if (string.equals(COLUMN_LENGTH)) {
            try {
                chromosome.setLength(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                chromosome.setLength(0);
            }
        } else if (string.equals(COLUMN_NAME)) {
            chromosome.setName(string2);
        } else if (string.equals(COLUMN_STATUS)) {
            chromosome.setStatus(string2);
        } else if (string.equals(COLUMN_SEQNO)) {
            chromosome.setSeqNo(string2);
        } else if (string.equals(COLUMN_TYPE)) {
            chromosome.setType(string2);
        } else if (string.equals(COLUMN_ACCESSION)) {
            chromosome.setAccession(string2);
        } else if (string.equals(COLUMN_GI)) {
            chromosome.setGi(string2);
        } else if (string.equals(COLUMN_SEQ)) {
            chromosome.setSeq(string2);
        } else if (string.equals(COLUMN_SEQ_LENGTH)) {
            try {
                chromosome.setSeqLength(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                chromosome.setSeqLength(0);
            }
        } else if (string.equals(COLUMN_COUNT_GENES)) {
            try {
                chromosome.setCountGene(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                chromosome.setCountGene(0);
            }
        }
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    public List getChromosomeList() {
        return this.chromosomeList;
    }
}

