/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.DataManager;
import cgdp.recog.data.Genome;
import cgdp.recog.data.GenomeImporter;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GenomeTbl {
    private static final ApplicationLogger logger = new ApplicationLogger(GenomeTbl.class);
    private static final String[] HEADERS = new String[]{"spid", "sp", "specweight", "abbrev", "orgname", "strain", "mbgd_update"};
    private static final String[] HEADERS_DEV = new String[]{"spid", "sp", "specweight", "abbrev", "orgname", "type", "strain", "mbgd_update"};
    private List genomeList = new ArrayList();
    private Map genomeMap = new HashMap();

    public boolean read() {
        return this.read(null);
    }

    public boolean read(Collection collection) {
        try {
            GenomeImporter genomeImporter = new GenomeImporter(DataManager.getGenomeDat());
            genomeImporter.setTargetOrganismCodeSet(collection);
            genomeImporter.execute();
            this.genomeList = genomeImporter.getGenomeList();
            this.genomeMap.clear();
            for (Genome genome : this.genomeList) {
                this.genomeMap.put(genome.getSpeciesCode(), genome);
            }
            return true;
        }
        catch (Exception exception) {
            logger.warn("Fail to read genome.dat", exception);
            return false;
        }
    }

    public boolean equalsUpdate(Genome genome) {
        Genome genome2 = (Genome)this.genomeMap.get(genome.getSpeciesCode());
        if (genome2 == null) {
            return false;
        }
        return genome2.getMbgdUpdate().equals(genome.getMbgdUpdate());
    }

    public void updateGenome(Genome genome) {
        Genome genome2 = (Genome)this.genomeMap.get(genome.getSpeciesCode());
        if (genome2 == null) {
            this.genomeMap.put(genome.getSpeciesCode(), genome);
            this.genomeList.add(genome);
        } else {
            genome2.update(genome);
        }
    }

    public static String getURLOption() {
        return "?table=genome&fields=" + StringTool.conbineStrArray(HEADERS, ",");
    }

    public static String getGenomeParamURLOption() {
        return "?table=attribute&category=genome&fields=category,name,value&no_header=1";
    }

    public List getGenomeList() {
        return this.genomeList;
    }

    public long getSpecweight(String string) {
        long l = 0L;
        Genome genome = (Genome)this.genomeMap.get(string);
        if (genome != null) {
            l = genome.getSpecweight();
        }
        return l;
    }

    public String getOrganismName(String string) {
        String string2 = null;
        Genome genome = (Genome)this.genomeMap.get(string);
        if (genome != null) {
            string2 = genome.getOrgname();
        }
        return string2;
    }

    public List createOrganismList(Collection collection) {
        this.read(collection);
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        for (String string : collection) {
            Genome genome = (Genome)this.genomeMap.get(string);
            Organism organism = new Organism();
            if (genome != null) {
                organism.setName(genome.getOrgname());
                organism.setOrganismCode(genome.getSpeciesCode());
                organism.setAbbrev(genome.getAbbrev());
                organism.setStrain(genome.getStrain());
            } else {
                organism.setName(string);
                organism.setOrganismCode(string);
            }
            arrayList.add(organism);
        }
        return arrayList;
    }

    public Organism createOrganism(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        List list = this.createOrganismList(hashSet);
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        return (Organism)list.get(0);
    }

    public Map createOrganismMap(Collection collection) {
        this.read(collection);
        HashMap<String, Organism> hashMap = new HashMap<String, Organism>();
        for (Genome genome : this.genomeList) {
            Organism organism = ModifiedOrganismManager.getInstance().getModifiedOrganism(genome.getAbbrev());
            if (organism != null) {
                hashMap.put(organism.getOrganismCode(), organism);
                continue;
            }
            Organism organism2 = new Organism();
            organism2.setName(genome.getOrgname());
            organism2.setOrganismCode(genome.getSpeciesCode());
            organism2.setAbbrev(genome.getAbbrev());
            organism2.setStrain(genome.getStrain());
            hashMap.put(genome.getSpeciesCode(), organism2);
        }
        return hashMap;
    }
}

