/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.domclust.DomClustCondition;
import cgdp.recog.domclust.DomClustExecuter;
import cgdp.recog.domclust.FileLoader;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.process.SingleTaskManager;
import cgdp.recog.statusbar.StatusBar;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.update.AbstractDataUpdater;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.ResourceBandleWrapper;
import java.awt.Component;
import java.awt.Frame;
import java.net.ConnectException;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DomClust
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClust.class);
    private Frame parent;
    private StatusBar statusBar;
    private MediatorImpl mediator;
    private DomClustCondition domClustCondition;
    private String filepath;

    public DomClust(Frame frame, StatusBar statusBar, MediatorImpl mediatorImpl, DomClustCondition domClustCondition) {
        this.parent = frame;
        this.statusBar = statusBar;
        this.mediator = mediatorImpl;
        this.domClustCondition = domClustCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ProgressImpl progressImpl) {
        Object object;
        try {
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            Map map = DomClustExecuter.createProcMap();
            object = AbstractDataUpdater.createDomClustExecGeneInfoUpdater(this.parent, this.mediator, this.domClustCondition.getOrganismCodeSet());
            object.execute(progressImpl);
            progressImpl.nextProc();
            progressImpl.setTotal(100);
            progressImpl.setCount(-1);
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            DomClustExecuter domClustExecuter = new DomClustExecuter(this.domClustCondition, progressImpl, map);
            domClustExecuter.execute();
            String string = domClustExecuter.getFilepath();
            if (domClustExecuter.isCanceled()) {
                this.setCancel(true);
                return;
            }
            if (domClustExecuter.isError()) {
                this.setError(true);
                this.setErrorMessage(domClustExecuter.getMessage());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageManager.showErrorMessage((Component)DomClust.this.parent, DomClust.this.getErrorMessages());
                    }
                });
                return;
            }
            this.setFilepath(string);
            if (this.domClustCondition.isExistTaxMapOrganismCode()) {
                String string2 = domClustExecuter.getDomClustId();
                TaxMapFacade.downloadTaxMapInfo(string2, this.domClustCondition.getTaxMapOrganismCodeSet(), true);
            }
            for (int i = 0; i < map.size(); ++i) {
                progressImpl.nextProc();
            }
            progressImpl.setEnabledBackgroundButton(false);
            progressImpl.setEnabledCancelButton(false);
            this.statusBar.setVisibledProgressLabel(false);
            if (!progressImpl.isVisible() && !MessageManager.showConfirmMessage((Component)this.parent, "Load DomClust file?")) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SingleTaskManager.getInstance().getProgressDialog().setVisible(true);
                }
            });
            FileLoader fileLoader = FileLoader.createDomClustLoader((Component)this.parent, this.mediator, string);
            fileLoader.execute(progressImpl);
        }
        catch (ConnectException connectException) {
            object = ResourceBandleWrapper.getMessage("error.access.server");
            logger.warn((String)object, connectException);
            if (!this.isCancel()) {
                MessageManager.showErrorMessage((Component)this.parent, (String)object);
            }
        }
        catch (Exception exception) {
            object = "Ortholog Clustering (DomClust) failed.";
            logger.warn((String)object, exception);
            if (!this.isCancel()) {
                MessageManager.showErrorMessage((Component)this.parent, (String)object);
            }
        }
        catch (Error error) {
            object = "Ortholog Clustering (DomClust) failed.";
            logger.warn((String)object, error);
            if (!this.isCancel()) {
                MessageManager.showErrorMessage((Component)this.parent, (String)object);
            }
        }
        finally {
            this.statusBar.setVisibledProgressLabel(false);
        }
    }

    private String getFilepath() {
        return this.filepath;
    }

    private void setFilepath(String string) {
        this.filepath = string;
    }

    @Override
    public void done() {
        if (this.isCancel() || this.isError()) {
            return;
        }
        MessageManager.showMessage((Component)this.parent, "Completed!!!\n" + this.getFilepath());
    }
}

