/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DomClustTabImporter
extends FileImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustTabImporter.class);
    private static final String DELIMITER = "\t";
    private static final String ORGANISM_DELIMITER = ",";
    private static final String LOCUSTAG_DELIMITER = " ";
    private List ingroupOrganismCodeList = new ArrayList();
    private List outgroupOrganismCodeList = new ArrayList();
    private List clusterList = new ArrayList();
    private List headerList = new ArrayList();
    private String functionCategoryType = "mbgd";
    private String filepath;

    public DomClustTabImporter(String string) {
        this.setFilepath(string);
        this.setExistParameter(true);
        this.setExistHeader(false);
    }

    private void setFilepath(String string) {
        this.filepath = string;
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    @Override
    protected void parseParameterLine(String string) {
        if (string.startsWith("Cluster ID")) {
            this.parseHeaderLine(string);
            this.setReadParameter(true);
            this.setHeaderOnly(true);
            return;
        }
        if (ServerStatus.isIngroup(string)) {
            this.ingroupOrganismCodeList = ServerStatus.getIngroupList(string);
        } else if (ServerStatus.isOutgroup(string)) {
            this.outgroupOrganismCodeList = ServerStatus.getOutgroupList(string);
        }
    }

    @Override
    protected void parseDataLine(int n, String string) {
        Vector vector = StringTool.splitString(string, DELIMITER);
        int n2 = 0;
        Cluster cluster = new Cluster();
        cluster.setClusterId(Integer.parseInt((String)vector.get(n2)));
        cluster.setGeneName((String)vector.get(++n2));
        cluster.setFunctionCategory(this.functionCategoryType, (String)vector.get(++n2));
        cluster.setDescription((String)vector.get(n2 += 2));
        ++n2;
        if (this.isOutgroup()) {
            cluster.setSubClusterId(Integer.parseInt((String)vector.get(n2)));
            cluster.setSubGeneName((String)vector.get(++n2));
            cluster.setSubFunctionCategory(this.functionCategoryType, (String)vector.get(++n2));
            cluster.setSubDescription((String)vector.get(n2 += 2));
            ++n2;
        }
        n2 = this.registerGeneInfo(cluster, this.ingroupOrganismCodeList, n2, vector);
        n2 = this.registerGeneInfo(cluster, this.outgroupOrganismCodeList, n2, vector);
        this.clusterList.add(cluster);
    }

    private int registerGeneInfo(Cluster cluster, List list, int n, Vector vector) {
        if (CollectionUtil.isNull(list)) {
            return n;
        }
        for (String string : list) {
            String string2 = (String)vector.get(n);
            ArrayList arrayList = new ArrayList(StringTool.splitString(string2, LOCUSTAG_DELIMITER));
            for (String string3 : arrayList) {
                GeneInformation geneInformation = new GeneInformation();
                geneInformation.setLocusTag(string3);
                cluster.addGeneInfo(string, geneInformation);
            }
            ++n;
        }
        return n;
    }

    @Override
    protected void parseHeaderLine(String string) {
        Vector vector = StringTool.splitString(string, DELIMITER);
        this.headerList.addAll(vector);
        this.functionCategoryType = this.getFunctionCategoryType((String)vector.get(2));
    }

    private boolean isOutgroup() {
        return !this.outgroupOrganismCodeList.isEmpty();
    }

    private String getFunctionCategoryType(String string) {
        String string2 = "mbgd";
        if (string.indexOf("MBGD") != -1) {
            return "mbgd";
        }
        if (string.indexOf("COG") != -1) {
            return "cog";
        }
        if (string.indexOf("KEGG") != -1) {
            return "kegg";
        }
        if (string.indexOf("TIGR") != -1) {
            return "tigr";
        }
        return string2;
    }

    public List getIngroupOrganismCodeList() {
        return this.ingroupOrganismCodeList;
    }

    public List getOutgroupOrganismCodeList() {
        return this.outgroupOrganismCodeList;
    }

    public List getClusterList() {
        return this.clusterList;
    }
}

