/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.active.FilterActivation;
import cgdp.recog.taxonomy.TaxonomyTree;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaxFilterCondition
implements FilterActivation,
Transferable {
    private static final String FLAVOR_NAME = "FilterCondition";
    private static final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "FilterCondition");
    public static final int ALL = 1;
    public static final int ANY = 2;
    public static final int NONE = 3;
    public static final int CANCEL = 0;
    public static final long DEFAULT_FILTER_ID = -1L;
    public static final int DEFAULT_LESS_THRESHOLD_COUNT = 0;
    public static final int DEFAULT_MORE_THRESHOLD_COUNT = 1;
    public static final double DEFAULT_LESS_THRESHOLD_PERCENT = 0.0;
    public static final double DEFAULT_MORE_THRESHOLD_PERCENT = 0.5;
    static final boolean DEFAULT_COUNT_FLAG = false;
    static final boolean DEFAULT_LESS_COUNT = false;
    static final boolean DEFAULT_MORE_COUNT = true;
    static final boolean DEFAULT_LESS_PERCENT = false;
    static final boolean DEFAULT_MORE_PERCENT = true;
    static final String DEFAULT_TAX_UNIT = "genome";
    private long id = System.currentTimeMillis();
    private String name;
    private int condition;
    private Map spMap;
    private boolean lessCount = false;
    private boolean moreCount = true;
    private boolean lessPercent = false;
    private boolean morePercent = true;
    private int lessThresholdCount = 0;
    private int moreThresholdCount = 1;
    private double lessThresholdPercent = 0.0;
    private double moreThresholdPercent = 0.5;
    private boolean countFlag = false;
    private boolean active = true;
    private String taxUnit = null;
    private static TaxonomyTree taxTree = null;

    public TaxFilterCondition(String string, int n, Map map) {
        this.name = string;
        this.condition = n;
        this.spMap = new HashMap(map);
    }

    public static TaxFilterCondition createFilterCondition(String string, int n, Map map) {
        return new TaxFilterCondition(string, n, map);
    }

    public static TaxFilterCondition createAnyCountFilterCondition(String string, Map map, boolean bl, boolean bl2, int n, int n2) {
        TaxFilterCondition taxFilterCondition = new TaxFilterCondition(string, 2, map);
        taxFilterCondition.setCountFlag(true);
        taxFilterCondition.setLessCount(bl);
        taxFilterCondition.setMoreCount(bl2);
        taxFilterCondition.setLessThresholdCount(n);
        taxFilterCondition.setMoreThresholdCount(n2);
        return taxFilterCondition;
    }

    public static TaxFilterCondition createAnyPercentFilterCondition(String string, Map map, boolean bl, boolean bl2, double d, double d2) {
        TaxFilterCondition taxFilterCondition = new TaxFilterCondition(string, 2, map);
        taxFilterCondition.setCountFlag(false);
        taxFilterCondition.setLessPercent(bl);
        taxFilterCondition.setMorePercent(bl2);
        taxFilterCondition.setLessThresholdPercent(d);
        taxFilterCondition.setMoreThresholdPercent(d2);
        return taxFilterCondition;
    }

    public static void setTaxTree(TaxonomyTree taxonomyTree) {
        taxTree = taxonomyTree;
    }

    public void setTaxUnit(String string) {
        this.taxUnit = string;
    }

    public void unsetTaxUnit() {
        this.taxUnit = null;
    }

    public String getTaxUnit() {
        return this.taxUnit;
    }

    boolean isMatchCondition(Collection collection, Collection collection2) {
        if (this.isAll()) {
            return this.isMatchAll(collection, collection2);
        }
        if (this.isAny()) {
            return this.isMatchAny(collection, collection2);
        }
        if (this.isNone()) {
            return this.isMatchNone(collection, collection2);
        }
        return false;
    }

    private Set getTargetSpSet() {
        return this.getTargetSpSet(null);
    }

    private Set getTargetSpSet(Collection collection) {
        HashSet hashSet = new HashSet(this.spMap.keySet());
        if (collection != null) {
            hashSet.removeAll(collection);
        }
        return hashSet;
    }

    public int getTargetSpSize() {
        return this.getTargetSpSize(this.taxUnit);
    }

    public int getTargetSpSize(String string) {
        return this.getTargetSpSize(null, string);
    }

    private int getTargetSpSize(Collection collection) {
        return this.getTargetSpSize(collection, this.taxUnit);
    }

    private int getTargetSpSize(Collection collection, String string) {
        if (string != null) {
            int n = 0;
            HashSet<TaxonomyTreeNode> hashSet = new HashSet<TaxonomyTreeNode>();
            HashSet hashSet2 = new HashSet();
            for (String string2 : this.spMap.keySet()) {
                TaxonomyTreeNode taxonomyTreeNode = taxTree.getTaxonomyTreeNode(string2);
                TaxonomyTreeNode taxonomyTreeNode2 = null;
                if (taxonomyTreeNode != null) {
                    taxonomyTreeNode2 = taxonomyTreeNode.getParentNode(string);
                    if (taxonomyTreeNode2 != null) {
                        if (hashSet.contains(taxonomyTreeNode2)) continue;
                        hashSet.add(taxonomyTreeNode2);
                        ++n;
                        continue;
                    }
                    ++n;
                    continue;
                }
                ++n;
            }
            return n;
        }
        return this.getTargetSpSet(collection).size();
    }

    private boolean isMatchAll(Collection collection, Collection collection2) {
        return collection.containsAll(this.getTargetSpSet(collection2));
    }

    private boolean isMatchNone(Collection collection, Collection collection2) {
        Set set = this.getTargetSpSet(collection2);
        for (String string : set) {
            if (!collection.contains(string)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCountUniqueTaxa() {
        if (this.taxUnit == null) return false;
        if (this.taxUnit.equals(DEFAULT_TAX_UNIT)) return false;
        if (taxTree == null) return false;
        return true;
    }

    private boolean isMatchAny(Collection collection, Collection collection2) {
        Set set = this.getTargetSpSet(collection2);
        int n = 0;
        HashSet<TaxonomyTreeNode> hashSet = new HashSet<TaxonomyTreeNode>();
        boolean bl = this.isCountUniqueTaxa();
        for (String string : set) {
            TaxonomyTreeNode taxonomyTreeNode;
            TaxonomyTreeNode taxonomyTreeNode2;
            if (!collection.contains(string)) continue;
            if (bl && (taxonomyTreeNode2 = taxTree.getTaxonomyTreeNode(string)) != null && (taxonomyTreeNode = taxonomyTreeNode2.getParentNode(this.taxUnit)) != null) {
                if (hashSet.contains(taxonomyTreeNode)) continue;
                hashSet.add(taxonomyTreeNode);
            }
            ++n;
        }
        boolean bl2 = false;
        if (this.isLess() && this.isMore()) {
            int n2 = this.getLessThreshold(collection2);
            int n3 = this.getMoreThreshold(collection2);
            bl2 = this.isAnyConditionConbinedAnd(collection2) ? n <= n2 & n >= n3 : n <= n2 | n >= n3;
        } else if (this.isLess()) {
            int n4 = this.getLessThreshold(collection2);
            bl2 = n <= n4;
        } else if (this.isMore()) {
            int n5 = this.getMoreThreshold(collection2);
            bl2 = n >= n5;
        }
        return bl2;
    }

    boolean isAnyConditionConbinedAnd(Collection collection) {
        int n = this.getLessThreshold(collection);
        int n2 = this.getMoreThreshold(collection);
        return n2 <= n;
    }

    private boolean addSp(String string, String string2) {
        if (this.spMap.containsKey(string)) {
            return false;
        }
        this.spMap.put(string, string2);
        return true;
    }

    boolean addSpList(Map map) {
        boolean bl = false;
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            bl |= this.addSp(string, string2);
        }
        return bl;
    }

    boolean removeSp(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.spMap.remove(iterator.next()) != null;
        }
        return bl;
    }

    boolean isEmptySp() {
        return this.spMap.isEmpty();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    int getCondition() {
        return this.condition;
    }

    Set getSpSet() {
        return new HashSet(this.spMap.keySet());
    }

    List getSpList() {
        ArrayList arrayList = new ArrayList(this.spMap.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    String getSpName(String string) {
        return (String)this.spMap.get(string);
    }

    int getSpSize() {
        return this.spMap.size();
    }

    double getMaxThreshold() {
        if (this.isCountFlag()) {
            return this.getMoreThresholdCount();
        }
        return this.getMoreThresholdPercent();
    }

    double getLessThresholdPercent() {
        return this.lessThresholdPercent;
    }

    double getMoreThresholdPercent() {
        return this.moreThresholdPercent;
    }

    int getLessThresholdCount() {
        return this.lessThresholdCount;
    }

    int getMoreThresholdCount() {
        return this.moreThresholdCount;
    }

    private int getLessThreshold(Collection collection) {
        if (this.isCountFlag()) {
            return this.getLessThresholdCount();
        }
        return (int)Math.floor(this.getLessThresholdPercent() * (double)this.getTargetSpSize(collection));
    }

    private int getMoreThreshold(Collection collection) {
        if (this.isCountFlag()) {
            return this.getMoreThresholdCount();
        }
        return (int)Math.ceil(this.getMoreThresholdPercent() * (double)this.getTargetSpSize(collection));
    }

    void setLessThreshold(boolean bl, double d) {
        this.setCountFlag(bl);
        if (bl) {
            this.setLessThresholdCount((int)d);
        } else {
            this.setLessThresholdPercent(d);
        }
    }

    void setMoreThreshold(boolean bl, double d) {
        this.setCountFlag(bl);
        if (bl) {
            this.setMoreThresholdCount((int)d);
        } else {
            this.setMoreThresholdPercent(d);
        }
    }

    void setLessThresholdPercent(double d) {
        this.lessThresholdPercent = d;
    }

    void setLessThresholdCount(int n) {
        this.lessThresholdCount = n;
    }

    void setMoreThresholdPercent(double d) {
        this.moreThresholdPercent = d;
    }

    void setMoreThresholdCount(int n) {
        this.moreThresholdCount = n;
    }

    boolean isAll() {
        return TaxFilterCondition.isAll(this.condition);
    }

    boolean isAny() {
        return this.condition == 2;
    }

    boolean isNone() {
        return TaxFilterCondition.isNone(this.condition);
    }

    boolean equalsId(long l) {
        return this.id == l;
    }

    boolean equalsCondition(int n) {
        return this.condition == n;
    }

    boolean equalsSpList(Collection collection) {
        return new HashSet(this.spMap.keySet()).equals(collection);
    }

    boolean containsSp(String string) {
        return this.spMap.containsKey(string);
    }

    public static boolean isAll(int n) {
        return n == 1;
    }

    public static boolean isAny(int n) {
        return n == 2;
    }

    public static boolean isNone(int n) {
        return n == 3;
    }

    public static boolean isExclude(int n) {
        return n == 0;
    }

    public static boolean isAnyNew(int n, long l) {
        return TaxFilterCondition.isAny(n) && l == -1L;
    }

    static boolean isAnyAdd(int n, long l) {
        return TaxFilterCondition.isAny(n) && l != -1L;
    }

    private boolean isLess() {
        if (this.isCountFlag()) {
            return this.isLessCount();
        }
        return this.isLessPercent();
    }

    private boolean isMore() {
        if (this.isCountFlag()) {
            return this.isMoreCount();
        }
        return this.isMorePercent();
    }

    boolean isLessCount() {
        return this.lessCount;
    }

    void setLessCount(boolean bl) {
        this.lessCount = bl;
    }

    boolean isMoreCount() {
        return this.moreCount;
    }

    void setMoreCount(boolean bl) {
        this.moreCount = bl;
    }

    boolean isLessPercent() {
        return this.lessPercent;
    }

    void setLessPercent(boolean bl) {
        this.lessPercent = bl;
    }

    boolean isMorePercent() {
        return this.morePercent;
    }

    void setMorePercent(boolean bl) {
        this.morePercent = bl;
    }

    boolean isCountFlag() {
        return this.countFlag;
    }

    void setCountFlag(boolean bl) {
        this.countFlag = bl;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{FLAVOR};
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.getHumanPresentableName().equals(FLAVOR_NAME);
    }

    @Override
    public void flipFilterActive() {
        this.setFilterActive(!this.isFilterActive());
    }

    @Override
    public boolean isFilterActive() {
        return this.active;
    }

    @Override
    public void setFilterActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public boolean isSyncEnable() {
        return false;
    }
}

