/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.funccat;

import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.funccat.FunctionCategoryComparator;
import cgdp.recog.funccat.FunctionCategoryExporter;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.SimpleServerConnection;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class FunctionCategoryDownloader {
    private static final ApplicationLogger logger = new ApplicationLogger(FunctionCategoryDownloader.class);
    private String errorMessage;
    private boolean error = false;
    private Map functionCategoryMap = new HashMap();

    public void execute() throws Exception {
        CategoryColorDownloader categoryColorDownloader = new CategoryColorDownloader();
        categoryColorDownloader.execute();
        if (categoryColorDownloader.isError()) {
            this.error = true;
            this.errorMessage = categoryColorDownloader.getMessage();
            return;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CategoryNameDownloader categoryNameDownloader = new CategoryNameDownloader();
        categoryNameDownloader.execute();
        if (categoryNameDownloader.isError()) {
            this.error = true;
            this.errorMessage = categoryNameDownloader.getMessage();
            return;
        }
        Map map = categoryColorDownloader.getColorMap();
        Map map2 = categoryNameDownloader.getCategoryNameMap();
        Set set = map.keySet();
        for (String string : set) {
            this.addFunctionCategoryList(string, (Map)map.get(string), (Map)map2.get(string));
        }
    }

    private void addFunctionCategoryList(String string, Map map, Map map2) {
        String string2;
        Object object;
        ArrayList<FuncCat> arrayList = new ArrayList<FuncCat>();
        Set set = map2.keySet();
        for (String object2 : set) {
            object = (FuncCat)map2.get(object2);
            if (object != null) {
                string2 = (String)map.get(object2);
                ((FuncCat)object).setColor(string2);
            }
            arrayList.add((FuncCat)object);
        }
        for (FuncCat funcCat : arrayList) {
            FuncCat funcCat2;
            if (!StringTool.isNull(funcCat.getColor())) continue;
            object = funcCat.getFunctionCategoryNo();
            string2 = null;
            while (string2 == null) {
                string2 = (String)map.get(object);
                int n = ((String)object).lastIndexOf(46);
                if (n == -1) break;
                object = ((String)object).substring(0, n);
            }
            if (string2 == null && (funcCat2 = FuncCatTbl.getDefaultFuncCat(map2.values())) != null) {
                string2 = funcCat2.getColor();
            }
            funcCat.setColor(string2);
        }
        Collections.sort(arrayList, new FunctionCategoryComparator());
        this.functionCategoryMap.put(string, arrayList);
    }

    public Map getFunctionCategoryMap() {
        return this.functionCategoryMap;
    }

    public boolean isError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            logger.info(string);
            FunctionCategoryDownloader functionCategoryDownloader = new FunctionCategoryDownloader();
            functionCategoryDownloader.execute();
            if (functionCategoryDownloader.isError()) {
                logger.warn(functionCategoryDownloader.getErrorMessage());
            }
            Map map = functionCategoryDownloader.getFunctionCategoryMap();
            for (String string2 : map.keySet()) {
                List list = (List)map.get(string2);
                FunctionCategoryExporter functionCategoryExporter = new FunctionCategoryExporter(string2, list);
                functionCategoryExporter.setOutputDir(string);
                functionCategoryExporter.execute();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class CategoryNameDownloader
    extends SimpleServerConnection {
        private Map categoryNameMap = new HashMap();

        public CategoryNameDownloader() {
            this.setContextPath(OptionTbl.getInstance().getOptionValues().getGetDataUrl());
            this.setCondition();
        }

        @Override
        public void parseOutputString(int n, String string) {
            Vector vector = StringTool.splitString(string, "\t");
            int n2 = 0;
            if (vector.size() < 3) {
                return;
            }
            String string2 = (String)vector.get(n2++);
            boolean bl = false;
            if (vector.size() >= 5) {
                bl = ((String)vector.get(n2++)).equals("1");
            }
            String string3 = (String)vector.get(n2++);
            String string4 = (String)vector.get(n2++);
            FuncCat funcCat = new FuncCat();
            funcCat.setDefaultFlag(bl);
            funcCat.setFunctionCategoryNo(string3);
            funcCat.setName(string4);
            HashMap<String, FuncCat> hashMap = (HashMap<String, FuncCat>)this.categoryNameMap.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<String, FuncCat>();
                this.categoryNameMap.put(string2, hashMap);
            }
            hashMap.put(string3, funcCat);
        }

        private void setCondition() {
            String string = "table=category&no_header=1";
            this.setOptions(string);
        }

        public Map getCategoryNameMap() {
            return this.categoryNameMap;
        }
    }

    private class CategoryColorDownloader
    extends SimpleServerConnection {
        private Map colorMap = new HashMap();

        public CategoryColorDownloader() {
            this.setContextPath(OptionTbl.getInstance().getOptionValues().getGetDataUrl());
            this.setCondition();
        }

        @Override
        public void parseOutputString(int n, String string) {
            Vector vector = StringTool.splitString(string, "\t");
            System.err.println(vector);
            if (vector.size() == 0) {
                return;
            }
            String string2 = (String)vector.get(0);
            String string3 = (String)vector.get(1);
            String string4 = "#" + (String)vector.get(2);
            HashMap<String, String> hashMap = (HashMap<String, String>)this.colorMap.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                this.colorMap.put(string2, hashMap);
            }
            hashMap.put(string3, string4);
        }

        private void setCondition() {
            String string = "table=category_color&no_header=1";
            this.setOptions(string);
        }

        public Map getColorMap() {
            return this.colorMap;
        }
    }
}

