/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.hcluster.PairDist;
import java.util.ArrayList;
import java.util.HashMap;

class ClusterNode {
    int id;
    String name;
    PairDist child;
    ClusterNode parent;
    int count;
    boolean isRoot;
    private static int totalNum;
    private static int leafNum;
    private static HashMap nameHash;
    private static ArrayList allNodes;

    static void clear() {
        totalNum = 0;
        leafNum = 0;
        nameHash = null;
        allNodes = null;
    }

    static ClusterNode createLeafNode(String string) {
        if (nameHash != null) {
            ClusterNode clusterNode = (ClusterNode)nameHash.get(string);
            if (clusterNode != null) {
                return clusterNode;
            }
        } else {
            nameHash = new HashMap(10000);
        }
        return new ClusterNode(string);
    }

    ClusterNode(String string) {
        this.name = string;
        this.count = 1;
        this.id = totalNum++;
        this.isRoot = true;
        nameHash.put(this.name, this);
        if (allNodes == null) {
            allNodes = new ArrayList(10000);
        }
        allNodes.add(this);
    }

    ClusterNode(PairDist pairDist) {
        this(pairDist.node1.name);
        this.child = pairDist;
        this.count = pairDist.node1.count + pairDist.node2.count;
        pairDist.node2.isRoot = false;
        pairDist.node1.isRoot = false;
        pairDist.node1.parent = pairDist.node2.parent = this;
    }

    void addChild(PairDist pairDist) {
        this.child = pairDist;
    }

    boolean isRoot() {
        return this.isRoot;
    }

    void replaceNode(ClusterNode clusterNode) {
        PairDist pairDist = clusterNode.parent.child;
        if (pairDist.node1 == clusterNode) {
            pairDist.node1 = this;
        } else if (pairDist.node2 == clusterNode) {
            pairDist.node2 = this;
        }
        this.parent = clusterNode.parent;
        this.isRoot = false;
        this.parent = null;
        clusterNode.child = null;
        clusterNode.isRoot = false;
    }

    public String toString() {
        return this.name + "(" + this.id + ")" + (this.isRoot ? ":R" : "");
    }

    public static void saveLeafNum() {
        leafNum = totalNum;
    }

    public static int totalNum() {
        return totalNum;
    }

    public static int leafNum() {
        return leafNum;
    }

    static void createNameHash(int n, float f) {
        nameHash = new HashMap(n, f);
    }

    static ClusterNode get(int n) {
        return (ClusterNode)allNodes.get(n);
    }
}

