/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.hcluster.ClusterNode;
import cgdp.recog.hcluster.ClusterTree;
import cgdp.recog.hcluster.DistMatrix;
import cgdp.recog.hcluster.HClustException;
import cgdp.recog.hcluster.Hcluster;
import cgdp.recog.propvect.CompressedPropVectArray;
import cgdp.recog.propvect.EquivMap;
import cgdp.recog.propvect.NumVectArray;
import cgdp.recog.propvect.PhyloPatArray;
import cgdp.recog.propvect.PropVectArray;

public class ExecClustering {
    static boolean verbose;
    static int scale;
    static int outformat;
    static double missdist;
    static double missdistRatio;
    static double cutoff;
    static double probcut;
    static boolean numeric;
    static boolean absFlag;
    static int disttype;
    static String filename;

    static void getArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.charAt(0) == '-') {
                char c = string.charAt(1);
                block0 : switch (c) {
                    case 's': {
                        scale = Integer.valueOf(string.substring(2));
                        break;
                    }
                    case 'c': {
                        cutoff = Double.valueOf(string.substring(2));
                        break;
                    }
                    case 'p': {
                        probcut = Double.valueOf(string.substring(2));
                        break;
                    }
                    case 'm': {
                        if (string.charAt(2) == 'r') {
                            missdistRatio = Double.valueOf(string.substring(3));
                            break;
                        }
                        if (!Character.isDigit(string.charAt(2))) break;
                        missdist = Double.valueOf(string.substring(2));
                        break;
                    }
                    case 'o': {
                        outformat = Integer.valueOf(string.substring(2));
                        break;
                    }
                    case 'd': {
                        switch (string.charAt(2)) {
                            case 'D': {
                                disttype = 2;
                                break block0;
                            }
                            case 'I': {
                                disttype = 3;
                                break block0;
                            }
                            case 'R': {
                                disttype = 0;
                                break block0;
                            }
                            case 'A': {
                                disttype = 1;
                                break block0;
                            }
                            case 'P': {
                                disttype = 4;
                            }
                        }
                        break;
                    }
                    case 'N': {
                        numeric = true;
                        break;
                    }
                    case 'v': {
                        verbose = true;
                        break;
                    }
                    case 'h': {
                        ExecClustering.usage();
                        System.exit(0);
                    }
                }
                continue;
            }
            filename = string;
        }
    }

    static void verboseMessage(String string) {
        if (verbose) {
            System.err.println(string);
        }
    }

    static void usage() {
        System.err.print("ExecClustering <infile> ");
        System.err.println("-s<scale> -c<cutoff> -p<probcut> -o{1|2|3} -d<D|I|R|P>");
    }

    public static void main(String[] stringArray) {
        boolean bl = true;
        ExecClustering.getArgs(stringArray);
        if (missdist == 0.0 && missdistRatio > 0.0 && cutoff <= 2.0 && (missdist = cutoff / missdistRatio) > 1.0) {
            missdist = 1.0;
        }
        ExecClustering.getArgs(stringArray);
        PropVectArray propVectArray = null;
        CompressedPropVectArray compressedPropVectArray = null;
        propVectArray = numeric ? new NumVectArray() : new PhyloPatArray();
        ExecClustering.verboseMessage("reading Data");
        try {
            propVectArray.readFromFile(filename);
            if (propVectArray == null) {
                System.err.println("Can't read file: " + filename);
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("Can't open file: " + filename);
            System.exit(1);
        }
        ExecClustering.verboseMessage("comparing phylopat vectors");
        if (bl) {
            compressedPropVectArray = propVectArray.doCompress();
            propVectArray = compressedPropVectArray;
        }
        DistMatrix distMatrix = new DistMatrix();
        try {
            propVectArray.compareAll(disttype, cutoff, probcut, distMatrix, verbose);
        }
        catch (HClustException hClustException) {
            System.err.println("Can't compareAll: " + filename);
            System.exit(1);
        }
        ExecClustering.verboseMessage("clustering");
        ClusterNode.saveLeafNum();
        distMatrix.createIndex(scale);
        Hcluster hcluster = new Hcluster(distMatrix, cutoff, missdist);
        hcluster.execute();
        if (bl) {
            EquivMap equivMap = compressedPropVectArray.createEquivMap();
            ClusterTree.equivTreeMap(equivMap);
        }
        hcluster.output(outformat);
    }

    static {
        scale = 10000;
        outformat = 0;
        missdistRatio = 0.95;
        cutoff = 2.0;
        probcut = 2.0;
        numeric = false;
        absFlag = false;
    }
}

