/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster.tree;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.hcluster.MergeAllItem;
import cgdp.recog.hcluster.ReleaseMergeItem;
import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.hcluster.tree.ClusterTreeRenderer;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.system.OS;
import cgdp.recog.tree.NodeConnection;
import cgdp.recog.tree.NodeUtil;
import cgdp.recog.tree.TreeContext;
import cgdp.recog.util.MathUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ClusterTreeMap
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    private MediatorImpl mediator;
    private OptionTbl optionTbl = OptionTbl.getInstance();
    private ClusterTbl clusterTbl;
    private BufferedImage treeImage;
    private int row;
    private int offsetStartRow = 0;
    private int rows;
    private double marginTop;
    private List nodeConnectionList = new ArrayList();
    private JCheckBoxMenuItem showDistMenuItem;

    public ClusterTreeMap(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.createComponent();
    }

    private void createComponent() {
        this.showDistMenuItem = new JCheckBoxMenuItem("Show Distance");
        this.showDistMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterTreeMap.this.optionTbl.getOptionValues().setShowTreeDistFromUpgma(ClusterTreeMap.this.showDistMenuItem.isSelected());
                ClusterTreeMap.this.createClusterTreeMap(0);
            }
        });
    }

    public void setMarginTop(double d) {
        this.marginTop = d;
    }

    public void resizeClusterTreeMap(Dimension dimension) {
        this.rows = dimension.height / this.optionTbl.getOptionValues().getMinClusterH();
        if (this.treeImage == null || dimension.width != this.treeImage.getWidth() || dimension.height != this.treeImage.getHeight()) {
            this.deleteTreeImage();
            this.initTreeImage(dimension);
        }
        if (this.clusterTbl != null) {
            boolean bl;
            int n;
            boolean bl2 = this.mediator.isClusterTreeScrollBarVisible();
            int n2 = n = this.optionTbl.getOptionValues().isIntensive() ? this.clusterTbl.getViewOrderList().size() : this.clusterTbl.getViewClusterList().size();
            if (n > 0) {
                if (n > this.rows) {
                    BoundedRangeModel boundedRangeModel;
                    this.row = this.mediator.isClusterTreeScrollBarVisible() ? ((boundedRangeModel = (BoundedRangeModel)this.mediator.getClusterTreeScrollBarModel()).getValue() + this.rows > n ? n - this.rows : boundedRangeModel.getValue()) : 0;
                    bl = true;
                } else {
                    this.row = 0;
                    bl = false;
                }
            } else {
                this.row = 0;
                bl = false;
            }
            this.mediator.setClusterTreeScrollBar(bl, this.row, this.rows, n);
            if (bl2 == bl) {
                this.draw(true);
                this.repaint();
            }
        } else {
            this.clearTreeImage();
            this.repaint();
        }
    }

    private void deleteTreeImage() {
        if (this.treeImage == null) {
            return;
        }
        this.treeImage.flush();
        this.treeImage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTreeImage() {
        if (this.treeImage == null) {
            return;
        }
        BufferedImage bufferedImage = this.treeImage;
        synchronized (bufferedImage) {
            Graphics graphics = this.treeImage.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.treeImage.getWidth(), this.treeImage.getHeight());
            graphics.dispose();
        }
    }

    private void initTreeImage(Dimension dimension) {
        this.treeImage = new BufferedImage(dimension.width, dimension.height + (int)this.marginTop, 1);
        this.clearTreeImage();
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    private boolean isShowScrollBar(List list) {
        return list.size() > this.rows;
    }

    public void createClusterTreeMap() {
        this.createClusterTreeMap(this.row);
    }

    public void createClusterTreeMap(int n) {
        boolean bl;
        this.row = n;
        if (this.clusterTbl == null) {
            return;
        }
        boolean bl2 = this.mediator.isClusterTreeScrollBarVisible();
        if (this.optionTbl.getOptionValues().isIntensive()) {
            List list = this.clusterTbl.getViewOrderList();
            bl = this.isShowScrollBar(list);
            this.mediator.setClusterTreeScrollBar(bl, this.row, this.rows, list.size());
        } else {
            List list = this.clusterTbl.getViewClusterList();
            bl = this.isShowScrollBar(list);
            this.mediator.setClusterTreeScrollBar(bl, this.row, this.rows, list.size());
        }
        if (bl2 == bl) {
            this.draw(true);
            this.repaint();
        }
    }

    public void setRow(int n) {
        this.row = n;
        this.draw();
        this.repaint();
    }

    public void setOffsetStartRow(int n) {
        this.offsetStartRow = n;
    }

    public int getOffsetStartRow() {
        return this.offsetStartRow;
    }

    public void drawPdf(Graphics graphics) {
        List list = (List)this.mediator.getClusterMapDrawInfo();
        double d = (Double)list.get(3);
        TreeContext treeContext = TreeContext.createTreeContext(this.treeImage.getWidth(), this.treeImage.getHeight(), d, 0, this.clusterTbl.getRowCount(), 0.0);
        this.draw(graphics, treeContext, false);
    }

    private void draw() {
        this.draw(false);
    }

    private void draw(boolean bl) {
        if (this.treeImage == null) {
            return;
        }
        Graphics graphics = this.treeImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.treeImage.getWidth(), this.treeImage.getHeight());
        List list = (List)this.mediator.getClusterMapDrawInfo();
        double d = (Double)list.get(3);
        TreeContext treeContext = TreeContext.createTreeContext(this.treeImage.getWidth(), this.treeImage.getHeight(), d, this.row, this.rows, this.marginTop);
        treeContext.setOffsetStartRow(this.offsetStartRow);
        this.draw(graphics, treeContext, bl);
        graphics.dispose();
    }

    private void draw(Graphics graphics, TreeContext treeContext, boolean bl) {
        if (this.clusterTbl == null) {
            return;
        }
        List list = this.clusterTbl.getUpgmaRootNodeList();
        if (list == null) {
            return;
        }
        NodeUtil.setAggregateMode(this.optionTbl.getOptionValues().isIntensive(), list);
        ClusterTreeRenderer clusterTreeRenderer = new ClusterTreeRenderer(list, treeContext);
        if (bl) {
            clusterTreeRenderer.registerNodeConnection();
        }
        clusterTreeRenderer.draw((Graphics2D)graphics);
        if (bl) {
            this.nodeConnectionList = clusterTreeRenderer.getNodeConnectionList();
        }
    }

    private void drawScale(Graphics2D graphics2D, TreeContext treeContext) {
        double d = treeContext.getCanvasWidth() / 4.0;
        double d2 = treeContext.getScaleX();
        double d3 = MathUtil.roundDecimal(d / d2);
        d = d3 * d2;
        double d4 = treeContext.getScaleAreaHeight();
        int n = 2;
        int n2 = (int)(d + 2.0);
        int n3 = (int)(d4 - 2.0);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, (int)d, (int)d4);
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n, n3, n2, n3);
        graphics2D.drawLine(n, n3 - 2, n, n3);
        graphics2D.drawLine(n2, n3 - 2, n2, n3);
        Font font = graphics2D.getFont();
        float f = treeContext.getDistFontSize();
        Font font2 = font.deriveFont(f);
        graphics2D.setFont(font2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        String string = "0";
        String string2 = String.valueOf(d3);
        int n4 = fontMetrics.stringWidth(string);
        int n5 = fontMetrics.stringWidth(string2);
        if (d > (double)(n4 + n5)) {
            graphics2D.drawString("0", n, n3 - 2 - 1);
            graphics2D.drawString(String.valueOf(d3), n2 - n5, n3 - 2 - 1);
        } else if (d > (double)n5) {
            graphics2D.drawString(String.valueOf(d3), n2 - n5, n3 - 2 - 1);
        }
        graphics2D.setFont(font);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.treeImage != null) {
            graphics.drawImage(this.treeImage, 0, 0, null);
        }
    }

    private ClusterNode searchClusterNode(Point point) {
        ClusterNode clusterNode = null;
        for (NodeConnection nodeConnection : this.nodeConnectionList) {
            if (!nodeConnection.contains(point)) continue;
            clusterNode = (ClusterNode)nodeConnection.getNode();
        }
        return clusterNode;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        List list = (List)this.mediator.getClusterMapDrawInfo();
        double d = (Double)list.get(3);
        int n = (int)((double)this.row * d);
        Point point2 = new Point(point.x, point.y + n);
        ClusterNode clusterNode = this.searchClusterNode(point2);
        if (clusterNode == null) {
            return;
        }
        List list2 = NodeUtil.getLeafNodeList(clusterNode);
        HashSet<Map> hashSet = new HashSet<Map>();
        HashSet hashSet2 = new HashSet();
        for (ClusterNode clusterNode2 : list2) {
            hashSet.add(clusterNode2.getPatternMap());
            hashSet2.addAll(clusterNode2.getClusterSet());
        }
        this.mediator.updateSelectedCluster(null, hashSet2, false);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
        }
    }

    private void showPopup(Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.showDistMenuItem.setSelected(this.optionTbl.getOptionValues().isShowTreeDistFromUpgma());
        jPopupMenu.add(this.showDistMenuItem);
        if (!OptionTbl.getInstance().getOptionValues().isIntensive()) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(new MergeAllItem(this, this.mediator));
            if (this.clusterTbl.isExistHClustResult() && this.clusterTbl.isExistHClustMergedResult()) {
                jPopupMenu.add(new ReleaseMergeItem(this, this.mediator));
            }
        }
        jPopupMenu.show(this, point.x, point.y);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        List list = (List)this.mediator.getClusterMapDrawInfo();
        double d = (Double)list.get(3);
        int n = (int)((double)this.row * d);
        Point point2 = new Point(point.x, point.y + n);
        ClusterNode clusterNode = this.searchClusterNode(point2);
        if (clusterNode == null) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }
}

