/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.system.KeyBindUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollPane;

public class CategoryScrollPane
extends JScrollPane
implements ComponentListener,
MouseWheelListener {
    private MediatorImpl mediator;

    public CategoryScrollPane(MediatorImpl mediatorImpl, Component component) {
        super(component);
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.setBorder(null);
        this.setPreferredSize(new Dimension(200, 500));
        this.setMinimumSize(new Dimension(200, 200));
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
        this.addComponentListener(this);
        this.getViewport().addMouseWheelListener(this);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.mediator.resizeCategoryMap();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0) {
            if (KeyBindUtil.isKeyPressedForVerticalWheelZoom(mouseWheelEvent)) {
                this.mediator.verticalZoomClusterMap(mouseWheelEvent.getUnitsToScroll());
            } else if (KeyBindUtil.isKeyPressedForHorizontalWheelZoom(mouseWheelEvent)) {
                this.mediator.horizontalZoomClusterMap(mouseWheelEvent.getUnitsToScroll());
            } else {
                this.mediator.scrollCategoryMap(mouseWheelEvent.getUnitsToScroll());
            }
        }
    }
}

