/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.info.AnalysisUseType;
import cgdp.recog.info.InfoClass;
import cgdp.recog.info.InfoType;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.search.SearchCondType;
import cgdp.recog.util.StringTool;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class AbstractInfoTitle
implements Cloneable {
    public static final String TYPE_PREFIX = "(";
    public static final String TYPE_SUFFIX = ")";
    public static final String DELIMITER_TYPE = ",";
    public static final String DELIMITER_ENUM = ",";
    public static final String DELIMITER_HIERARCHY = ".";
    public static final String DELIMITER_MULTI_VALUE = ";";
    public static final String TYPE_INFO_NAME = "Name";
    public static final String TYPE_INFO_TYPE_NAME = "TypeName";
    public static final String TYPE_INFO_MULTI = "Multi";
    public static final String TYPE_INFO_ELEMENT_LIST = "ElementList";
    private int cls = -1;
    private String key;
    private String name;
    private int category = 0;
    private int type = 2;
    private String locationName = "Global";
    private boolean editable = true;
    private boolean serverSearchEnable = false;
    private int searchEqualType = 1;
    private Map useAnalysisMap = new HashMap();
    private boolean multi = false;
    private List elementList = new ArrayList();
    private int infoType = -1;
    private Set domClustIdSet = new HashSet();
    private boolean cacheNeed = false;
    private int multiElementType = 1;
    private int multiInfoType = 1;
    private int naInfoType = 1;
    private double naInfoSpecValue = 0.0;
    private int naElementType = 1;
    private double naElementSpecValue = 0.0;

    public int getCls() {
        return this.cls;
    }

    protected void setCls(int n) {
        this.cls = n;
    }

    public boolean isGene() {
        return InfoClass.isGene(this.getCls());
    }

    public boolean isCluster() {
        return InfoClass.isCluster(this.getCls());
    }

    public boolean isCell() {
        return InfoClass.isCell(this.getCls());
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int n) {
        this.category = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List getElementList() {
        return this.elementList;
    }

    public void setElementList(List list) {
        this.elementList = list;
    }

    public int indexOfElement(Object object) {
        return this.elementList.indexOf(object);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setTypeName(String string) {
        this.type = InfoType.getTypeIndex(string);
    }

    public String getTypeName() {
        return InfoType.getTypeName(this.getType());
    }

    public String getDisplayTypeName() {
        String string = this.getTypeName();
        if (this.isEnum()) {
            string = string + TYPE_PREFIX + StringTool.conbineStrList(this.getElementList(), ",") + TYPE_SUFFIX;
        }
        return string;
    }

    public boolean isNumeric() {
        return InfoType.isNumeric(this.getType());
    }

    public boolean isCharacter() {
        return InfoType.isCharactor(this.getType());
    }

    public boolean isEnum() {
        return InfoType.isEnum(this.getType());
    }

    public boolean isHierarchy() {
        return InfoType.isHierarchy(this.getType());
    }

    public Object getValueAsType(Object object) {
        if (this.isMulti()) {
            return String.valueOf(object);
        }
        if (this.isNumeric()) {
            return new Float(String.valueOf(object));
        }
        if (this.isCharacter()) {
            return String.valueOf(object);
        }
        if (this.isEnum()) {
            return String.valueOf(object);
        }
        if (this.isHierarchy()) {
            return String.valueOf(object);
        }
        return object;
    }

    public void setLocationName(String string) {
        this.locationName = string;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public boolean equalsLocation(String string) {
        return this.getLocationName().equals(string);
    }

    public String getDisplayLocationName() {
        String string = this.getLocationName();
        if (!this.isEditable()) {
            string = string + "(uneditable)";
        }
        return string;
    }

    public boolean equalsKey(String string) {
        return this.getKey().toLowerCase().equals(string.toLowerCase());
    }

    public boolean equalsKeyPrefix(String string) {
        return this.getKey().toLowerCase().startsWith(string.toLowerCase());
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean bl) {
        this.multi = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void setServerSearchEnable(boolean bl) {
        this.serverSearchEnable = bl;
    }

    public boolean isServerSearchEnable() {
        return this.serverSearchEnable;
    }

    public int getSearchEqualType() {
        return this.searchEqualType;
    }

    public boolean isSearchEqual() {
        return SearchCondType.isEqualTypeEqual(this.getSearchEqualType());
    }

    public boolean isSearchInclude() {
        return SearchCondType.isEqualTypeInclude(this.getSearchEqualType());
    }

    public void setSearchEqualType(int n) {
        this.searchEqualType = n;
    }

    protected static int getSearchEqualTypeFromType(int n) {
        return InfoType.isNumeric(n) ? 1 : 2;
    }

    public static List splitHierarchyData(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Vector vector = StringTool.splitString(string, DELIMITER_HIERARCHY);
        for (String string2 : vector) {
            try {
                arrayList.add(new Integer(string2));
            }
            catch (NumberFormatException numberFormatException) {
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public String combineMultiData(List list) {
        return StringTool.conbineStrList(list, DELIMITER_MULTI_VALUE);
    }

    public List splitMultiData(Object object) {
        return AbstractInfoTitle.splitMultiData(object, this.getType());
    }

    public static List splitMultiData(Object object, int n) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        Vector vector = StringTool.splitString(String.valueOf(object), DELIMITER_MULTI_VALUE);
        if (InfoType.isNumeric(n)) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new Float((String)iterator.next()));
            }
        } else {
            arrayList.addAll(vector);
        }
        return arrayList;
    }

    public boolean validateData(Object object) {
        if (object == null) {
            return true;
        }
        if (StringTool.isNull(String.valueOf(object))) {
            return true;
        }
        if (this.isNumeric() && object != null && !StringTool.isNull(String.valueOf(object))) {
            try {
                if (this.isMulti()) {
                    this.splitMultiData(object);
                } else {
                    new Float(String.valueOf(object));
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateColumnName(String string) {
        int n = string.indexOf(TYPE_PREFIX);
        int n2 = string.lastIndexOf(TYPE_SUFFIX);
        if (n != -1) {
            int n3;
            String string2;
            if (n2 == -1) {
                return false;
            }
            String string3 = string.substring(n + 1, n2).trim();
            n = string3.indexOf(TYPE_PREFIX);
            n2 = string3.lastIndexOf(TYPE_SUFFIX);
            if (n != -1) {
                if (n2 == -1) {
                    return false;
                }
                String string4 = string3.substring(0, n).trim();
                if (!InfoType.isEnumName(string4)) {
                    return false;
                }
                string2 = string3.substring(n + 1, n2).trim();
                if (StringTool.isNull(string2)) {
                    return false;
                }
                string3 = string4 + string3.substring(n2 + 1).trim();
            }
            if ((n3 = string3.indexOf(",")) != -1) {
                string2 = string3.substring(n3 + 1, string3.length()).trim();
                string3 = string3.substring(0, n3).trim();
                if (!InfoType.isMulti(string2)) {
                    return false;
                }
            }
            if (!InfoType.isTypeKeyword(string3)) {
                return false;
            }
        }
        return true;
    }

    public static String getTitleName(String string) {
        String string2 = string.trim();
        int n = string2.indexOf(TYPE_PREFIX);
        if (n != -1) {
            string2 = string2.substring(0, string2.indexOf(TYPE_PREFIX));
        }
        return string2;
    }

    public static boolean isEnum(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        int n = string.indexOf(TYPE_PREFIX);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(0, n).trim();
        return InfoType.isEnumName(string2);
    }

    public static List getEnumElementList(String string) {
        AbstractList abstractList = new ArrayList();
        if (StringTool.isNull(string)) {
            return abstractList;
        }
        int n = string.indexOf(TYPE_PREFIX);
        int n2 = string.lastIndexOf(TYPE_SUFFIX);
        if (n == -1) {
            return abstractList;
        }
        String string2 = string.substring(n + 1, n2).trim();
        abstractList = StringTool.splitString(string2, ",");
        return abstractList;
    }

    public String getTypeString() {
        return AbstractInfoTitle.getTypeString(this);
    }

    private static String getTypeString(AbstractInfoTitle abstractInfoTitle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(abstractInfoTitle.getTypeName());
        if (abstractInfoTitle.isEnum()) {
            stringBuffer.append(TYPE_PREFIX);
            stringBuffer.append(StringTool.conbineStrList(abstractInfoTitle.getElementList(), ","));
            stringBuffer.append(TYPE_SUFFIX);
        }
        if (abstractInfoTitle.isMulti()) {
            stringBuffer.append(",");
            stringBuffer.append(TYPE_INFO_MULTI);
        }
        return stringBuffer.toString();
    }

    public static String getNameTypeString(AbstractInfoTitle abstractInfoTitle, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(abstractInfoTitle.getName());
        } else {
            stringBuffer.append(abstractInfoTitle.getKey());
        }
        stringBuffer.append(TYPE_PREFIX);
        stringBuffer.append(AbstractInfoTitle.getTypeString(abstractInfoTitle));
        stringBuffer.append(TYPE_SUFFIX);
        return stringBuffer.toString();
    }

    public static Map createNameTypeInfo(String string) {
        Map<String, Boolean> map;
        String string2 = string.trim();
        String string3 = null;
        boolean bl = false;
        List list = null;
        int n = string.indexOf(TYPE_PREFIX);
        int n2 = string.lastIndexOf(TYPE_SUFFIX);
        if (n != -1 && n2 != -1) {
            string2 = string.substring(0, n).trim();
            string3 = string.substring(n + 1, n2).trim();
            map = AbstractInfoTitle.createTypeInfo(string3);
            string3 = (String)map.get(TYPE_INFO_TYPE_NAME);
            list = (List)map.get(TYPE_INFO_ELEMENT_LIST);
            bl = (Boolean)map.get(TYPE_INFO_MULTI);
        } else {
            string3 = "Char";
            list = null;
            bl = false;
        }
        map = new HashMap<String, String>();
        map.put(TYPE_INFO_NAME, (Boolean)((Object)string2));
        map.put(TYPE_INFO_TYPE_NAME, (Boolean)((Object)string3));
        map.put(TYPE_INFO_ELEMENT_LIST, (Boolean)((Object)list));
        map.put(TYPE_INFO_MULTI, new Boolean(bl));
        return map;
    }

    public static Map createTypeInfo(String string) {
        int n;
        Object object;
        String string2 = string;
        boolean bl = false;
        Vector vector = null;
        int n2 = string2.indexOf(TYPE_PREFIX);
        int n3 = string2.lastIndexOf(TYPE_SUFFIX);
        if (n2 != -1) {
            if (n3 == -1) {
                return null;
            }
            String string3 = string2.substring(0, n2).trim();
            if (!InfoType.isEnumName(string3)) {
                return null;
            }
            object = string2.substring(n2 + 1, n3).trim();
            if (StringTool.isNull((String)object)) {
                return null;
            }
            string2 = string3 + string2.substring(n3 + 1).trim();
            vector = StringTool.splitString((String)object, ",");
        }
        if ((n = string2.indexOf(",")) != -1) {
            object = string2.substring(n + 1, string2.length()).trim();
            string2 = string2.substring(0, n).trim();
            if (!InfoType.isMulti((String)object)) {
                return null;
            }
            bl = true;
        }
        if (!InfoType.isTypeKeyword(string2)) {
            string2 = "Char";
            vector = null;
            bl = false;
        }
        object = new HashMap<String, String>();
        object.put(TYPE_INFO_TYPE_NAME, string2);
        object.put(TYPE_INFO_ELEMENT_LIST, vector);
        object.put(TYPE_INFO_MULTI, new Boolean(bl));
        return object;
    }

    public void setUseAnalysis(String string, boolean bl) {
        this.useAnalysisMap.put(string, new Boolean(bl));
    }

    public boolean isUseAnalysis(String string) {
        if (AnalysisUseType.isUseAllAnalysis(string)) {
            return true;
        }
        Boolean bl = (Boolean)this.useAnalysisMap.get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public Set getDomClustIdSet() {
        return this.domClustIdSet;
    }

    public void setDomClustIdSet(Set set) {
        this.domClustIdSet = set;
    }

    public void addDomClustId(String string) {
        this.domClustIdSet.add(string);
    }

    public boolean containsDomClustId(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        if (LocationType.isNameGlobal(this.getLocationName()) || LocationType.isNameSystem(this.getLocationName())) {
            return true;
        }
        return this.getDomClustIdSet().contains(string);
    }

    public void setInfoType(int n) {
        this.infoType = n;
    }

    public int getInfoType() {
        return this.infoType;
    }

    public boolean isInfoTypeAll() {
        return ClusterInfoType.isAll(this.getInfoType());
    }

    public boolean isInfoTypeHomCluster() {
        return ClusterInfoType.isHomCluster(this.getInfoType());
    }

    public boolean isInfoTypeCluster() {
        return ClusterInfoType.isCluster(this.getInfoType());
    }

    public boolean isInfoTypeSubCluster() {
        return ClusterInfoType.isSubCluster(this.getInfoType());
    }

    public void setCacheNeed(boolean bl) {
        System.err.println(">>" + this.key + " " + bl);
        this.cacheNeed = bl;
    }

    public boolean isCacheNeed() {
        return this.cacheNeed;
    }

    public int getMultiElementType() {
        return this.multiElementType;
    }

    public void setMultiElementType(int n) {
        this.multiElementType = n;
    }

    public int getMultiInfoType() {
        return this.multiInfoType;
    }

    public void setMultiInfoType(int n) {
        this.multiInfoType = n;
    }

    public int getNaInfoType() {
        return this.naInfoType;
    }

    public void setNaInfoType(int n) {
        this.naInfoType = n;
    }

    public double getNaInfoSpecValue() {
        return this.naInfoSpecValue;
    }

    public void setNaInfoSpecValue(double d) {
        this.naInfoSpecValue = d;
    }

    public int getNaElementType() {
        return this.naElementType;
    }

    public void setNaElementType(int n) {
        this.naElementType = n;
    }

    public double getNaElementSpecValue() {
        return this.naElementSpecValue;
    }

    public void setNaElementSpecValue(double d) {
        this.naElementSpecValue = d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractInfoTitle)) {
            return false;
        }
        AbstractInfoTitle abstractInfoTitle = (AbstractInfoTitle)object;
        return this.equalsKey(abstractInfoTitle.getKey());
    }

    public int hashCode() {
        return this.getKey().toLowerCase().hashCode();
    }

    public String toString() {
        return this.getKey();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }
}

