/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cell;

import cgdp.recog.bean.Const;
import cgdp.recog.info.AbstractInfoConfImporter;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoType;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CellInfoConfImporter
extends AbstractInfoConfImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(CellInfoConfImporter.class);
    protected static final String DELIMITER_DOMCLUST_ID = ",";

    public CellInfoConfImporter() {
        this(Const.USER_CELL_INFO_PATH);
    }

    public CellInfoConfImporter(String string) {
        this.setFilepath(string);
    }

    @Override
    protected void parseDataLine(int n, String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        Vector vector = StringTool.splitString(string, "\t");
        CellInfoTitle cellInfoTitle = new CellInfoTitle();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.get(i);
            String string3 = (String)this.columnNameList.get(i);
            this.setValue(string3, string2, cellInfoTitle);
        }
        this.infoTitleList.add(cellInfoTitle);
    }

    private void setValue(String string, String string2, CellInfoTitle cellInfoTitle) {
        boolean bl = this.setAnalysisOptions(string, string2, cellInfoTitle);
        if (bl) {
            return;
        }
        bl = this.setCalcOptions(string, string2, cellInfoTitle);
        if (bl) {
            return;
        }
        if (string.equals("Name")) {
            cellInfoTitle.setName(string2);
        } else if (string.equals("Key")) {
            cellInfoTitle.setKey(string2);
        } else if (string.equals("Type")) {
            Map map = AbstractInfoTitle.createTypeInfo(string2);
            String string3 = (String)map.get("TypeName");
            boolean bl2 = (Boolean)map.get("Multi");
            List list = (List)map.get("ElementList");
            cellInfoTitle.setType(InfoType.getTypeIndex(string3));
            cellInfoTitle.setMulti(bl2);
            cellInfoTitle.setElementList(list);
        } else if (string.equals("Category")) {
            cellInfoTitle.setCategory(Integer.parseInt(string2));
        } else if (string.equals("Location")) {
            cellInfoTitle.setLocationName(string2);
        } else if (string.equals("ClusterInfoType")) {
            cellInfoTitle.setInfoType(Integer.parseInt(string2));
        } else if (string.equals("Editable")) {
            cellInfoTitle.setEditable(new Boolean(string2));
        } else if (string.equals("NeedCache")) {
            cellInfoTitle.setCacheNeed(new Boolean(string2));
        } else if (string.equals("SearchEqualType")) {
            cellInfoTitle.setSearchEqualType(Integer.parseInt(string2));
        } else if (string.equals("ServerSearchEnable")) {
            cellInfoTitle.setServerSearchEnable(new Boolean(string2));
        } else if (string.equals("DomClust ID")) {
            Vector vector = StringTool.splitString(string2, DELIMITER_DOMCLUST_ID);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                cellInfoTitle.addDomClustId((String)iterator.next());
            }
        }
    }
}

