/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cell;

import cgdp.recog.bean.Const;
import cgdp.recog.data.Cluster;
import cgdp.recog.info.AbstractInfoConfImporter;
import cgdp.recog.info.AbstractInfoManager;
import cgdp.recog.info.cell.CellInfo;
import cgdp.recog.info.cell.CellInfoConfExporter;
import cgdp.recog.info.cell.CellInfoConfImporter;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.info.cell.CellInfoUtil;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.MapUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CellInfoManager
extends AbstractInfoManager {
    private static final ApplicationLogger logger = new ApplicationLogger(CellInfoManager.class);
    private static final CellInfoManager CELL_INFO_MANAGER = new CellInfoManager();
    private Map cellInfoMap = new HashMap();

    private CellInfoManager() {
    }

    public static CellInfoManager getInstance() {
        return CELL_INFO_MANAGER;
    }

    @Override
    public void clear() {
        this.cellInfoMap = new HashMap();
        super.clear();
    }

    public void addCellInfo(Map map, Collection collection) {
        for (String string : map.keySet()) {
            Map map2 = (Map)map.get(string);
            this.addCellInfo(string, map2, collection);
        }
    }

    private void addCellInfo(String string, Map map, Collection collection) {
        HashMap<String, CellInfo> hashMap = (HashMap<String, CellInfo>)this.cellInfoMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, CellInfo>(map);
            this.cellInfoMap.put(string, hashMap);
        } else {
            for (String string2 : map.keySet()) {
                CellInfo cellInfo = (CellInfo)map.get(string2);
                CellInfo cellInfo2 = (CellInfo)hashMap.get(string2);
                if (cellInfo2 == null) {
                    cellInfo2 = new CellInfo();
                    hashMap.put(string2, cellInfo2);
                }
                cellInfo2.putAllInfo(cellInfo);
            }
        }
        this.addCachedInfoTitle(collection);
    }

    @Override
    public void removeCachedInfo(Collection collection) {
        for (String string : this.cellInfoMap.keySet()) {
            Map map = (Map)this.cellInfoMap.get(string);
            if (MapUtil.isNull(map)) continue;
            for (String string2 : map.keySet()) {
                CellInfo cellInfo = (CellInfo)map.get(string2);
                if (cellInfo == null) continue;
                cellInfo.removeAllInfo(collection);
            }
        }
        this.removeCachedInfoTitle(collection);
    }

    public Object getValue(String string, Cluster cluster, CellInfoTitle cellInfoTitle) {
        String string2 = CellInfoUtil.getClusterInfoKey(cluster, cellInfoTitle.getInfoType());
        Map map = (Map)this.cellInfoMap.get(string2);
        if (MapUtil.isNull(map)) {
            return null;
        }
        CellInfo cellInfo = (CellInfo)map.get(string);
        if (cellInfo == null) {
            return null;
        }
        return cellInfo.getInfo(cellInfoTitle);
    }

    @Override
    protected FileExporter createInfoTitleExporter(List list) {
        return new CellInfoConfExporter(list);
    }

    @Override
    protected AbstractInfoConfImporter createInfoTitleImporter(String string) {
        return new CellInfoConfImporter(string);
    }

    @Override
    protected String getConfFilepath() {
        return Const.USER_CELL_INFO_PATH;
    }
}

