/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cell;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.AbstractMultiInfoManager;
import cgdp.recog.info.InfoComparator;
import cgdp.recog.info.MultiInfoCondition;
import cgdp.recog.info.MultiValueCondition;
import cgdp.recog.info.cell.CellInfo;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MapUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CellInfoMultiInfoManager
extends AbstractMultiInfoManager {
    private CellInfoMultiInfoManager() {
    }

    public static Comparable getRepresentativeValue(MultiValueCondition multiValueCondition, Cluster cluster, Map map) {
        return CellInfoMultiInfoManager.getRepresentativeValue(multiValueCondition, multiValueCondition.getInfoTitle(), cluster, map);
    }

    public static Comparable getRepresentativeValue(MultiValueCondition multiValueCondition, AbstractInfoTitle abstractInfoTitle, Cluster cluster, Map map) {
        if (!(cluster instanceof SuperCluster)) {
            return CellInfoMultiInfoManager.getValue(multiValueCondition, abstractInfoTitle, cluster, map);
        }
        Comparable comparable = null;
        SuperCluster superCluster = (SuperCluster)cluster;
        List list = CellInfoMultiInfoManager.getCellInfoList(superCluster.getSubClusterList(), (CellInfoTitle)multiValueCondition.getInfoTitle(), map);
        if (CollectionUtil.isNull(list)) {
            return comparable;
        }
        if (multiValueCondition.isMultiElementMax()) {
            CellInfo cellInfo = (CellInfo)Collections.max(list, new InfoComparator(multiValueCondition.getInfoTitle()));
            comparable = CellInfoMultiInfoManager.getValue(multiValueCondition, abstractInfoTitle, cellInfo);
        } else if (multiValueCondition.isMultiElementMin()) {
            CellInfo cellInfo = (CellInfo)Collections.min(list, new InfoComparator(multiValueCondition.getInfoTitle()));
            comparable = CellInfoMultiInfoManager.getValue(multiValueCondition, abstractInfoTitle, cellInfo);
        } else if (multiValueCondition.isMultiElementMedian()) {
            Collections.sort(list, new InfoComparator(multiValueCondition.getInfoTitle()));
            int n = list.size();
            if (n % 2 == 0 && abstractInfoTitle.isNumeric()) {
                int n2 = (int)((double)n / 2.0) - 1;
                n2 = n2 < 0 ? 0 : n2;
                int n3 = (int)((double)n / 2.0);
                CellInfo cellInfo = (CellInfo)list.get(n2);
                CellInfo cellInfo2 = (CellInfo)list.get(n3);
                Number number = (Number)((Object)CellInfoMultiInfoManager.getValue(multiValueCondition, abstractInfoTitle, cellInfo));
                Number number2 = (Number)((Object)CellInfoMultiInfoManager.getValue(multiValueCondition, abstractInfoTitle, cellInfo2));
                comparable = null;
                if (number != null && number2 != null) {
                    comparable = new Float((number.doubleValue() + number2.doubleValue()) / 2.0);
                } else if (number != null && number2 == null) {
                    comparable = new Float(number.doubleValue());
                } else if (number == null && number2 != null) {
                    comparable = new Float(number2.doubleValue());
                }
            } else {
                int n4 = (int)((double)n / 2.0);
                CellInfo cellInfo = (CellInfo)list.get(n4);
                comparable = CellInfoMultiInfoManager.getValue(multiValueCondition, abstractInfoTitle, cellInfo);
            }
        } else if (multiValueCondition.isMultiElementAve()) {
            List list2 = CellInfoMultiInfoManager.getValueList(list, multiValueCondition.getInfoTitle());
            comparable = CollectionUtil.isNull(list2) ? null : new Float(CollectionUtil.average(list2));
        }
        return comparable;
    }

    private static List getCellInfoList(List list, CellInfoTitle cellInfoTitle, Map map) {
        ArrayList<CellInfo> arrayList = new ArrayList<CellInfo>();
        for (Cluster cluster : list) {
            CellInfo cellInfo = (CellInfo)map.get(cluster);
            if (cellInfo == null || !cellInfo.containsTitle(cellInfoTitle)) continue;
            arrayList.add(cellInfo);
        }
        return arrayList;
    }

    private static List getValueList(List list, AbstractInfoTitle abstractInfoTitle) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (CellInfo cellInfo : list) {
            Float f = (Float)cellInfo.getInfo(abstractInfoTitle);
            arrayList.add(f);
        }
        return arrayList;
    }

    public static Comparable getValue(MultiInfoCondition multiInfoCondition, AbstractInfoTitle abstractInfoTitle, Cluster cluster, Map map) {
        if (MapUtil.isNull(map)) {
            return null;
        }
        AbstractInfo abstractInfo = (AbstractInfo)map.get(cluster);
        return CellInfoMultiInfoManager.getValue(multiInfoCondition, abstractInfoTitle, abstractInfo);
    }
}

