/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTabPanel;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoDeleteRequestExecuter;
import cgdp.recog.info.InfoEditDialog;
import cgdp.recog.info.InfoListDialog;
import cgdp.recog.info.InfoTitleTableCellRenderer;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.gene.GeneDownloadDialog;
import cgdp.recog.info.gene.GeneInfoDeleteRequestExecuter;
import cgdp.recog.info.gene.GeneInfoDownloadExecuter;
import cgdp.recog.info.gene.GeneInfoEditExecuter;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoTitleTableModel;
import cgdp.recog.info.gene.GeneInfoUploadExecuter;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.UploadDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GeneInfoTabPanel
extends AbstractInfoTabPanel
implements MouseListener {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoTabPanel.class);
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private JTable infoTable;

    public GeneInfoTabPanel(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private void createComponents() {
        Serializable serializable;
        this.infoTable = new JTable(new GeneInfoTitleTableModel());
        this.infoTable.addMouseListener(this);
        TableColumnModel tableColumnModel = this.infoTable.getColumnModel();
        for (int i = 0; i < this.infoTable.getColumnCount(); ++i) {
            serializable = tableColumnModel.getColumn(i);
            serializable.setCellRenderer(new InfoTitleTableCellRenderer());
        }
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(50);
        this.infoTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GeneInfoTabPanel.this.setEnabledButton();
            }
        });
        serializable = new JScrollPane(this.infoTable, 20, 30);
        this.setShowAddButton(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)serializable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getControlButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setEnabledButton();
    }

    public void updateValue(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        List list = this.getGeneInfoTitleList();
        GeneInfoTitleTableModel geneInfoTitleTableModel = this.getGeneInfoTitleTableModel();
        geneInfoTitleTableModel.setGeneInfoTitleList(list);
    }

    private List getGeneInfoTitleList() {
        List list = GeneInfoFacade.getGeneInfoTitleList();
        Project project = ProjectAccesser.getSelectedProject();
        if (project.isServer()) {
            try {
                List list2 = GeneInfoFacade.downloadGeneInfoTitleList(null, project);
                list.addAll(list2);
            }
            catch (Exception exception) {
                String string = "Fail to load gene property from server.";
                logger.warn(string, exception);
                MessageManager.showErrorMessage(this.parent, string);
            }
        }
        return list;
    }

    @Override
    protected void setEnabledButton(int n) {
        super.setEnabledButton(n);
        if (n == -1) {
            this.downloadButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.uploadButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(this.enableDelete());
            GeneInfoTitleTableModel geneInfoTitleTableModel = this.getGeneInfoTitleTableModel();
            AbstractInfoTitle abstractInfoTitle = geneInfoTitleTableModel.getInfoTitle(n);
            if (LocationType.isNameServer(abstractInfoTitle.getLocationName())) {
                this.downloadButton.setEnabled(true);
                this.editButton.setEnabled(true);
                this.uploadButton.setEnabled(false);
            } else {
                this.downloadButton.setEnabled(false);
                this.editButton.setEnabled(true);
                this.uploadButton.setEnabled(abstractInfoTitle.isEditable());
            }
        }
    }

    private List getSelectedGeneInfoTitleList() {
        ArrayList<AbstractInfoTitle> arrayList = new ArrayList<AbstractInfoTitle>();
        int[] nArray = this.infoTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return arrayList;
        }
        GeneInfoTitleTableModel geneInfoTitleTableModel = this.getGeneInfoTitleTableModel();
        for (int i = 0; i < nArray.length; ++i) {
            AbstractInfoTitle abstractInfoTitle = geneInfoTitleTableModel.getInfoTitle(nArray[i]);
            arrayList.add(abstractInfoTitle);
        }
        return arrayList;
    }

    private List getSelectedServerGeneInfoTitleList() {
        List list = this.getSelectedGeneInfoTitleList();
        return InfoUtil.getServerInfoTitleList(list);
    }

    private GeneInfoTitleTableModel getGeneInfoTitleTableModel() {
        GeneInfoTitleTableModel geneInfoTitleTableModel = (GeneInfoTitleTableModel)this.infoTable.getModel();
        return geneInfoTitleTableModel;
    }

    private void setEnabledButton() {
        int n = this.infoTable.getSelectedRow();
        this.setEnabledButton(n);
    }

    @Override
    protected void add() {
    }

    private boolean enableDelete() {
        List list = this.getSelectedGeneInfoTitleList();
        if (CollectionUtil.isNull(list)) {
            return false;
        }
        List list2 = InfoUtil.getServerInfoTitleList(list);
        return CollectionUtil.isNull(list2) || list2.size() == list.size();
    }

    @Override
    protected void delete() {
        if (!this.enableDelete()) {
            return;
        }
        List list = this.getSelectedGeneInfoTitleList();
        List list2 = InfoUtil.getServerInfoTitleList(list);
        List list3 = InfoUtil.getLocalInfoTitleList(list);
        if (list.size() == list2.size()) {
            Object[] objectArray = new String[]{"Delete the following properties from server?", InfoUtil.createInfoTitleNameString(list2)};
            if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
                return;
            }
            GeneInfoDeleteRequestExecuter geneInfoDeleteRequestExecuter = new GeneInfoDeleteRequestExecuter(this, list2);
            geneInfoDeleteRequestExecuter.setAfterRunnable(new InfoDeleteRequestExecuter.InfoDeleteAfterRunnable(){

                @Override
                public void run() {
                    GeneInfoTabPanel.this.updateValue(GeneInfoTabPanel.this.clusterTbl);
                }
            });
            new ProgressDialog((Dialog)this.parent, this.mediator, 1, "Delete gene property...", false, (ProcessImpl)geneInfoDeleteRequestExecuter);
        } else if (list.size() == list3.size()) {
            int[] nArray = this.infoTable.getSelectedRows();
            GeneInfoTitleTableModel geneInfoTitleTableModel = this.getGeneInfoTitleTableModel();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                AbstractInfoTitle abstractInfoTitle = geneInfoTitleTableModel.getInfoTitle(nArray[i]);
                stringBuffer.append(abstractInfoTitle.getName());
                if (i == nArray.length - 1) continue;
                stringBuffer.append(",");
            }
            Object[] objectArray = new String[]{"Delete the following gene propeties?", stringBuffer.toString()};
            if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                AbstractInfoTitle abstractInfoTitle = geneInfoTitleTableModel.getInfoTitle(nArray[i]);
                this.addDeleteInfoTitle(abstractInfoTitle);
            }
            geneInfoTitleTableModel.remove(nArray);
        }
    }

    @Override
    protected void edit() {
        int n = this.infoTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        GeneInfoTitleTableModel geneInfoTitleTableModel = this.getGeneInfoTitleTableModel();
        AbstractInfoTitle abstractInfoTitle = geneInfoTitleTableModel.getInfoTitle(n);
        List list = geneInfoTitleTableModel.getGeneInfoTitleList();
        InfoEditDialog infoEditDialog = InfoListDialog.getInfoEditDialog();
        infoEditDialog.updateValue(abstractInfoTitle, list, this);
        infoEditDialog.setVisible(true);
    }

    @Override
    protected void download() {
        Object object;
        Cloneable cloneable2;
        List list = this.getSelectedServerGeneInfoTitleList();
        GeneDownloadDialog geneDownloadDialog = new GeneDownloadDialog((Dialog)this.parent);
        Project project = ProjectAccesser.getSelectedProject();
        List list2 = InfoUtil.getInfoTitleNameList(list);
        geneDownloadDialog.updateValue(project.getProjectName(), list2);
        geneDownloadDialog.setVisible(true);
        if (geneDownloadDialog.isCanceled()) {
            return;
        }
        String string = geneDownloadDialog.getLocationString();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Cloneable cloneable2 : list) {
            object = (GeneInfoTitle)cloneable2.clone();
            ((AbstractInfoTitle)object).setLocationName(string);
            ((AbstractInfoTitle)object).setEditable(true);
            Set set = ((GeneInfoTitle)object).getOrganismCodeSet();
            set.retainAll(project.getOrganismCodeList());
            ((GeneInfoTitle)object).setOrganismCodeSet(set);
            arrayList.add(object);
        }
        List list3 = GeneInfoFacade.getGeneInfoTitleList();
        if (!GeneInfoFacade.validateInfoTitle(this, arrayList, list3)) {
            return;
        }
        cloneable2 = new HashSet(project.getOrganismCodeList());
        object = new GeneInfoDownloadExecuter(this, arrayList, (Collection)((Object)cloneable2), project);
        ((GeneInfoDownloadExecuter)object).setLocation(string);
        ((AbstractThreadProcess)object).setAfterRunnable(new Runnable(){

            @Override
            public void run() {
                GeneInfoTabPanel.this.updateValue(GeneInfoTabPanel.this.clusterTbl);
            }
        });
        new ProgressDialog((Dialog)this.parent, this.mediator, 1, "Download gene property...", false, (ProcessImpl)object);
    }

    @Override
    protected void upload() {
        List list = this.getSelectedGeneInfoTitleList();
        if (CollectionUtil.isNull(list)) {
            return;
        }
        List list2 = InfoUtil.getInfoTitleNameList(list);
        UploadDialog uploadDialog = UploadDialog.createInstance(this.parent);
        uploadDialog.updateValue("gene property", list2);
        uploadDialog.setVisible(true);
        if (uploadDialog.isCanceled()) {
            return;
        }
        GeneInfoUploadExecuter geneInfoUploadExecuter = new GeneInfoUploadExecuter(this.parent, list);
        geneInfoUploadExecuter.setAfterRunnable(new Runnable(){

            @Override
            public void run() {
                GeneInfoTabPanel.this.updateValue(GeneInfoTabPanel.this.clusterTbl);
            }
        });
        new ProgressDialog((Dialog)this.parent, this.mediator, 1, "Upload gene property...", false, (ProcessImpl)geneInfoUploadExecuter);
    }

    @Override
    public boolean check() {
        return true;
    }

    @Override
    protected void updateParameters() {
        if (CollectionUtil.isNull(this.newInfoTitleSet) && CollectionUtil.isNull(this.editInfoTitleSet) && CollectionUtil.isNull(this.deleteInfoTitleSet)) {
            return;
        }
        List list = this.getGeneInfoTitleTableModel().getGeneInfoTitleList();
        List list2 = InfoUtil.getLocalInfoTitleList(list);
        GeneInfoEditExecuter geneInfoEditExecuter = new GeneInfoEditExecuter(this, this.mediator, list2, this.newInfoTitleSet, this.editInfoTitleSet, this.deleteInfoTitleSet);
        geneInfoEditExecuter.execute(new DummyProgressComponent());
        geneInfoEditExecuter.done();
    }

    @Override
    public void updateTable(AbstractInfoTitle abstractInfoTitle) {
        int n = this.getGeneInfoTitleTableModel().indexOf(abstractInfoTitle);
        if (n == -1) {
            return;
        }
        this.getGeneInfoTitleTableModel().fireTableRowsUpdated(n, n);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.editButton.doClick();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

