/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.data.Chromosome;
import cgdp.recog.data.Contig;
import cgdp.recog.mapping.MapRecode;
import cgdp.recog.util.ListControlTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class MapRecodeContigTableModel
extends AbstractTableModel
implements ListControlTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Contig", "Chr."};
    private List mapRecodeList = new ArrayList();

    MapRecodeContigTableModel() {
    }

    public void setMapRecodeList(List list) {
        this.mapRecodeList = list;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        return this.mapRecodeList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        MapRecode mapRecode = (MapRecode)this.mapRecodeList.get(n);
        if (n2 == 0) {
            Contig contig = mapRecode.getContig();
            return contig.getDisplayName();
        }
        if (n2 == 1) {
            Chromosome chromosome = mapRecode.getChromosome();
            if (chromosome == null) {
                return "";
            }
            return chromosome.getName();
        }
        return null;
    }

    @Override
    public void addData(Object object) {
        this.mapRecodeList.add(object);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount());
    }

    @Override
    public Object getData(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            throw new IllegalArgumentException("[ERROR:ListSelectTableModel]:Index is invalid.");
        }
        return this.mapRecodeList.get(n);
    }

    @Override
    public int indexOf(Object object) {
        MapRecode mapRecode = (MapRecode)object;
        int n = 0;
        for (MapRecode mapRecode2 : this.mapRecodeList) {
            if (mapRecode2.equalsContig(mapRecode)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public Object removeData(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            throw new IllegalArgumentException("[ERROR:ListSelectTableModel]:Index is invalid.");
        }
        Object e = this.mapRecodeList.remove(n);
        this.fireTableRowsDeleted(this.getRowCount() - 1, this.getRowCount());
        return e;
    }

    @Override
    public void swapData(int n, int n2) {
        Collections.swap(this.mapRecodeList, n, n2);
    }
}

