/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mgmap;

import cgdp.recog.option.OptionTbl;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;

class ClusterIdColorDialog
extends AbstractApplyDialog {
    private FocusTextField fromTextField;
    private FocusTextField toTextField;
    private RestrictTextField clusterIdTextField;

    public ClusterIdColorDialog(Dialog dialog) {
        super(dialog);
        this.createComponent();
    }

    private void createComponent() {
        this.setTitle("Cluster ID Color Setting");
        this.setModal(true);
        this.setResizable(false);
        JLabel jLabel = new JLabel("Color Range:");
        JLabel jLabel2 = new JLabel("-");
        this.fromTextField = new FocusTextField();
        this.toTextField = new FocusTextField();
        JLabel jLabel3 = new JLabel("Number of Cluster ID:");
        this.clusterIdTextField = new RestrictTextField(6);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.fromTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.toTextField, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)jLabel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.clusterIdTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.updateValue();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateValue() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        this.fromTextField.setText(optionTbl.getOptionValues().getClusterFrom());
        this.toTextField.setText(optionTbl.getOptionValues().getClusterTo());
        this.clusterIdTextField.setText(String.valueOf(optionTbl.getOptionValues().getClusterCount()));
    }

    int getClusterFrom() {
        return ClusterIdColorDialog.getColorEelment(this.fromTextField.getText());
    }

    int getClusterTo() {
        return ClusterIdColorDialog.getColorEelment(this.toTextField.getText());
    }

    int getClusterCount() {
        String string = this.clusterIdTextField.getText();
        return Integer.parseInt(string);
    }

    private static int getColorEelment(String string) {
        String string2 = string.substring(1);
        try {
            return Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    protected boolean check() {
        int n;
        String string = this.fromTextField.getText();
        if (StringTool.isNull(string)) {
            MessageManager.showErrorMessage((Component)this, "Please input [Color Range].");
            return false;
        }
        if (!this.checkColorString(string)) {
            MessageManager.showErrorMessage((Component)this, "Please input the value from #000000 to #ffffff into [Color Range].");
            return false;
        }
        String string2 = this.toTextField.getText();
        if (StringTool.isNull(string2)) {
            MessageManager.showErrorMessage((Component)this, "Please input [Color Range].");
            return false;
        }
        if (!this.checkColorString(string2)) {
            MessageManager.showErrorMessage((Component)this, "Please input the value from #000000 to #ffffff into [Color Range].");
            return false;
        }
        String string3 = this.clusterIdTextField.getText();
        if (StringTool.isNull(string3)) {
            MessageManager.showErrorMessage((Component)this, "Please input [Number of Cluster ID].");
            return false;
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            MessageManager.showErrorMessage((Component)this, "Please input the numerical value into [Number of Cluster ID].");
            return false;
        }
        if (n < 1) {
            MessageManager.showErrorMessage((Component)this, "[Number of Cluster ID] is too small.");
            return false;
        }
        return true;
    }

    private boolean checkColorString(String string) {
        if (!string.startsWith("#")) {
            return false;
        }
        if (string.length() != 7) {
            return false;
        }
        String string2 = string.substring(1);
        try {
            Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }
}

