/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.option.ColorTableModel;
import cgdp.recog.util.ColorTableCellRenderer;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ColorTable
extends JTable
implements MouseListener {
    public ColorTable() {
        this.init();
    }

    private void init() {
        this.setModel(new ColorTableModel());
        this.addMouseListener(this);
        this.setRowHeight(20);
        this.setTableHeader(null);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new ColorTableCellRenderer());
    }

    public void setColorList(List list) {
        ColorTableModel colorTableModel = this.getColorTableModel();
        colorTableModel.setColorList(list);
    }

    public List getColorList() {
        ColorTableModel colorTableModel = this.getColorTableModel();
        return colorTableModel.getColorList();
    }

    public void addColor(Color color) {
        ColorTableModel colorTableModel = this.getColorTableModel();
        colorTableModel.addColor(color);
    }

    public void deleteSelectedColors() {
        int[] nArray = this.getSelectedRows();
        ColorTableModel colorTableModel = this.getColorTableModel();
        colorTableModel.deleteColor(nArray);
    }

    public void upSelectedColors() {
        int[] nArray = this.getSelectedRows();
        if (this.isEmptyArray(nArray)) {
            return;
        }
        if (nArray[0] == 0) {
            return;
        }
        ColorTableModel colorTableModel = this.getColorTableModel();
        colorTableModel.upColors(nArray);
        this.clearSelection();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            int n = nArray[i] - 1;
            this.addRowSelectionInterval(n, n);
        }
    }

    public void downSelectedColors() {
        int[] nArray = this.getSelectedRows();
        if (this.isEmptyArray(nArray)) {
            return;
        }
        Arrays.sort(nArray);
        if (nArray[nArray.length - 1] == this.getRowCount() - 1) {
            return;
        }
        ColorTableModel colorTableModel = this.getColorTableModel();
        colorTableModel.downColors(nArray);
        this.clearSelection();
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] == this.getRowCount() - 1) continue;
            int n = nArray[i] + 1;
            this.addRowSelectionInterval(n, n);
        }
    }

    private boolean isEmptyArray(int[] nArray) {
        return nArray == null || nArray.length == 0;
    }

    private ColorTableModel getColorTableModel() {
        return (ColorTableModel)this.getModel();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 >= 0 && mouseEvent.getButton() == 1) {
            Color color = (Color)this.getValueAt(n, n2);
            Color color2 = JColorChooser.showDialog(this, "Color palette", color);
            ColorTableModel colorTableModel = this.getColorTableModel();
            colorTableModel.setColor(n, color2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

