/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.data.DataManager;
import cgdp.recog.organism.OrganismSet;
import cgdp.recog.organism.OrganismSetExporter;
import cgdp.recog.organism.OrganismSetImporter;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrganismSetGroup
implements ApplicationPropertyAccessable {
    private static final ApplicationLogger logger = new ApplicationLogger(OrganismSetGroup.class);
    private static final OrganismSetGroup ORGANISM_SET_GROUP = new OrganismSetGroup();
    private List organismSetList = new ArrayList();
    private Set organismCodeSet = new HashSet();

    public static OrganismSetGroup getInstance() {
        return ORGANISM_SET_GROUP;
    }

    public Set getOrganismCodeSet() {
        return this.organismCodeSet;
    }

    public void setOrganismCodeC(Collection collection) {
        this.organismCodeSet = new HashSet(collection);
    }

    public List getOrganismSetList() {
        return this.organismSetList;
    }

    public void setOrganismSetList(List list) {
        this.organismSetList = list;
    }

    public void addOrganismSet(OrganismSet organismSet) {
        boolean bl = false;
        String string = organismSet.getName();
        ArrayList<OrganismSet> arrayList = new ArrayList<OrganismSet>();
        for (OrganismSet organismSet2 : this.organismSetList) {
            if (string.equals(organismSet2.getName())) {
                arrayList.add(organismSet);
                bl = true;
                continue;
            }
            arrayList.add(organismSet2);
        }
        if (!bl) {
            this.organismSetList.add(organismSet);
        }
    }

    public boolean containsOrganismSet(String string) {
        return this.getOrganismSet(string) != null;
    }

    public OrganismSet getOrganismSet(String string) {
        for (OrganismSet organismSet : this.getOrganismSetList()) {
            if (!organismSet.equalsName(string)) continue;
            return organismSet;
        }
        return null;
    }

    public static OrganismSet createOrgansmSet(String string, List list) {
        OrganismSet organismSet = new OrganismSet();
        organismSet.setName(string);
        organismSet.setOrganismList(list);
        return organismSet;
    }

    public void removeOrganismFromOrganismSet(OrganismSet organismSet, Collection collection) {
        OrganismSet organismSet2 = this.getOrganismSet(organismSet.getName());
        organismSet2.removeOrganism(collection);
        if (!organismSet2.isExistOrganism()) {
            this.removeOrganism(organismSet2);
        }
    }

    public void removeOrganism(Collection collection) {
        this.organismSetList.removeAll(collection);
    }

    public void removeOrganism(OrganismSet organismSet) {
        this.organismSetList.remove(organismSet);
    }

    public static List importOrganismSetList(String string) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        String string2 = DataManager.getOrganismSetFilepath(project, string);
        if (!new File(string2).isFile()) {
            return new ArrayList();
        }
        OrganismSetImporter organismSetImporter = new OrganismSetImporter(string2);
        organismSetImporter.execute();
        return organismSetImporter.getOrganismSetList();
    }

    private List filterOrganismSetList(List list, Collection collection) {
        ArrayList<OrganismSet> arrayList = new ArrayList<OrganismSet>();
        for (OrganismSet organismSet : list) {
            if (!collection.containsAll(organismSet.getOrganismCodeList())) continue;
            arrayList.add(organismSet);
        }
        return arrayList;
    }

    private void saveOrganismSetList(Project project, String string, Collection collection) throws IOException {
        List list = OrganismSetGroup.importOrganismSetList(string);
        List list2 = this.filterOrganismSetList(list, collection);
        list.removeAll(list2);
        list.addAll(this.getOrganismSetList());
        String string2 = DataManager.getOrganismSetFilepath(project, string);
        OrganismSetExporter organismSetExporter = new OrganismSetExporter(list, string2);
        organismSetExporter.execute();
    }

    public void save(String string) {
        try {
            ApplicationPropertyFacade.saveProperty(string, this);
        }
        catch (IOException iOException) {
            String string2 = "Fail to save organism set.";
            logger.warn(string2, iOException);
        }
    }

    @Override
    public String getCategory() {
        return "OrganismSet";
    }

    @Override
    public List getPropertyList(Project project, String string) {
        try {
            this.saveOrganismSetList(project, string, this.organismCodeSet);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save organism set file. Project = " + project.getProjectName(), iOException);
        }
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "OrganismSetCondition", "organism_set"));
        return arrayList;
    }

    @Override
    public int getPropertyType() {
        return 2;
    }

    @Override
    public void updateProperty(Map map, Project project, String string) {
        try {
            List list = OrganismSetGroup.importOrganismSetList(string);
            list = this.filterOrganismSetList(list, this.getOrganismCodeSet());
            this.setOrganismSetList(list);
        }
        catch (IOException iOException) {
            logger.warn("Fail to load organism set file. Project = " + project.getProjectName(), iOException);
        }
    }

    public void clear() {
        this.organismCodeSet.clear();
        this.organismSetList.clear();
    }
}

