/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeAnalysis;
import cgdp.recog.coregenome.CoreGenomeAnalysisListDownloadExecuter;
import cgdp.recog.coregenome.CoreGenomeDownloadExecuter;
import cgdp.recog.coregenome.CoreGenomeImporter;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClustAnalysis;
import cgdp.recog.domclust.DomClustAnalysisListDownloadExecuter;
import cgdp.recog.domclust.DomClustDownloadExecuter;
import cgdp.recog.domclust.DomClustFileUtil;
import cgdp.recog.domclust.DomClustQuery;
import cgdp.recog.filefilter.FileExtension;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.project.AnalysisDownloadDialog;
import cgdp.recog.project.FileTableModel;
import cgdp.recog.project.FilterComboBoxModel;
import cgdp.recog.project.FilterComboBoxRenderer;
import cgdp.recog.project.MultiServerAnalysisDownloadExecuter;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.project.ProjectAnalysisType;
import cgdp.recog.project.ProjectComboBoxModel;
import cgdp.recog.project.ProjectComboBoxRenderer;
import cgdp.recog.project.ServerAnalysis;
import cgdp.recog.project.ServerAnalysisListDialog;
import cgdp.recog.project.ServerAnalysisRunnable;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.system.property.ApplicationPropertyVirtualFile;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.AlignmentTableCellRenderer;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileSizeComparator;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.ReadOnlyTextArea;
import cgdp.recog.util.StringTool;
import cgdp.recog.util.TableSorter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;

public class OpenDialog
extends AbstractApplyDialog
implements ItemListener,
MouseListener {
    private static final ApplicationLogger logger = new ApplicationLogger(OpenDialog.class);
    private static OpenDialog OPEN_DIALOG;
    private static final String TITLE = "Open Data";
    private static final Dimension DIALOG_SIZE;
    private MediatorImpl mediator;
    private JComboBox projectComboBox;
    private JButton downloadButton;
    private JTable fileTable;
    private ReadOnlyTextArea propertyArea;
    private JComboBox filterComboBox;

    private OpenDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createOpenDialog(Frame frame, MediatorImpl mediatorImpl) {
        OPEN_DIALOG = new OpenDialog(frame, mediatorImpl);
    }

    public static OpenDialog getInstance() {
        return OPEN_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createProjectPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.createFileTablePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.createFilterComboBox(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.initValue();
        this.setSize(DIALOG_SIZE);
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createProjectPanel() {
        JLabel jLabel = new JLabel("Project");
        ProjectComboBoxModel projectComboBoxModel = new ProjectComboBoxModel();
        this.projectComboBox = new JComboBox(projectComboBoxModel);
        this.projectComboBox.setRenderer(new ProjectComboBoxRenderer());
        this.projectComboBox.addItemListener(this);
        this.downloadButton = new JButton("Download");
        this.downloadButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.projectComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.downloadButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        return jPanel;
    }

    private JPanel createFileTablePanel() {
        FileTableModel fileTableModel = new FileTableModel();
        TableSorter tableSorter = new TableSorter(fileTableModel){

            @Override
            protected Comparator getComparator(int n) {
                if (n == 1) {
                    return new FileSizeComparator();
                }
                return super.getComparator(n);
            }
        };
        this.fileTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.fileTable.getTableHeader());
        this.fileTable.setRowHeight(20);
        this.fileTable.addMouseListener(this);
        this.fileTable.setShowHorizontalLines(false);
        this.fileTable.setShowVerticalLines(false);
        this.fileTable.setAutoResizeMode(0);
        TableColumn tableColumn = this.fileTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(180);
        TableColumn tableColumn2 = this.fileTable.getColumnModel().getColumn(1);
        tableColumn2.setCellRenderer(new AlignmentTableCellRenderer(4));
        tableColumn2.setPreferredWidth(70);
        TableColumn tableColumn3 = this.fileTable.getColumnModel().getColumn(2);
        tableColumn3.setPreferredWidth(120);
        this.fileTable.getSelectionModel().setSelectionMode(0);
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    File file = OpenDialog.this.getSelectedFile();
                    OpenDialog.this.updatePropertyPanel(file);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.fileTable, 20, 30);
        this.propertyArea = new ReadOnlyTextArea();
        this.propertyArea.setLineWrap(true);
        this.propertyArea.setColumns(50);
        JScrollPane jScrollPane2 = new JScrollPane(this.propertyArea, 20, 31);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 2.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jScrollPane2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JComboBox createFilterComboBox() {
        FilterComboBoxModel filterComboBoxModel = new FilterComboBoxModel();
        this.filterComboBox = new JComboBox(filterComboBoxModel);
        this.filterComboBox.setRenderer(new FilterComboBoxRenderer());
        this.filterComboBox.addItemListener(this);
        return this.filterComboBox;
    }

    public void updateValue() {
        int n;
        Object object;
        ItemListener[] itemListenerArray;
        Project project = ProjectAccesser.getSelectedProject();
        this.updateProjectList();
        if (project != null) {
            itemListenerArray = this.removeItemListenersFromProjectComboBox();
            object = this.getValidProjectFromComboBox(project);
            this.projectComboBox.setSelectedItem(object);
            this.addItemListenersToProjectComboBox(itemListenerArray);
        }
        itemListenerArray = this.getSelectedFile();
        this.updateFileList();
        if (itemListenerArray != null && (n = ((FileTableModel)(object = this.getFileTableModel())).indexOfFile((File)itemListenerArray)) != -1) {
            int n2 = this.getTableSorter().viewIndex(n);
            this.fileTable.setRowSelectionInterval(n, n2);
        }
        this.setEnableButton();
    }

    private FileTableModel getFileTableModel() {
        return (FileTableModel)((TableSorter)this.fileTable.getModel()).getTableModel();
    }

    private List getProjectList() {
        List list = ProjectAccesser.loadProject();
        return list;
    }

    private void initValue() {
        this.updateProjectList();
        Project project = ProjectAccesser.getSelectedProject();
        this.projectComboBox.setSelectedItem(this.getValidProjectFromComboBox(project));
        this.updateFileList();
    }

    private Project getValidProjectFromComboBox(Project project) {
        Project project2 = null;
        for (int i = 0; i < this.projectComboBox.getItemCount(); ++i) {
            Project project3 = (Project)this.projectComboBox.getItemAt(i);
            if (!project3.equalsProject(project)) continue;
            project2 = project3;
            break;
        }
        if (project2 == null && this.projectComboBox.getItemCount() != 0) {
            project2 = (Project)this.projectComboBox.getItemAt(0);
        }
        return project2;
    }

    private ItemListener[] removeItemListenersFromProjectComboBox() {
        ItemListener[] itemListenerArray = this.projectComboBox.getItemListeners();
        if (itemListenerArray == null) {
            return null;
        }
        for (int i = 0; i < itemListenerArray.length; ++i) {
            this.projectComboBox.removeItemListener(itemListenerArray[i]);
        }
        return itemListenerArray;
    }

    private void addItemListenersToProjectComboBox(ItemListener[] itemListenerArray) {
        if (itemListenerArray == null) {
            return;
        }
        for (int i = 0; i < itemListenerArray.length; ++i) {
            this.projectComboBox.addItemListener(itemListenerArray[i]);
        }
    }

    private void updateProjectList() {
        ItemListener[] itemListenerArray = this.removeItemListenersFromProjectComboBox();
        this.projectComboBox.removeAllItems();
        for (Project project : this.getProjectList()) {
            this.projectComboBox.addItem(project);
        }
        this.addItemListenersToProjectComboBox(itemListenerArray);
    }

    private void updateFileList() {
        Project project = (Project)this.projectComboBox.getSelectedItem();
        if (project == null) {
            return;
        }
        File file = new File(project.getDirectoryPath());
        List list = this.getFileList(project, file);
        FileFilter fileFilter = (FileFilter)this.filterComboBox.getSelectedItem();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : list) {
            if (!fileFilter.accept(file2)) continue;
            arrayList.add(file2);
        }
        FileTableModel fileTableModel = this.getFileTableModel();
        fileTableModel.setFileList(arrayList);
    }

    private List getFileList(Project project, File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!file.isDirectory()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(fileArray[i]);
        }
        Map map = ApplicationPropertyFacade.getConfDirnameMap(project);
        for (String string : map.keySet()) {
            ApplicationPropertyConf applicationPropertyConf = (ApplicationPropertyConf)map.get(string);
            String string2 = ApplicationPropertyFacade.getApplicationPropertyDirpath(project, applicationPropertyConf);
            if (!new File(string2).isDirectory()) continue;
            File file2 = DomClustFileUtil.findDomClustFileByViewId(applicationPropertyConf.getDomClustViewId(), project);
            String string3 = new File(file, applicationPropertyConf.getConfName() + ".dclst").getAbsolutePath();
            ApplicationPropertyVirtualFile applicationPropertyVirtualFile = new ApplicationPropertyVirtualFile(string3, file2, applicationPropertyConf);
            arrayList.add(applicationPropertyVirtualFile);
        }
        return arrayList;
    }

    private void updatePropertyPanel(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        if (FileExtension.isDomClustFile(file)) {
            if (file instanceof ApplicationPropertyVirtualFile) {
                stringBuffer.append(this.getDomClustProperties((ApplicationPropertyVirtualFile)file));
            } else {
                stringBuffer.append(this.getDomClustProperties(file));
            }
        } else if (FileExtension.isCoreGenomeFile(file)) {
            stringBuffer.append(this.getCoreGenomeProperties(file));
        }
        this.propertyArea.setText(stringBuffer.toString());
        this.propertyArea.repaint();
        this.propertyArea.setCaretPosition(0);
    }

    private String getDomClustProperties(ApplicationPropertyVirtualFile applicationPropertyVirtualFile) {
        try {
            ApplicationPropertyConf applicationPropertyConf = applicationPropertyVirtualFile.getConf();
            File file = applicationPropertyVirtualFile.getRealFile();
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(file.getAbsolutePath());
            abstractDomClustImporter.setParameterOnly(true);
            abstractDomClustImporter.execute();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cluster ID:");
            stringBuffer.append(abstractDomClustImporter.getDomClustId());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Comment:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(StringTool.displayNewLine2NewLine(applicationPropertyConf.getComment()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Cluster Count:");
            stringBuffer.append(abstractDomClustImporter.getNClusters());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Server:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + abstractDomClustImporter.getServerUrl());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            String string = DomClustQuery.createDisplayOptions(abstractDomClustImporter.getDomClustConditionString());
            stringBuffer.append("Options:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(string);
            ArrayList arrayList = new ArrayList(abstractDomClustImporter.getIngroupOrganismCodeList());
            Collections.sort(arrayList);
            stringBuffer.append("Ingroup(");
            stringBuffer.append(arrayList.size());
            stringBuffer.append("):");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + StringTool.conbineStrList(arrayList, ","));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            ArrayList arrayList2 = new ArrayList(abstractDomClustImporter.getOutgroupOrganismCodeList());
            Collections.sort(arrayList2);
            stringBuffer.append("Outgroup(");
            stringBuffer.append(arrayList2.size());
            stringBuffer.append("):");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + StringTool.conbineStrList(arrayList2, ","));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Created by:");
            stringBuffer.append(applicationPropertyConf.getCreateUser());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Created on:");
            stringBuffer.append(applicationPropertyConf.getCreateDate());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Updated by:");
            stringBuffer.append(applicationPropertyConf.getUpdateUser());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Updated on:");
            stringBuffer.append(applicationPropertyConf.getUpdateDate());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            logger.warn("Fail to get domclust properties.", iOException);
            return "";
        }
    }

    private String getDomClustProperties(File file) {
        try {
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(file.getAbsolutePath());
            abstractDomClustImporter.setParameterOnly(true);
            abstractDomClustImporter.execute();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cluster ID:");
            stringBuffer.append(abstractDomClustImporter.getDomClustId());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Cluster Count:");
            stringBuffer.append(abstractDomClustImporter.getNClusters());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Server:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + abstractDomClustImporter.getServerUrl());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            String string = DomClustQuery.createDisplayOptions(abstractDomClustImporter.getDomClustConditionString());
            stringBuffer.append("Options:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(string);
            ArrayList arrayList = new ArrayList(abstractDomClustImporter.getIngroupOrganismCodeList());
            Collections.sort(arrayList);
            stringBuffer.append("Ingroup(");
            stringBuffer.append(arrayList.size());
            stringBuffer.append("):");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + StringTool.conbineStrList(arrayList, ","));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            ArrayList arrayList2 = new ArrayList(abstractDomClustImporter.getOutgroupOrganismCodeList());
            Collections.sort(arrayList2);
            stringBuffer.append("Outgroup(");
            stringBuffer.append(arrayList2.size());
            stringBuffer.append("):");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + StringTool.conbineStrList(arrayList2, ","));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            logger.warn("Fail to get domclust properties.", iOException);
            return "";
        }
    }

    private String getCoreGenomeProperties(File file) {
        try {
            CoreGenomeImporter coreGenomeImporter = new CoreGenomeImporter(file.getAbsolutePath());
            coreGenomeImporter.setParameterOnly(true);
            coreGenomeImporter.execute();
            GenomeAlign genomeAlign = coreGenomeImporter.getGenomeAlign();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cluster ID:");
            stringBuffer.append(genomeAlign.getDomClustId());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Core Tab ID:");
            stringBuffer.append(genomeAlign.getCoreGenomeId());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Reference Genome:");
            stringBuffer.append(coreGenomeImporter.getReferenceOrganismCode());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Species:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(StringTool.conbineStrList(genomeAlign.getOrganismCodeList(), ","));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Server:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + coreGenomeImporter.getServerUrl());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            String string = DomClustQuery.createDisplayOptionsGeneric(coreGenomeImporter.getCoreAlignerConditionString());
            stringBuffer.append("Options:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            logger.warn("Fail to get core genome properties.", iOException);
            return "";
        }
    }

    public Project getSelectedProject() {
        return (Project)this.projectComboBox.getSelectedItem();
    }

    public File getSelectedFile() {
        int n = this.fileTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        FileTableModel fileTableModel = this.getFileTableModel();
        return fileTableModel.getFile(this.getTableSorter().modelIndex(n));
    }

    private TableSorter getTableSorter() {
        return (TableSorter)this.fileTable.getModel();
    }

    private void showServerAnalysisListDialog(final Project project) {
        MultiServerAnalysisDownloadExecuter multiServerAnalysisDownloadExecuter = new MultiServerAnalysisDownloadExecuter(this, project);
        multiServerAnalysisDownloadExecuter.addExeucuter(new DomClustAnalysisListDownloadExecuter(this, project, false));
        multiServerAnalysisDownloadExecuter.addExeucuter(new CoreGenomeAnalysisListDownloadExecuter(this, project));
        multiServerAnalysisDownloadExecuter.setAfterRunnable(new ServerAnalysisRunnable(){

            @Override
            public void run() {
                List list = this.getServerAnalysisList();
                OpenDialog.this.showServerAnalysisList(project, list);
            }
        });
        new ProgressDialog((Dialog)this, this.mediator, 1, "Download from server...", false, (ProcessImpl)multiServerAnalysisDownloadExecuter);
    }

    private void showServerAnalysisList(Project project, List list) {
        ServerAnalysisListDialog serverAnalysisListDialog = new ServerAnalysisListDialog((Dialog)this, this.mediator);
        serverAnalysisListDialog.updateValue(project, list);
        serverAnalysisListDialog.setVisible(true);
        if (serverAnalysisListDialog.isCanceled()) {
            return;
        }
        ServerAnalysis serverAnalysis = serverAnalysisListDialog.getSelectedServerAnalysis();
        if (ProjectAnalysisType.isDomClust(serverAnalysis.getAnalysisType())) {
            AnalysisDownloadDialog analysisDownloadDialog = AnalysisDownloadDialog.createInstance(this);
            analysisDownloadDialog.updateValue(serverAnalysis.getName());
            analysisDownloadDialog.setVisible(true);
            if (analysisDownloadDialog.isCanceled()) {
                return;
            }
            boolean bl = analysisDownloadDialog.isViewParameters();
            DomClustDownloadExecuter domClustDownloadExecuter = new DomClustDownloadExecuter(this, project, (DomClustAnalysis)serverAnalysis, bl);
            domClustDownloadExecuter.setAfterRunnable(new Runnable(){

                @Override
                public void run() {
                    OpenDialog.this.setEnableButton();
                    OpenDialog.this.updateFileList();
                }
            });
            new ProgressDialog((Dialog)this, this.mediator, 1, "Download domclust result...", false, (ProcessImpl)domClustDownloadExecuter);
        } else if (ProjectAnalysisType.isCore(serverAnalysis.getAnalysisType())) {
            String string = DomClustFileUtil.getDomClustViewId(serverAnalysis.getDomClustId(), serverAnalysis.getProject());
            if (StringTool.isNull(string)) {
                String[] stringArray = new String[]{"There is no domclust result corresponding to specified core genome alignment result.", "Please download domClust result."};
                MessageManager.showErrorMessage((Component)this, stringArray);
                return;
            }
            CoreGenomeDownloadExecuter coreGenomeDownloadExecuter = new CoreGenomeDownloadExecuter(this, (CoreGenomeAnalysis)serverAnalysis, string);
            coreGenomeDownloadExecuter.setAfterRunnable(new Runnable(){

                @Override
                public void run() {
                    OpenDialog.this.setEnableButton();
                    OpenDialog.this.updateFileList();
                }
            });
            new ProgressDialog((Dialog)this, this.mediator, 1, "Download core genome alignment result...", false, (ProcessImpl)coreGenomeDownloadExecuter);
        }
    }

    private void setEnableButton() {
        Project project = this.getSelectedProject();
        this.downloadButton.setEnabled(project.isServer());
    }

    @Override
    protected boolean check() {
        if (this.fileTable.getSelectedRow() == -1) {
            MessageManager.showErrorMessage((Component)this, "Select file.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.downloadButton) {
            Project project = this.getSelectedProject();
            this.showServerAnalysisListDialog(project);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.projectComboBox) {
            this.setEnableButton();
            this.updateFileList();
        } else if (itemEvent.getSource() == this.filterComboBox) {
            this.updateFileList();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.applyButton.doClick();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static {
        DIALOG_SIZE = new Dimension(600, 400);
    }
}

