/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.project.ProjectDownloadItem;
import cgdp.recog.project.ProjectListItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ProjectOpenMenu
extends JMenu
implements MenuListener,
ActionListener {
    private MediatorImpl mediator;

    public ProjectOpenMenu(MediatorImpl mediatorImpl) {
        super("Open Project");
        this.addMenuListener(this);
        this.mediator = mediatorImpl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof CommandImpl) {
            ((CommandImpl)actionEvent.getSource()).execute();
        }
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        this.removeAll();
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        List list = ProjectAccesser.loadProject();
        Project project = ProjectAccesser.getSelectedProject();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Project project2 : list) {
            ProjectMenuItem projectMenuItem = new ProjectMenuItem(this.mediator, project2);
            this.add(projectMenuItem);
            buttonGroup.add(projectMenuItem);
            projectMenuItem.addActionListener(this);
            projectMenuItem.setSelected(project2.equalsProject(project));
        }
        this.addSeparator();
        this.add(new ProjectDownloadItem(this, this.mediator));
        this.add(new ProjectListItem(this, this.mediator));
    }

    private class ProjectMenuItem
    extends JRadioButtonMenuItem
    implements CommandImpl {
        private MediatorImpl mediator;
        private Project project;

        public ProjectMenuItem(MediatorImpl mediatorImpl, Project project) {
            super(project.getProjectName());
            this.mediator = mediatorImpl;
            this.project = project;
        }

        @Override
        public void execute() {
            this.mediator.changeSelectProject(this.project);
        }
    }
}

